package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIDEEventDetail invokes the dataworks_public.GetIDEEventDetail API synchronously
func (client *Client) GetIDEEventDetail(request *GetIDEEventDetailRequest) (response *GetIDEEventDetailResponse, err error) {
	response = CreateGetIDEEventDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetIDEEventDetailWithChan invokes the dataworks_public.GetIDEEventDetail API asynchronously
func (client *Client) GetIDEEventDetailWithChan(request *GetIDEEventDetailRequest) (<-chan *GetIDEEventDetailResponse, <-chan error) {
	responseChan := make(chan *GetIDEEventDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIDEEventDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIDEEventDetailWithCallback invokes the dataworks_public.GetIDEEventDetail API asynchronously
func (client *Client) GetIDEEventDetailWithCallback(request *GetIDEEventDetailRequest, callback func(response *GetIDEEventDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIDEEventDetailResponse
		var err error
		defer close(result)
		response, err = client.GetIDEEventDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIDEEventDetailRequest is the request struct for api GetIDEEventDetail
type GetIDEEventDetailRequest struct {
	*requests.RpcRequest
	MessageId string           `position:"Body" name:"MessageId"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// GetIDEEventDetailResponse is the response struct for api GetIDEEventDetail
type GetIDEEventDetailResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	EventDetail EventDetail `json:"EventDetail" xml:"EventDetail"`
}

// CreateGetIDEEventDetailRequest creates a request to invoke GetIDEEventDetail API
func CreateGetIDEEventDetailRequest() (request *GetIDEEventDetailRequest) {
	request = &GetIDEEventDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetIDEEventDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetIDEEventDetailResponse creates a response to parse from GetIDEEventDetail response
func CreateGetIDEEventDetailResponse() (response *GetIDEEventDetailResponse) {
	response = &GetIDEEventDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
