package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelPickUpWaybill invokes the dyplsapi.CancelPickUpWaybill API synchronously
func (client *Client) CancelPickUpWaybill(request *CancelPickUpWaybillRequest) (response *CancelPickUpWaybillResponse, err error) {
	response = CreateCancelPickUpWaybillResponse()
	err = client.DoAction(request, response)
	return
}

// CancelPickUpWaybillWithChan invokes the dyplsapi.CancelPickUpWaybill API asynchronously
func (client *Client) CancelPickUpWaybillWithChan(request *CancelPickUpWaybillRequest) (<-chan *CancelPickUpWaybillResponse, <-chan error) {
	responseChan := make(chan *CancelPickUpWaybillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelPickUpWaybill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelPickUpWaybillWithCallback invokes the dyplsapi.CancelPickUpWaybill API asynchronously
func (client *Client) CancelPickUpWaybillWithCallback(request *CancelPickUpWaybillRequest, callback func(response *CancelPickUpWaybillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelPickUpWaybillResponse
		var err error
		defer close(result)
		response, err = client.CancelPickUpWaybill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelPickUpWaybillRequest is the request struct for api CancelPickUpWaybill
type CancelPickUpWaybillRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OuterOrderCode       string           `position:"Query" name:"OuterOrderCode"`
	CancelDesc           string           `position:"Query" name:"CancelDesc"`
	ContentType          string           `position:"Header" name:"Content-Type"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CancelPickUpWaybillResponse is the response struct for api CancelPickUpWaybill
type CancelPickUpWaybillResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCancelPickUpWaybillRequest creates a request to invoke CancelPickUpWaybill API
func CreateCancelPickUpWaybillRequest() (request *CancelPickUpWaybillRequest) {
	request = &CancelPickUpWaybillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "CancelPickUpWaybill", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelPickUpWaybillResponse creates a response to parse from CancelPickUpWaybill response
func CreateCancelPickUpWaybillResponse() (response *CancelPickUpWaybillResponse) {
	response = &CancelPickUpWaybillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
