package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BandwidthPackageAddAccelerator invokes the ga.BandwidthPackageAddAccelerator API synchronously
func (client *Client) BandwidthPackageAddAccelerator(request *BandwidthPackageAddAcceleratorRequest) (response *BandwidthPackageAddAcceleratorResponse, err error) {
	response = CreateBandwidthPackageAddAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// BandwidthPackageAddAcceleratorWithChan invokes the ga.BandwidthPackageAddAccelerator API asynchronously
func (client *Client) BandwidthPackageAddAcceleratorWithChan(request *BandwidthPackageAddAcceleratorRequest) (<-chan *BandwidthPackageAddAcceleratorResponse, <-chan error) {
	responseChan := make(chan *BandwidthPackageAddAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BandwidthPackageAddAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BandwidthPackageAddAcceleratorWithCallback invokes the ga.BandwidthPackageAddAccelerator API asynchronously
func (client *Client) BandwidthPackageAddAcceleratorWithCallback(request *BandwidthPackageAddAcceleratorRequest, callback func(response *BandwidthPackageAddAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BandwidthPackageAddAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.BandwidthPackageAddAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BandwidthPackageAddAcceleratorRequest is the request struct for api BandwidthPackageAddAccelerator
type BandwidthPackageAddAcceleratorRequest struct {
	*requests.RpcRequest
	BandwidthPackageId string `position:"Query" name:"BandwidthPackageId"`
	AcceleratorId      string `position:"Query" name:"AcceleratorId"`
}

// BandwidthPackageAddAcceleratorResponse is the response struct for api BandwidthPackageAddAccelerator
type BandwidthPackageAddAcceleratorResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	BandwidthPackageId string   `json:"BandwidthPackageId" xml:"BandwidthPackageId"`
	Accelerators       []string `json:"Accelerators" xml:"Accelerators"`
}

// CreateBandwidthPackageAddAcceleratorRequest creates a request to invoke BandwidthPackageAddAccelerator API
func CreateBandwidthPackageAddAcceleratorRequest() (request *BandwidthPackageAddAcceleratorRequest) {
	request = &BandwidthPackageAddAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "BandwidthPackageAddAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBandwidthPackageAddAcceleratorResponse creates a response to parse from BandwidthPackageAddAccelerator response
func CreateBandwidthPackageAddAcceleratorResponse() (response *BandwidthPackageAddAcceleratorResponse) {
	response = &BandwidthPackageAddAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
