package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceOriginalPropertyStatus invokes the iot.QueryDeviceOriginalPropertyStatus API synchronously
func (client *Client) QueryDeviceOriginalPropertyStatus(request *QueryDeviceOriginalPropertyStatusRequest) (response *QueryDeviceOriginalPropertyStatusResponse, err error) {
	response = CreateQueryDeviceOriginalPropertyStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceOriginalPropertyStatusWithChan invokes the iot.QueryDeviceOriginalPropertyStatus API asynchronously
func (client *Client) QueryDeviceOriginalPropertyStatusWithChan(request *QueryDeviceOriginalPropertyStatusRequest) (<-chan *QueryDeviceOriginalPropertyStatusResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceOriginalPropertyStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceOriginalPropertyStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceOriginalPropertyStatusWithCallback invokes the iot.QueryDeviceOriginalPropertyStatus API asynchronously
func (client *Client) QueryDeviceOriginalPropertyStatusWithCallback(request *QueryDeviceOriginalPropertyStatusRequest, callback func(response *QueryDeviceOriginalPropertyStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceOriginalPropertyStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceOriginalPropertyStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceOriginalPropertyStatusRequest is the request struct for api QueryDeviceOriginalPropertyStatus
type QueryDeviceOriginalPropertyStatusRequest struct {
	*requests.RpcRequest
	NextPageToken string           `position:"Query" name:"NextPageToken"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	Asc           requests.Integer `position:"Query" name:"Asc"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryDeviceOriginalPropertyStatusResponse is the response struct for api QueryDeviceOriginalPropertyStatus
type QueryDeviceOriginalPropertyStatusResponse struct {
	*responses.BaseResponse
	RequestId    string                                  `json:"RequestId" xml:"RequestId"`
	Success      bool                                    `json:"Success" xml:"Success"`
	Code         string                                  `json:"Code" xml:"Code"`
	ErrorMessage string                                  `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceOriginalPropertyStatus `json:"Data" xml:"Data"`
}

// CreateQueryDeviceOriginalPropertyStatusRequest creates a request to invoke QueryDeviceOriginalPropertyStatus API
func CreateQueryDeviceOriginalPropertyStatusRequest() (request *QueryDeviceOriginalPropertyStatusRequest) {
	request = &QueryDeviceOriginalPropertyStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceOriginalPropertyStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceOriginalPropertyStatusResponse creates a response to parse from QueryDeviceOriginalPropertyStatus response
func CreateQueryDeviceOriginalPropertyStatusResponse() (response *QueryDeviceOriginalPropertyStatusResponse) {
	response = &QueryDeviceOriginalPropertyStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
