package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCasterEpisodeGroup invokes the live.DeleteCasterEpisodeGroup API synchronously
func (client *Client) DeleteCasterEpisodeGroup(request *DeleteCasterEpisodeGroupRequest) (response *DeleteCasterEpisodeGroupResponse, err error) {
	response = CreateDeleteCasterEpisodeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCasterEpisodeGroupWithChan invokes the live.DeleteCasterEpisodeGroup API asynchronously
func (client *Client) DeleteCasterEpisodeGroupWithChan(request *DeleteCasterEpisodeGroupRequest) (<-chan *DeleteCasterEpisodeGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteCasterEpisodeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCasterEpisodeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCasterEpisodeGroupWithCallback invokes the live.DeleteCasterEpisodeGroup API asynchronously
func (client *Client) DeleteCasterEpisodeGroupWithCallback(request *DeleteCasterEpisodeGroupRequest, callback func(response *DeleteCasterEpisodeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCasterEpisodeGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteCasterEpisodeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCasterEpisodeGroupRequest is the request struct for api DeleteCasterEpisodeGroup
type DeleteCasterEpisodeGroupRequest struct {
	*requests.RpcRequest
	ProgramId string           `position:"Query" name:"ProgramId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCasterEpisodeGroupResponse is the response struct for api DeleteCasterEpisodeGroup
type DeleteCasterEpisodeGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCasterEpisodeGroupRequest creates a request to invoke DeleteCasterEpisodeGroup API
func CreateDeleteCasterEpisodeGroupRequest() (request *DeleteCasterEpisodeGroupRequest) {
	request = &DeleteCasterEpisodeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteCasterEpisodeGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCasterEpisodeGroupResponse creates a response to parse from DeleteCasterEpisodeGroup response
func CreateDeleteCasterEpisodeGroupResponse() (response *DeleteCasterEpisodeGroupResponse) {
	response = &DeleteCasterEpisodeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
