package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateProjectTask invokes the teambition_aliyun.UpdateProjectTask API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/updateprojecttask.html
func (client *Client) UpdateProjectTask(request *UpdateProjectTaskRequest) (response *UpdateProjectTaskResponse, err error) {
	response = CreateUpdateProjectTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateProjectTaskWithChan invokes the teambition_aliyun.UpdateProjectTask API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/updateprojecttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateProjectTaskWithChan(request *UpdateProjectTaskRequest) (<-chan *UpdateProjectTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateProjectTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateProjectTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateProjectTaskWithCallback invokes the teambition_aliyun.UpdateProjectTask API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/updateprojecttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateProjectTaskWithCallback(request *UpdateProjectTaskRequest, callback func(response *UpdateProjectTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateProjectTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateProjectTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateProjectTaskRequest is the request struct for api UpdateProjectTask
type UpdateProjectTaskRequest struct {
	*requests.RpcRequest
	Note                   string           `position:"Body" name:"Note"`
	Visible                string           `position:"Body" name:"Visible"`
	ExecutorId             string           `position:"Body" name:"ExecutorId"`
	TaskFlowStatusId       string           `position:"Body" name:"TaskFlowStatusId"`
	ScenarioFiieldConfigId string           `position:"Body" name:"ScenarioFiieldConfigId"`
	StartDate              string           `position:"Body" name:"StartDate"`
	Priority               requests.Integer `position:"Body" name:"Priority"`
	ParentTaskId           string           `position:"Body" name:"ParentTaskId"`
	OrgId                  string           `position:"Body" name:"OrgId"`
	Content                string           `position:"Body" name:"Content"`
	SprintId               string           `position:"Body" name:"SprintId"`
	DueDate                string           `position:"Body" name:"DueDate"`
	ProjectId              string           `position:"Body" name:"ProjectId"`
	TaskId                 string           `position:"Body" name:"TaskId"`
}

// UpdateProjectTaskResponse is the response struct for api UpdateProjectTask
type UpdateProjectTaskResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateUpdateProjectTaskRequest creates a request to invoke UpdateProjectTask API
func CreateUpdateProjectTaskRequest() (request *UpdateProjectTaskRequest) {
	request = &UpdateProjectTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "UpdateProjectTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateProjectTaskResponse creates a response to parse from UpdateProjectTask response
func CreateUpdateProjectTaskResponse() (response *UpdateProjectTaskResponse) {
	response = &UpdateProjectTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
