// This file is generated by "./lib/proto/generate"

package proto

/*

DOMStorage

Query and modify DOM storage.

*/

// DOMStorageSerializedStorageKey ...
type DOMStorageSerializedStorageKey string

// DOMStorageStorageID DOM Storage identifier.
type DOMStorageStorageID struct {
	// SecurityOrigin (optional) Security origin for the storage.
	SecurityOrigin string `json:"securityOrigin,omitempty"`

	// StorageKey (optional) Represents a key by which DOM Storage keys its CachedStorageAreas
	StorageKey DOMStorageSerializedStorageKey `json:"storageKey,omitempty"`

	// IsLocalStorage Whether the storage is local storage (not session storage).
	IsLocalStorage bool `json:"isLocalStorage"`
}

// DOMStorageItem DOM Storage item.
type DOMStorageItem []string

// DOMStorageClear ...
type DOMStorageClear struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`
}

// ProtoReq name
func (m DOMStorageClear) ProtoReq() string { return "DOMStorage.clear" }

// Call sends the request
func (m DOMStorageClear) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMStorageDisable Disables storage tracking, prevents storage events from being sent to the client.
type DOMStorageDisable struct{}

// ProtoReq name
func (m DOMStorageDisable) ProtoReq() string { return "DOMStorage.disable" }

// Call sends the request
func (m DOMStorageDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMStorageEnable Enables storage tracking, storage events will now be delivered to the client.
type DOMStorageEnable struct{}

// ProtoReq name
func (m DOMStorageEnable) ProtoReq() string { return "DOMStorage.enable" }

// Call sends the request
func (m DOMStorageEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMStorageGetDOMStorageItems ...
type DOMStorageGetDOMStorageItems struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`
}

// ProtoReq name
func (m DOMStorageGetDOMStorageItems) ProtoReq() string { return "DOMStorage.getDOMStorageItems" }

// Call the request
func (m DOMStorageGetDOMStorageItems) Call(c Client) (*DOMStorageGetDOMStorageItemsResult, error) {
	var res DOMStorageGetDOMStorageItemsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMStorageGetDOMStorageItemsResult ...
type DOMStorageGetDOMStorageItemsResult struct {
	// Entries ...
	Entries []DOMStorageItem `json:"entries"`
}

// DOMStorageRemoveDOMStorageItem ...
type DOMStorageRemoveDOMStorageItem struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`

	// Key ...
	Key string `json:"key"`
}

// ProtoReq name
func (m DOMStorageRemoveDOMStorageItem) ProtoReq() string { return "DOMStorage.removeDOMStorageItem" }

// Call sends the request
func (m DOMStorageRemoveDOMStorageItem) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMStorageSetDOMStorageItem ...
type DOMStorageSetDOMStorageItem struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`

	// Key ...
	Key string `json:"key"`

	// Value ...
	Value string `json:"value"`
}

// ProtoReq name
func (m DOMStorageSetDOMStorageItem) ProtoReq() string { return "DOMStorage.setDOMStorageItem" }

// Call sends the request
func (m DOMStorageSetDOMStorageItem) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMStorageDomStorageItemAdded ...
type DOMStorageDomStorageItemAdded struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`

	// Key ...
	Key string `json:"key"`

	// NewValue ...
	NewValue string `json:"newValue"`
}

// ProtoEvent name
func (evt DOMStorageDomStorageItemAdded) ProtoEvent() string {
	return "DOMStorage.domStorageItemAdded"
}

// DOMStorageDomStorageItemRemoved ...
type DOMStorageDomStorageItemRemoved struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`

	// Key ...
	Key string `json:"key"`
}

// ProtoEvent name
func (evt DOMStorageDomStorageItemRemoved) ProtoEvent() string {
	return "DOMStorage.domStorageItemRemoved"
}

// DOMStorageDomStorageItemUpdated ...
type DOMStorageDomStorageItemUpdated struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`

	// Key ...
	Key string `json:"key"`

	// OldValue ...
	OldValue string `json:"oldValue"`

	// NewValue ...
	NewValue string `json:"newValue"`
}

// ProtoEvent name
func (evt DOMStorageDomStorageItemUpdated) ProtoEvent() string {
	return "DOMStorage.domStorageItemUpdated"
}

// DOMStorageDomStorageItemsCleared ...
type DOMStorageDomStorageItemsCleared struct {
	// StorageID ...
	StorageID *DOMStorageStorageID `json:"storageId"`
}

// ProtoEvent name
func (evt DOMStorageDomStorageItemsCleared) ProtoEvent() string {
	return "DOMStorage.domStorageItemsCleared"
}
