source "docker" "autogenerated_1" {
  discard     = true
  image       = "ubuntu"
  run_command = ["-d", "-i", "-t", "-u", "42", "{{ .Image }}", "/bin/sh"]
}

build {
  sources = ["source.docker.autogenerated_1"]

  provisioner "file" {
    destination = "/tmp/strawberry-cake"
    source      = "test-fixtures/onecakes/strawberry"
  }

  provisioner "file" {
    destination = "/tmp/"
    source      = "test-fixtures/manycakes"
  }

  provisioner "shell" {
    inline = "touch /tmp/testUploadOwner"
  }

  provisioner "shell" {
    inline = ["[ $(stat -c %u /tmp/strawberry-cake) -eq 42 ] || (echo 'Invalid owner of /tmp/strawberry-cake' && exit 1)", "[ $(stat -c %u /tmp/testUploadOwner) -eq 42 ] || (echo 'Invalid owner of /tmp/testUploadOwner' && exit 1)", "find /tmp/manycakes | xargs -n1 -IFILE /bin/sh -c '[ $(stat -c %u FILE) -eq 42 ] || (echo \"Invalid owner of FILE\" && exit 1)'"]
  }

}
