/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// IpConsumer struct for IpConsumer
type IpConsumer struct {
	DatacenterId    *string `json:"datacenterId,omitempty"`
	DatacenterName  *string `json:"datacenterName,omitempty"`
	Ip              *string `json:"ip,omitempty"`
	K8sClusterUuid  *string `json:"k8sClusterUuid,omitempty"`
	K8sNodePoolUuid *string `json:"k8sNodePoolUuid,omitempty"`
	Mac             *string `json:"mac,omitempty"`
	NicId           *string `json:"nicId,omitempty"`
	ServerId        *string `json:"serverId,omitempty"`
	ServerName      *string `json:"serverName,omitempty"`
}

// NewIpConsumer instantiates a new IpConsumer object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewIpConsumer() *IpConsumer {
	this := IpConsumer{}

	return &this
}

// NewIpConsumerWithDefaults instantiates a new IpConsumer object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewIpConsumerWithDefaults() *IpConsumer {
	this := IpConsumer{}
	return &this
}

// GetDatacenterId returns the DatacenterId field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetDatacenterId() *string {
	if o == nil {
		return nil
	}

	return o.DatacenterId

}

// GetDatacenterIdOk returns a tuple with the DatacenterId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetDatacenterIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.DatacenterId, true
}

// SetDatacenterId sets field value
func (o *IpConsumer) SetDatacenterId(v string) {

	o.DatacenterId = &v

}

// HasDatacenterId returns a boolean if a field has been set.
func (o *IpConsumer) HasDatacenterId() bool {
	if o != nil && o.DatacenterId != nil {
		return true
	}

	return false
}

// GetDatacenterName returns the DatacenterName field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetDatacenterName() *string {
	if o == nil {
		return nil
	}

	return o.DatacenterName

}

// GetDatacenterNameOk returns a tuple with the DatacenterName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetDatacenterNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.DatacenterName, true
}

// SetDatacenterName sets field value
func (o *IpConsumer) SetDatacenterName(v string) {

	o.DatacenterName = &v

}

// HasDatacenterName returns a boolean if a field has been set.
func (o *IpConsumer) HasDatacenterName() bool {
	if o != nil && o.DatacenterName != nil {
		return true
	}

	return false
}

// GetIp returns the Ip field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetIp() *string {
	if o == nil {
		return nil
	}

	return o.Ip

}

// GetIpOk returns a tuple with the Ip field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetIpOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Ip, true
}

// SetIp sets field value
func (o *IpConsumer) SetIp(v string) {

	o.Ip = &v

}

// HasIp returns a boolean if a field has been set.
func (o *IpConsumer) HasIp() bool {
	if o != nil && o.Ip != nil {
		return true
	}

	return false
}

// GetK8sClusterUuid returns the K8sClusterUuid field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetK8sClusterUuid() *string {
	if o == nil {
		return nil
	}

	return o.K8sClusterUuid

}

// GetK8sClusterUuidOk returns a tuple with the K8sClusterUuid field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetK8sClusterUuidOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.K8sClusterUuid, true
}

// SetK8sClusterUuid sets field value
func (o *IpConsumer) SetK8sClusterUuid(v string) {

	o.K8sClusterUuid = &v

}

// HasK8sClusterUuid returns a boolean if a field has been set.
func (o *IpConsumer) HasK8sClusterUuid() bool {
	if o != nil && o.K8sClusterUuid != nil {
		return true
	}

	return false
}

// GetK8sNodePoolUuid returns the K8sNodePoolUuid field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetK8sNodePoolUuid() *string {
	if o == nil {
		return nil
	}

	return o.K8sNodePoolUuid

}

// GetK8sNodePoolUuidOk returns a tuple with the K8sNodePoolUuid field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetK8sNodePoolUuidOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.K8sNodePoolUuid, true
}

// SetK8sNodePoolUuid sets field value
func (o *IpConsumer) SetK8sNodePoolUuid(v string) {

	o.K8sNodePoolUuid = &v

}

// HasK8sNodePoolUuid returns a boolean if a field has been set.
func (o *IpConsumer) HasK8sNodePoolUuid() bool {
	if o != nil && o.K8sNodePoolUuid != nil {
		return true
	}

	return false
}

// GetMac returns the Mac field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetMac() *string {
	if o == nil {
		return nil
	}

	return o.Mac

}

// GetMacOk returns a tuple with the Mac field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetMacOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Mac, true
}

// SetMac sets field value
func (o *IpConsumer) SetMac(v string) {

	o.Mac = &v

}

// HasMac returns a boolean if a field has been set.
func (o *IpConsumer) HasMac() bool {
	if o != nil && o.Mac != nil {
		return true
	}

	return false
}

// GetNicId returns the NicId field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetNicId() *string {
	if o == nil {
		return nil
	}

	return o.NicId

}

// GetNicIdOk returns a tuple with the NicId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetNicIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.NicId, true
}

// SetNicId sets field value
func (o *IpConsumer) SetNicId(v string) {

	o.NicId = &v

}

// HasNicId returns a boolean if a field has been set.
func (o *IpConsumer) HasNicId() bool {
	if o != nil && o.NicId != nil {
		return true
	}

	return false
}

// GetServerId returns the ServerId field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetServerId() *string {
	if o == nil {
		return nil
	}

	return o.ServerId

}

// GetServerIdOk returns a tuple with the ServerId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetServerIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.ServerId, true
}

// SetServerId sets field value
func (o *IpConsumer) SetServerId(v string) {

	o.ServerId = &v

}

// HasServerId returns a boolean if a field has been set.
func (o *IpConsumer) HasServerId() bool {
	if o != nil && o.ServerId != nil {
		return true
	}

	return false
}

// GetServerName returns the ServerName field value
// If the value is explicit nil, nil is returned
func (o *IpConsumer) GetServerName() *string {
	if o == nil {
		return nil
	}

	return o.ServerName

}

// GetServerNameOk returns a tuple with the ServerName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *IpConsumer) GetServerNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.ServerName, true
}

// SetServerName sets field value
func (o *IpConsumer) SetServerName(v string) {

	o.ServerName = &v

}

// HasServerName returns a boolean if a field has been set.
func (o *IpConsumer) HasServerName() bool {
	if o != nil && o.ServerName != nil {
		return true
	}

	return false
}

func (o IpConsumer) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DatacenterId != nil {
		toSerialize["datacenterId"] = o.DatacenterId
	}

	if o.DatacenterName != nil {
		toSerialize["datacenterName"] = o.DatacenterName
	}

	if o.Ip != nil {
		toSerialize["ip"] = o.Ip
	}

	if o.K8sClusterUuid != nil {
		toSerialize["k8sClusterUuid"] = o.K8sClusterUuid
	}

	if o.K8sNodePoolUuid != nil {
		toSerialize["k8sNodePoolUuid"] = o.K8sNodePoolUuid
	}

	if o.Mac != nil {
		toSerialize["mac"] = o.Mac
	}

	if o.NicId != nil {
		toSerialize["nicId"] = o.NicId
	}

	if o.ServerId != nil {
		toSerialize["serverId"] = o.ServerId
	}

	if o.ServerName != nil {
		toSerialize["serverName"] = o.ServerName
	}

	return json.Marshal(toSerialize)
}

type NullableIpConsumer struct {
	value *IpConsumer
	isSet bool
}

func (v NullableIpConsumer) Get() *IpConsumer {
	return v.value
}

func (v *NullableIpConsumer) Set(val *IpConsumer) {
	v.value = val
	v.isSet = true
}

func (v NullableIpConsumer) IsSet() bool {
	return v.isSet
}

func (v *NullableIpConsumer) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableIpConsumer(val *IpConsumer) *NullableIpConsumer {
	return &NullableIpConsumer{value: val, isSet: true}
}

func (v NullableIpConsumer) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableIpConsumer) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
