// Package lderrors provides identifiers for particular kinds of errors that can be returned by
// code in [github.com/launchdarkly/go-sdk-common/v3/ldcontext] or
// [github.com/launchdarkly/go-sdk-common/v3/ldattr].
//
// Errors are only defined here if they are specifically generated by those packages.
// The LaunchDarkly Go SDK ([github.com/launchdarkly/go-server-sdk/v6]) may define its own error
// values for additional error conditions that are related to higher-level SDK functionality.
//
// Unlike some packages which define errors as exported global variables, here they are exported
// as types only. This allows consistent usage regardless of whether a particular kind of error
// has properties that can vary, or is a singleton with no properties. So, for instance, rather
// than doing an equality test like this--
//
//	if err == lderrors.ErrContextKeyEmpty
//
// --do a type check:
//
//	if _, ok := err.(lderrors.ErrContextKeyEmpty); ok
package lderrors
