// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package gkeonprem provides access to the Anthos On-Prem API.
//
// For product documentation, see: https://cloud.google.com/anthos/clusters/docs/on-prem/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/gkeonprem/v1"
//	...
//	ctx := context.Background()
//	gkeonpremService, err := gkeonprem.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	gkeonpremService, err := gkeonprem.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	gkeonpremService, err := gkeonprem.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package gkeonprem // import "google.golang.org/api/gkeonprem/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "gkeonprem:v1"
const apiName = "gkeonprem"
const apiVersion = "v1"
const basePath = "https://gkeonprem.googleapis.com/"
const mtlsBasePath = "https://gkeonprem.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.BareMetalAdminClusters = NewProjectsLocationsBareMetalAdminClustersService(s)
	rs.BareMetalClusters = NewProjectsLocationsBareMetalClustersService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.VmwareAdminClusters = NewProjectsLocationsVmwareAdminClustersService(s)
	rs.VmwareClusters = NewProjectsLocationsVmwareClustersService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	BareMetalAdminClusters *ProjectsLocationsBareMetalAdminClustersService

	BareMetalClusters *ProjectsLocationsBareMetalClustersService

	Operations *ProjectsLocationsOperationsService

	VmwareAdminClusters *ProjectsLocationsVmwareAdminClustersService

	VmwareClusters *ProjectsLocationsVmwareClustersService
}

func NewProjectsLocationsBareMetalAdminClustersService(s *Service) *ProjectsLocationsBareMetalAdminClustersService {
	rs := &ProjectsLocationsBareMetalAdminClustersService{s: s}
	rs.Operations = NewProjectsLocationsBareMetalAdminClustersOperationsService(s)
	return rs
}

type ProjectsLocationsBareMetalAdminClustersService struct {
	s *Service

	Operations *ProjectsLocationsBareMetalAdminClustersOperationsService
}

func NewProjectsLocationsBareMetalAdminClustersOperationsService(s *Service) *ProjectsLocationsBareMetalAdminClustersOperationsService {
	rs := &ProjectsLocationsBareMetalAdminClustersOperationsService{s: s}
	return rs
}

type ProjectsLocationsBareMetalAdminClustersOperationsService struct {
	s *Service
}

func NewProjectsLocationsBareMetalClustersService(s *Service) *ProjectsLocationsBareMetalClustersService {
	rs := &ProjectsLocationsBareMetalClustersService{s: s}
	rs.BareMetalNodePools = NewProjectsLocationsBareMetalClustersBareMetalNodePoolsService(s)
	rs.Operations = NewProjectsLocationsBareMetalClustersOperationsService(s)
	return rs
}

type ProjectsLocationsBareMetalClustersService struct {
	s *Service

	BareMetalNodePools *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService

	Operations *ProjectsLocationsBareMetalClustersOperationsService
}

func NewProjectsLocationsBareMetalClustersBareMetalNodePoolsService(s *Service) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService {
	rs := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsService{s: s}
	rs.Operations = NewProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService(s)
	return rs
}

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsService struct {
	s *Service

	Operations *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService
}

func NewProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService(s *Service) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService {
	rs := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsBareMetalClustersOperationsService(s *Service) *ProjectsLocationsBareMetalClustersOperationsService {
	rs := &ProjectsLocationsBareMetalClustersOperationsService{s: s}
	return rs
}

type ProjectsLocationsBareMetalClustersOperationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsVmwareAdminClustersService(s *Service) *ProjectsLocationsVmwareAdminClustersService {
	rs := &ProjectsLocationsVmwareAdminClustersService{s: s}
	rs.Operations = NewProjectsLocationsVmwareAdminClustersOperationsService(s)
	return rs
}

type ProjectsLocationsVmwareAdminClustersService struct {
	s *Service

	Operations *ProjectsLocationsVmwareAdminClustersOperationsService
}

func NewProjectsLocationsVmwareAdminClustersOperationsService(s *Service) *ProjectsLocationsVmwareAdminClustersOperationsService {
	rs := &ProjectsLocationsVmwareAdminClustersOperationsService{s: s}
	return rs
}

type ProjectsLocationsVmwareAdminClustersOperationsService struct {
	s *Service
}

func NewProjectsLocationsVmwareClustersService(s *Service) *ProjectsLocationsVmwareClustersService {
	rs := &ProjectsLocationsVmwareClustersService{s: s}
	rs.Operations = NewProjectsLocationsVmwareClustersOperationsService(s)
	rs.VmwareNodePools = NewProjectsLocationsVmwareClustersVmwareNodePoolsService(s)
	return rs
}

type ProjectsLocationsVmwareClustersService struct {
	s *Service

	Operations *ProjectsLocationsVmwareClustersOperationsService

	VmwareNodePools *ProjectsLocationsVmwareClustersVmwareNodePoolsService
}

func NewProjectsLocationsVmwareClustersOperationsService(s *Service) *ProjectsLocationsVmwareClustersOperationsService {
	rs := &ProjectsLocationsVmwareClustersOperationsService{s: s}
	return rs
}

type ProjectsLocationsVmwareClustersOperationsService struct {
	s *Service
}

func NewProjectsLocationsVmwareClustersVmwareNodePoolsService(s *Service) *ProjectsLocationsVmwareClustersVmwareNodePoolsService {
	rs := &ProjectsLocationsVmwareClustersVmwareNodePoolsService{s: s}
	rs.Operations = NewProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService(s)
	return rs
}

type ProjectsLocationsVmwareClustersVmwareNodePoolsService struct {
	s *Service

	Operations *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService
}

func NewProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService(s *Service) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService {
	rs := &ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService struct {
	s *Service
}

// Authorization: Authorization defines the On-Prem cluster
// authorization configuration to bootstrap onto the admin cluster.
type Authorization struct {
	// AdminUsers: Required. For VMware and bare metal user clusters, users
	// will be granted the cluster-admin role on the cluster, which provides
	// full administrative access to the cluster. For bare metal admin
	// clusters, users will be granted the cluster-view role, which limits
	// users to read-only access.
	AdminUsers []*ClusterUser `json:"adminUsers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdminUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminUsers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Authorization) MarshalJSON() ([]byte, error) {
	type NoMethod Authorization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminApiServerArgument: BareMetalAdminApiServerArgument
// represents an arg name->value pair. Only a subset of customized flags
// are supported. Please refer to the API server documentation below to
// know the exact format:
// https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/
type BareMetalAdminApiServerArgument struct {
	// Argument: Required. The argument name as it appears on the API Server
	// command line please make sure to remove the leading dashes.
	Argument string `json:"argument,omitempty"`

	// Value: Required. The value of the arg as it will be passed to the API
	// Server command line.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Argument") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Argument") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminApiServerArgument) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminApiServerArgument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminCluster: ## Resource that represents a bare metal admin
// cluster.
type BareMetalAdminCluster struct {
	// Annotations: Annotations on the bare metal admin cluster. This field
	// has the same restrictions as Kubernetes annotations. The total size
	// of all keys and values combined is limited to 256k. Key can have 2
	// segments: prefix (optional) and name (required), separated by a slash
	// (/). Prefix must be a DNS subdomain. Name must be 63 characters or
	// less, begin and end with alphanumerics, with dashes (-), underscores
	// (_), dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// BareMetalVersion: The Anthos clusters on bare metal version for the
	// bare metal admin cluster.
	BareMetalVersion string `json:"bareMetalVersion,omitempty"`

	// ClusterOperations: Cluster operations configuration.
	ClusterOperations *BareMetalAdminClusterOperationsConfig `json:"clusterOperations,omitempty"`

	// ControlPlane: Control plane configuration.
	ControlPlane *BareMetalAdminControlPlaneConfig `json:"controlPlane,omitempty"`

	// CreateTime: Output only. The time at which this bare metal admin
	// cluster was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeleteTime: Output only. The time at which this bare metal admin
	// cluster was deleted. If the resource is not deleted, this must be
	// empty
	DeleteTime string `json:"deleteTime,omitempty"`

	// Description: A human readable description of this bare metal admin
	// cluster.
	Description string `json:"description,omitempty"`

	// Endpoint: Output only. The IP address name of bare metal admin
	// cluster's API server.
	Endpoint string `json:"endpoint,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Allows clients
	// to perform consistent read-modify-writes through optimistic
	// concurrency control.
	Etag string `json:"etag,omitempty"`

	// Fleet: Output only. Fleet configuration for the cluster.
	Fleet *Fleet `json:"fleet,omitempty"`

	// LoadBalancer: Load balancer configuration.
	LoadBalancer *BareMetalAdminLoadBalancerConfig `json:"loadBalancer,omitempty"`

	// LocalName: Output only. The object name of the bare metal cluster
	// custom resource. This field is used to support conflicting names when
	// enrolling existing clusters to the API. When used as a part of
	// cluster enrollment, this field will differ from the ID in the
	// resource name. For new clusters, this field will match the user
	// provided cluster name and be visible in the last component of the
	// resource name. It is not modifiable. All users should use this name
	// to access their cluster using gkectl or kubectl and should expect to
	// see the local name when viewing admin cluster controller logs.
	LocalName string `json:"localName,omitempty"`

	// MaintenanceConfig: Maintenance configuration.
	MaintenanceConfig *BareMetalAdminMaintenanceConfig `json:"maintenanceConfig,omitempty"`

	// MaintenanceStatus: Output only. MaintenanceStatus representing state
	// of maintenance.
	MaintenanceStatus *BareMetalAdminMaintenanceStatus `json:"maintenanceStatus,omitempty"`

	// Name: Immutable. The bare metal admin cluster resource name.
	Name string `json:"name,omitempty"`

	// NetworkConfig: Network configuration.
	NetworkConfig *BareMetalAdminNetworkConfig `json:"networkConfig,omitempty"`

	// NodeAccessConfig: Node access related configurations.
	NodeAccessConfig *BareMetalAdminNodeAccessConfig `json:"nodeAccessConfig,omitempty"`

	// NodeConfig: Workload node configuration.
	NodeConfig *BareMetalAdminWorkloadNodeConfig `json:"nodeConfig,omitempty"`

	// OsEnvironmentConfig: OS environment related configurations.
	OsEnvironmentConfig *BareMetalAdminOsEnvironmentConfig `json:"osEnvironmentConfig,omitempty"`

	// Proxy: Proxy configuration.
	Proxy *BareMetalAdminProxyConfig `json:"proxy,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the bare metal Admin Cluster.
	Reconciling bool `json:"reconciling,omitempty"`

	// SecurityConfig: Security related configuration.
	SecurityConfig *BareMetalAdminSecurityConfig `json:"securityConfig,omitempty"`

	// State: Output only. The current state of the bare metal admin
	// cluster.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the cluster is
	// being created.
	//   "RUNNING" - The RUNNING state indicates the cluster has been
	// created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the cluster is
	// being updated. It remains available, but potentially with degraded
	// performance.
	//   "STOPPING" - The STOPPING state indicates the cluster is being
	// deleted.
	//   "ERROR" - The ERROR state indicates the cluster is in a broken
	// unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the cluster requires user
	// action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. ResourceStatus representing detailed cluster
	// status.
	Status *ResourceStatus `json:"status,omitempty"`

	// Storage: Storage configuration.
	Storage *BareMetalAdminStorageConfig `json:"storage,omitempty"`

	// Uid: Output only. The unique identifier of the bare metal admin
	// cluster.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time at which this bare metal admin
	// cluster was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValidationCheck: Output only. ValidationCheck representing the result
	// of the preflight check.
	ValidationCheck *ValidationCheck `json:"validationCheck,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminCluster) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminCluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminClusterOperationsConfig:
// BareMetalAdminClusterOperationsConfig specifies the admin cluster's
// observability infrastructure.
type BareMetalAdminClusterOperationsConfig struct {
	// EnableApplicationLogs: Whether collection of application logs/metrics
	// should be enabled (in addition to system logs/metrics).
	EnableApplicationLogs bool `json:"enableApplicationLogs,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableApplicationLogs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableApplicationLogs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminClusterOperationsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminClusterOperationsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminControlPlaneConfig: BareMetalAdminControlPlaneConfig
// specifies the control plane configuration.
type BareMetalAdminControlPlaneConfig struct {
	// ApiServerArgs: Customizes the default API server args. Only a subset
	// of customized flags are supported. Please refer to the API server
	// documentation below to know the exact format:
	// https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/
	ApiServerArgs []*BareMetalAdminApiServerArgument `json:"apiServerArgs,omitempty"`

	// ControlPlaneNodePoolConfig: Configures the node pool running the
	// control plane. If specified the corresponding NodePool will be
	// created for the cluster's control plane. The NodePool will have the
	// same name and namespace as the cluster.
	ControlPlaneNodePoolConfig *BareMetalAdminControlPlaneNodePoolConfig `json:"controlPlaneNodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiServerArgs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiServerArgs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminControlPlaneConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminControlPlaneConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminControlPlaneNodePoolConfig:
// BareMetalAdminControlPlaneNodePoolConfig specifies the control plane
// node pool configuration. We have a control plane specific node pool
// config so that we can flexible about supporting control plane
// specific fields in the future.
type BareMetalAdminControlPlaneNodePoolConfig struct {
	// NodePoolConfig: The generic configuration for a node pool running the
	// control plane.
	NodePoolConfig *BareMetalNodePoolConfig `json:"nodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodePoolConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodePoolConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminControlPlaneNodePoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminControlPlaneNodePoolConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminDrainedMachine: BareMetalAdminDrainedMachine represents
// the machines that are drained.
type BareMetalAdminDrainedMachine struct {
	// NodeIp: Drained machine IP address.
	NodeIp string `json:"nodeIp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodeIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodeIp") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminDrainedMachine) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminDrainedMachine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminDrainingMachine: BareMetalAdminDrainingMachine
// represents the machines that are currently draining.
type BareMetalAdminDrainingMachine struct {
	// NodeIp: Draining machine IP address.
	NodeIp string `json:"nodeIp,omitempty"`

	// PodCount: The count of pods yet to drain.
	PodCount int64 `json:"podCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodeIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodeIp") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminDrainingMachine) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminDrainingMachine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminIslandModeCidrConfig:
// BareMetalAdminIslandModeCidrConfig specifies the cluster CIDR
// configuration while running in island mode.
type BareMetalAdminIslandModeCidrConfig struct {
	// PodAddressCidrBlocks: Required. All pods in the cluster are assigned
	// an RFC1918 IPv4 address from these ranges. This field cannot be
	// changed after creation.
	PodAddressCidrBlocks []string `json:"podAddressCidrBlocks,omitempty"`

	// ServiceAddressCidrBlocks: Required. All services in the cluster are
	// assigned an RFC1918 IPv4 address from these ranges. This field cannot
	// be changed after creation.
	ServiceAddressCidrBlocks []string `json:"serviceAddressCidrBlocks,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PodAddressCidrBlocks") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PodAddressCidrBlocks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminIslandModeCidrConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminIslandModeCidrConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminLoadBalancerConfig: BareMetalAdminLoadBalancerConfig
// specifies the load balancer configuration.
type BareMetalAdminLoadBalancerConfig struct {
	// ManualLbConfig: Manually configured load balancers.
	ManualLbConfig *BareMetalAdminManualLbConfig `json:"manualLbConfig,omitempty"`

	// PortConfig: Configures the ports that the load balancer will listen
	// on.
	PortConfig *BareMetalAdminPortConfig `json:"portConfig,omitempty"`

	// VipConfig: The VIPs used by the load balancer.
	VipConfig *BareMetalAdminVipConfig `json:"vipConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ManualLbConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ManualLbConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminLoadBalancerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminLoadBalancerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminMachineDrainStatus: BareMetalAdminMachineDrainStatus
// represents the status of bare metal node machines that are undergoing
// drain operations.
type BareMetalAdminMachineDrainStatus struct {
	// DrainedMachines: The list of drained machines.
	DrainedMachines []*BareMetalAdminDrainedMachine `json:"drainedMachines,omitempty"`

	// DrainingMachines: The list of draning machines.
	DrainingMachines []*BareMetalAdminDrainingMachine `json:"drainingMachines,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DrainedMachines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DrainedMachines") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminMachineDrainStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminMachineDrainStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminMaintenanceConfig: BareMetalAdminMaintenanceConfig
// specifies configurations to put bare metal Admin cluster CRs nodes in
// and out of maintenance.
type BareMetalAdminMaintenanceConfig struct {
	// MaintenanceAddressCidrBlocks: Required. All IPv4 address from these
	// ranges will be placed into maintenance mode. Nodes in maintenance
	// mode will be cordoned and drained. When both of these are true, the
	// "baremetal.cluster.gke.io/maintenance" annotation will be set on the
	// node resource.
	MaintenanceAddressCidrBlocks []string `json:"maintenanceAddressCidrBlocks,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaintenanceAddressCidrBlocks") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MaintenanceAddressCidrBlocks") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminMaintenanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminMaintenanceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminMaintenanceStatus: BareMetalAdminMaintenanceStatus
// represents the maintenance status for bare metal Admin cluster CR's
// nodes.
type BareMetalAdminMaintenanceStatus struct {
	// MachineDrainStatus: Represents the status of draining and drained
	// machine nodes. This is used to show the progress of cluster upgrade.
	MachineDrainStatus *BareMetalAdminMachineDrainStatus `json:"machineDrainStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineDrainStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineDrainStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminMaintenanceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminMaintenanceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminManualLbConfig: BareMetalAdminManualLbConfig represents
// configuration parameters for a manual load balancer.
type BareMetalAdminManualLbConfig struct {
	// Enabled: Whether manual load balancing is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminManualLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminManualLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminNetworkConfig: BareMetalAdminNetworkConfig specifies
// the cluster network configuration.
type BareMetalAdminNetworkConfig struct {
	// IslandModeCidr: Configuration for Island mode CIDR.
	IslandModeCidr *BareMetalAdminIslandModeCidrConfig `json:"islandModeCidr,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IslandModeCidr") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IslandModeCidr") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminNetworkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminNodeAccessConfig: Specifies the node access related
// settings for the bare metal admin cluster.
type BareMetalAdminNodeAccessConfig struct {
	// LoginUser: Required. LoginUser is the user name used to access node
	// machines. It defaults to "root" if not set.
	LoginUser string `json:"loginUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LoginUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoginUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminNodeAccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminNodeAccessConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminOsEnvironmentConfig: Specifies operating system
// operation settings for cluster provisioning.
type BareMetalAdminOsEnvironmentConfig struct {
	// PackageRepoExcluded: Whether the package repo should be added when
	// initializing bare metal machines.
	PackageRepoExcluded bool `json:"packageRepoExcluded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PackageRepoExcluded")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PackageRepoExcluded") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminOsEnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminOsEnvironmentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminPortConfig: BareMetalAdminPortConfig is the
// specification of load balancer ports.
type BareMetalAdminPortConfig struct {
	// ControlPlaneLoadBalancerPort: The port that control plane hosted load
	// balancers will listen on.
	ControlPlaneLoadBalancerPort int64 `json:"controlPlaneLoadBalancerPort,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ControlPlaneLoadBalancerPort") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ControlPlaneLoadBalancerPort") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminPortConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminPortConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminProxyConfig: BareMetalAdminProxyConfig specifies the
// cluster proxy configuration.
type BareMetalAdminProxyConfig struct {
	// NoProxy: A list of IPs, hostnames, and domains that should skip the
	// proxy. Examples: ["127.0.0.1", "example.com", ".corp", "localhost"].
	NoProxy []string `json:"noProxy,omitempty"`

	// Uri: Required. Specifies the address of your proxy server. Examples:
	// `http://domain` WARNING: Do not provide credentials in the format
	// `http://(username:password@)domain` these will be rejected by the
	// server.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NoProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NoProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminProxyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminProxyConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminSecurityConfig: Specifies the security related settings
// for the bare metal admin cluster.
type BareMetalAdminSecurityConfig struct {
	// Authorization: Configures user access to the admin cluster.
	Authorization *Authorization `json:"authorization,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Authorization") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Authorization") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminSecurityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminSecurityConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminStorageConfig: BareMetalAdminStorageConfig specifies
// the cluster storage configuration.
type BareMetalAdminStorageConfig struct {
	// LvpNodeMountsConfig: Required. Specifies the config for local
	// PersistentVolumes backed by mounted node disks. These disks need to
	// be formatted and mounted by the user, which can be done before or
	// after cluster creation.
	LvpNodeMountsConfig *BareMetalLvpConfig `json:"lvpNodeMountsConfig,omitempty"`

	// LvpShareConfig: Required. Specifies the config for local
	// PersistentVolumes backed by subdirectories in a shared filesystem.
	// These subdirectores are automatically created during cluster
	// creation.
	LvpShareConfig *BareMetalLvpShareConfig `json:"lvpShareConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LvpNodeMountsConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LvpNodeMountsConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminStorageConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminVipConfig: BareMetalAdminVipConfig for bare metal load
// balancer configurations.
type BareMetalAdminVipConfig struct {
	// ControlPlaneVip: The VIP which you previously set aside for the
	// Kubernetes API of this bare metal admin cluster.
	ControlPlaneVip string `json:"controlPlaneVip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ControlPlaneVip") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneVip") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminVipConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminVipConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalAdminWorkloadNodeConfig: BareMetalAdminWorkloadNodeConfig
// specifies the workload node configurations.
type BareMetalAdminWorkloadNodeConfig struct {
	// MaxPodsPerNode: The maximum number of pods a node can run. The size
	// of the CIDR range assigned to the node will be derived from this
	// parameter. By default 110 Pods are created per Node. Upper bound is
	// 250 for both HA and non-HA admin cluster. Lower bound is 64 for
	// non-HA admin cluster and 32 for HA admin cluster.
	MaxPodsPerNode int64 `json:"maxPodsPerNode,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MaxPodsPerNode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxPodsPerNode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalAdminWorkloadNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalAdminWorkloadNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalApiServerArgument: Represents an arg name->value pair. Only
// a subset of customized flags are supported. For the exact format,
// refer to the API server documentation
// (https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/).
type BareMetalApiServerArgument struct {
	// Argument: Required. The argument name as it appears on the API Server
	// command line, make sure to remove the leading dashes.
	Argument string `json:"argument,omitempty"`

	// Value: Required. The value of the arg as it will be passed to the API
	// Server command line.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Argument") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Argument") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalApiServerArgument) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalApiServerArgument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalBgpLbConfig: BareMetalBgpLbConfig represents configuration
// parameters for a Border Gateway Protocol (BGP) load balancer.
type BareMetalBgpLbConfig struct {
	// AddressPools: Required. AddressPools is a list of non-overlapping IP
	// pools used by load balancer typed services. All addresses must be
	// routable to load balancer nodes. IngressVIP must be included in the
	// pools.
	AddressPools []*BareMetalLoadBalancerAddressPool `json:"addressPools,omitempty"`

	// Asn: Required. BGP autonomous system number (ASN) of the cluster.
	// This field can be updated after cluster creation.
	Asn int64 `json:"asn,omitempty,string"`

	// BgpPeerConfigs: Required. The list of BGP peers that the cluster will
	// connect to. At least one peer must be configured for each control
	// plane node. Control plane nodes will connect to these peers to
	// advertise the control plane VIP. The Services load balancer also uses
	// these peers by default. This field can be updated after cluster
	// creation.
	BgpPeerConfigs []*BareMetalBgpPeerConfig `json:"bgpPeerConfigs,omitempty"`

	// LoadBalancerNodePoolConfig: Specifies the node pool running data
	// plane load balancing. L2 connectivity is required among nodes in this
	// pool. If missing, the control plane node pool is used for data plane
	// load balancing.
	LoadBalancerNodePoolConfig *BareMetalLoadBalancerNodePoolConfig `json:"loadBalancerNodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressPools") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressPools") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalBgpLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalBgpLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalBgpPeerConfig: BareMetalBgpPeerConfig represents
// configuration parameters for a Border Gateway Protocol (BGP) peer.
type BareMetalBgpPeerConfig struct {
	// Asn: Required. BGP autonomous system number (ASN) for the network
	// that contains the external peer device.
	Asn int64 `json:"asn,omitempty,string"`

	// ControlPlaneNodes: The IP address of the control plane node that
	// connects to the external peer. If you don't specify any control plane
	// nodes, all control plane nodes can connect to the external peer. If
	// you specify one or more IP addresses, only the nodes specified
	// participate in peering sessions.
	ControlPlaneNodes []string `json:"controlPlaneNodes,omitempty"`

	// IpAddress: Required. The IP address of the external peer device.
	IpAddress string `json:"ipAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asn") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asn") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalBgpPeerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalBgpPeerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalCluster: Resource that represents a bare metal user cluster.
type BareMetalCluster struct {
	// AdminClusterMembership: Required. The admin cluster this bare metal
	// user cluster belongs to. This is the full resource name of the admin
	// cluster's fleet membership.
	AdminClusterMembership string `json:"adminClusterMembership,omitempty"`

	// AdminClusterName: Output only. The resource name of the bare metal
	// admin cluster managing this user cluster.
	AdminClusterName string `json:"adminClusterName,omitempty"`

	// Annotations: Annotations on the bare metal user cluster. This field
	// has the same restrictions as Kubernetes annotations. The total size
	// of all keys and values combined is limited to 256k. Key can have 2
	// segments: prefix (optional) and name (required), separated by a slash
	// (/). Prefix must be a DNS subdomain. Name must be 63 characters or
	// less, begin and end with alphanumerics, with dashes (-), underscores
	// (_), dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// BareMetalVersion: Required. The Anthos clusters on bare metal version
	// for your user cluster.
	BareMetalVersion string `json:"bareMetalVersion,omitempty"`

	// ClusterOperations: Cluster operations configuration.
	ClusterOperations *BareMetalClusterOperationsConfig `json:"clusterOperations,omitempty"`

	// ControlPlane: Required. Control plane configuration.
	ControlPlane *BareMetalControlPlaneConfig `json:"controlPlane,omitempty"`

	// CreateTime: Output only. The time when the bare metal user cluster
	// was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeleteTime: Output only. The time when the bare metal user cluster
	// was deleted. If the resource is not deleted, this must be empty
	DeleteTime string `json:"deleteTime,omitempty"`

	// Description: A human readable description of this bare metal user
	// cluster.
	Description string `json:"description,omitempty"`

	// Endpoint: Output only. The IP address of the bare metal user
	// cluster's API server.
	Endpoint string `json:"endpoint,omitempty"`

	// Etag: Output only. This checksum is computed by the server based on
	// the value of other fields, and may be sent on update and delete
	// requests to ensure the client has an up-to-date value before
	// proceeding. Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	Etag string `json:"etag,omitempty"`

	// Fleet: Output only. Fleet configuration for the cluster.
	Fleet *Fleet `json:"fleet,omitempty"`

	// LoadBalancer: Required. Load balancer configuration.
	LoadBalancer *BareMetalLoadBalancerConfig `json:"loadBalancer,omitempty"`

	// LocalName: Output only. The object name of the bare metal user
	// cluster custom resource on the associated admin cluster. This field
	// is used to support conflicting names when enrolling existing clusters
	// to the API. When used as a part of cluster enrollment, this field
	// will differ from the name in the resource name. For new clusters,
	// this field will match the user provided cluster name and be visible
	// in the last component of the resource name. It is not modifiable.
	// When the local name and cluster name differ, the local name is used
	// in the admin cluster controller logs. You use the cluster name when
	// accessing the cluster using bmctl and kubectl.
	LocalName string `json:"localName,omitempty"`

	// MaintenanceConfig: Maintenance configuration.
	MaintenanceConfig *BareMetalMaintenanceConfig `json:"maintenanceConfig,omitempty"`

	// MaintenanceStatus: Output only. Status of on-going maintenance tasks.
	MaintenanceStatus *BareMetalMaintenanceStatus `json:"maintenanceStatus,omitempty"`

	// Name: Immutable. The bare metal user cluster resource name.
	Name string `json:"name,omitempty"`

	// NetworkConfig: Required. Network configuration.
	NetworkConfig *BareMetalNetworkConfig `json:"networkConfig,omitempty"`

	// NodeAccessConfig: Node access related configurations.
	NodeAccessConfig *BareMetalNodeAccessConfig `json:"nodeAccessConfig,omitempty"`

	// NodeConfig: Workload node configuration.
	NodeConfig *BareMetalWorkloadNodeConfig `json:"nodeConfig,omitempty"`

	// OsEnvironmentConfig: OS environment related configurations.
	OsEnvironmentConfig *BareMetalOsEnvironmentConfig `json:"osEnvironmentConfig,omitempty"`

	// Proxy: Proxy configuration.
	Proxy *BareMetalProxyConfig `json:"proxy,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the bare metal user cluster.
	Reconciling bool `json:"reconciling,omitempty"`

	// SecurityConfig: Security related setting configuration.
	SecurityConfig *BareMetalSecurityConfig `json:"securityConfig,omitempty"`

	// State: Output only. The current state of the bare metal user cluster.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the cluster is
	// being created.
	//   "RUNNING" - The RUNNING state indicates the cluster has been
	// created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the cluster is
	// being updated. It remains available, but potentially with degraded
	// performance.
	//   "STOPPING" - The STOPPING state indicates the cluster is being
	// deleted.
	//   "ERROR" - The ERROR state indicates the cluster is in a broken
	// unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the cluster requires user
	// action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. Detailed cluster status.
	Status *ResourceStatus `json:"status,omitempty"`

	// Storage: Required. Storage configuration.
	Storage *BareMetalStorageConfig `json:"storage,omitempty"`

	// Uid: Output only. The unique identifier of the bare metal user
	// cluster.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the bare metal user cluster
	// was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValidationCheck: Output only. The result of the preflight check.
	ValidationCheck *ValidationCheck `json:"validationCheck,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdminClusterMembership") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminClusterMembership")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalCluster) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalCluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalClusterOperationsConfig: Specifies the bare metal user
// cluster's observability infrastructure.
type BareMetalClusterOperationsConfig struct {
	// EnableApplicationLogs: Whether collection of application logs/metrics
	// should be enabled (in addition to system logs/metrics).
	EnableApplicationLogs bool `json:"enableApplicationLogs,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableApplicationLogs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableApplicationLogs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalClusterOperationsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalClusterOperationsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalControlPlaneConfig: Specifies the control plane
// configuration.
type BareMetalControlPlaneConfig struct {
	// ApiServerArgs: Customizes the default API server args. Only a subset
	// of customized flags are supported. For the exact format, refer to the
	// API server documentation
	// (https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/).
	ApiServerArgs []*BareMetalApiServerArgument `json:"apiServerArgs,omitempty"`

	// ControlPlaneNodePoolConfig: Required. Configures the node pool
	// running the control plane.
	ControlPlaneNodePoolConfig *BareMetalControlPlaneNodePoolConfig `json:"controlPlaneNodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiServerArgs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiServerArgs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalControlPlaneConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalControlPlaneConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalControlPlaneNodePoolConfig: Specifies the control plane node
// pool configuration.
type BareMetalControlPlaneNodePoolConfig struct {
	// NodePoolConfig: Required. The generic configuration for a node pool
	// running the control plane.
	NodePoolConfig *BareMetalNodePoolConfig `json:"nodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodePoolConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodePoolConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalControlPlaneNodePoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalControlPlaneNodePoolConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalDrainedMachine: Represents a machine that is currently
// drained.
type BareMetalDrainedMachine struct {
	// NodeIp: Drained machine IP address.
	NodeIp string `json:"nodeIp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodeIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodeIp") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalDrainedMachine) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalDrainedMachine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalDrainingMachine: Represents a machine that is currently
// draining.
type BareMetalDrainingMachine struct {
	// NodeIp: Draining machine IP address.
	NodeIp string `json:"nodeIp,omitempty"`

	// PodCount: The count of pods yet to drain.
	PodCount int64 `json:"podCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodeIp") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodeIp") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalDrainingMachine) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalDrainingMachine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalIslandModeCidrConfig: Specifies the cluster CIDR
// configuration while running in island mode.
type BareMetalIslandModeCidrConfig struct {
	// PodAddressCidrBlocks: Required. All pods in the cluster are assigned
	// an RFC1918 IPv4 address from these ranges. This field cannot be
	// changed after creation.
	PodAddressCidrBlocks []string `json:"podAddressCidrBlocks,omitempty"`

	// ServiceAddressCidrBlocks: Required. All services in the cluster are
	// assigned an RFC1918 IPv4 address from these ranges. This field is
	// mutable after creation starting with version 1.15.
	ServiceAddressCidrBlocks []string `json:"serviceAddressCidrBlocks,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PodAddressCidrBlocks") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PodAddressCidrBlocks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalIslandModeCidrConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalIslandModeCidrConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalKubeletConfig: KubeletConfig defines the modifiable kubelet
// configurations for bare metal machines. Note: this list includes
// fields supported in GKE (see
// https://cloud.google.com/kubernetes-engine/docs/how-to/node-system-config#kubelet-options).
type BareMetalKubeletConfig struct {
	// RegistryBurst: The maximum size of bursty pulls, temporarily allows
	// pulls to burst to this number, while still not exceeding
	// registry_pull_qps. The value must not be a negative number. Updating
	// this field may impact scalability by changing the amount of traffic
	// produced by image pulls. Defaults to 10.
	RegistryBurst int64 `json:"registryBurst,omitempty"`

	// RegistryPullQps: The limit of registry pulls per second. Setting this
	// value to 0 means no limit. Updating this field may impact scalability
	// by changing the amount of traffic produced by image pulls. Defaults
	// to 5.
	RegistryPullQps int64 `json:"registryPullQps,omitempty"`

	// SerializeImagePullsDisabled: Prevents the Kubelet from pulling
	// multiple images at a time. We recommend *not* changing the default
	// value on nodes that run docker daemon with version < 1.9 or an
	// Another Union File System (Aufs) storage backend. Issue
	// https://github.com/kubernetes/kubernetes/issues/10959 has more
	// details.
	SerializeImagePullsDisabled bool `json:"serializeImagePullsDisabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RegistryBurst") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RegistryBurst") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalKubeletConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalKubeletConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalLoadBalancerAddressPool: Represents an IP pool used by the
// load balancer.
type BareMetalLoadBalancerAddressPool struct {
	// Addresses: Required. The addresses that are part of this pool. Each
	// address must be either in the CIDR form (1.2.3.0/24) or range form
	// (1.2.3.1-1.2.3.5).
	Addresses []string `json:"addresses,omitempty"`

	// AvoidBuggyIps: If true, avoid using IPs ending in .0 or .255. This
	// avoids buggy consumer devices mistakenly dropping IPv4 traffic for
	// those special IP addresses.
	AvoidBuggyIps bool `json:"avoidBuggyIps,omitempty"`

	// ManualAssign: If true, prevent IP addresses from being automatically
	// assigned.
	ManualAssign bool `json:"manualAssign,omitempty"`

	// Pool: Required. The name of the address pool.
	Pool string `json:"pool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Addresses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalLoadBalancerAddressPool) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalLoadBalancerAddressPool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalLoadBalancerConfig: Specifies the load balancer
// configuration.
type BareMetalLoadBalancerConfig struct {
	// BgpLbConfig: Configuration for BGP typed load balancers. When set
	// network_config.advanced_networking is automatically set to true.
	BgpLbConfig *BareMetalBgpLbConfig `json:"bgpLbConfig,omitempty"`

	// ManualLbConfig: Manually configured load balancers.
	ManualLbConfig *BareMetalManualLbConfig `json:"manualLbConfig,omitempty"`

	// MetalLbConfig: Configuration for MetalLB load balancers.
	MetalLbConfig *BareMetalMetalLbConfig `json:"metalLbConfig,omitempty"`

	// PortConfig: Configures the ports that the load balancer will listen
	// on.
	PortConfig *BareMetalPortConfig `json:"portConfig,omitempty"`

	// VipConfig: The VIPs used by the load balancer.
	VipConfig *BareMetalVipConfig `json:"vipConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BgpLbConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BgpLbConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalLoadBalancerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalLoadBalancerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalLoadBalancerNodePoolConfig: Specifies the load balancer's
// node pool configuration.
type BareMetalLoadBalancerNodePoolConfig struct {
	// NodePoolConfig: The generic configuration for a node pool running a
	// load balancer.
	NodePoolConfig *BareMetalNodePoolConfig `json:"nodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NodePoolConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NodePoolConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalLoadBalancerNodePoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalLoadBalancerNodePoolConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalLvpConfig: Specifies the configs for local persistent
// volumes (PVs).
type BareMetalLvpConfig struct {
	// Path: Required. The host machine path.
	Path string `json:"path,omitempty"`

	// StorageClass: Required. The StorageClass name that PVs will be
	// created with.
	StorageClass string `json:"storageClass,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Path") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Path") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalLvpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalLvpConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalLvpShareConfig: Specifies the configs for local persistent
// volumes under a shared file system.
type BareMetalLvpShareConfig struct {
	// LvpConfig: Required. Defines the machine path and storage class for
	// the LVP Share.
	LvpConfig *BareMetalLvpConfig `json:"lvpConfig,omitempty"`

	// SharedPathPvCount: The number of subdirectories to create under path.
	SharedPathPvCount int64 `json:"sharedPathPvCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LvpConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LvpConfig") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalLvpShareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalLvpShareConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalMachineDrainStatus: Represents the status of node machines
// that are undergoing drain operations.
type BareMetalMachineDrainStatus struct {
	// DrainedMachines: The list of drained machines.
	DrainedMachines []*BareMetalDrainedMachine `json:"drainedMachines,omitempty"`

	// DrainingMachines: The list of draning machines.
	DrainingMachines []*BareMetalDrainingMachine `json:"drainingMachines,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DrainedMachines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DrainedMachines") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalMachineDrainStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalMachineDrainStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalMaintenanceConfig: Specifies configurations to put bare
// metal nodes in and out of maintenance.
type BareMetalMaintenanceConfig struct {
	// MaintenanceAddressCidrBlocks: Required. All IPv4 address from these
	// ranges will be placed into maintenance mode. Nodes in maintenance
	// mode will be cordoned and drained. When both of these are true, the
	// "baremetal.cluster.gke.io/maintenance" annotation will be set on the
	// node resource.
	MaintenanceAddressCidrBlocks []string `json:"maintenanceAddressCidrBlocks,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaintenanceAddressCidrBlocks") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MaintenanceAddressCidrBlocks") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalMaintenanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalMaintenanceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalMaintenanceStatus: Represents the maintenance status of the
// bare metal user cluster.
type BareMetalMaintenanceStatus struct {
	// MachineDrainStatus: The maintenance status of node machines.
	MachineDrainStatus *BareMetalMachineDrainStatus `json:"machineDrainStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineDrainStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineDrainStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalMaintenanceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalMaintenanceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalManualLbConfig: Represents configuration parameters for a
// manual load balancer.
type BareMetalManualLbConfig struct {
	// Enabled: Whether manual load balancing is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalManualLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalManualLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalMetalLbConfig: Represents configuration parameters for a
// MetalLB load balancer.
type BareMetalMetalLbConfig struct {
	// AddressPools: Required. AddressPools is a list of non-overlapping IP
	// pools used by load balancer typed services. All addresses must be
	// routable to load balancer nodes. IngressVIP must be included in the
	// pools.
	AddressPools []*BareMetalLoadBalancerAddressPool `json:"addressPools,omitempty"`

	// LoadBalancerNodePoolConfig: Specifies the node pool running the load
	// balancer. L2 connectivity is required among nodes in this pool. If
	// missing, the control plane node pool is used as the load balancer
	// pool.
	LoadBalancerNodePoolConfig *BareMetalLoadBalancerNodePoolConfig `json:"loadBalancerNodePoolConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressPools") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressPools") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalMetalLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalMetalLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalMultipleNetworkInterfacesConfig: Specifies the multiple
// networking interfaces cluster configuration.
type BareMetalMultipleNetworkInterfacesConfig struct {
	// Enabled: Whether to enable multiple network interfaces for your pods.
	// When set network_config.advanced_networking is automatically set to
	// true.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalMultipleNetworkInterfacesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalMultipleNetworkInterfacesConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNetworkConfig: Specifies the cluster network configuration.
type BareMetalNetworkConfig struct {
	// AdvancedNetworking: Enables the use of advanced Anthos networking
	// features, such as Bundled Load Balancing with BGP or the egress NAT
	// gateway. Setting configuration for advanced networking features will
	// automatically set this flag.
	AdvancedNetworking bool `json:"advancedNetworking,omitempty"`

	// IslandModeCidr: Configuration for island mode CIDR. In an island-mode
	// network, nodes have unique IP addresses, but pods don't have unique
	// addresses across clusters. This doesn't cause problems because pods
	// in one cluster never directly communicate with pods in another
	// cluster. Instead, there are gateways that mediate between a pod in
	// one cluster and a pod in another cluster.
	IslandModeCidr *BareMetalIslandModeCidrConfig `json:"islandModeCidr,omitempty"`

	// MultipleNetworkInterfacesConfig: Configuration for multiple network
	// interfaces.
	MultipleNetworkInterfacesConfig *BareMetalMultipleNetworkInterfacesConfig `json:"multipleNetworkInterfacesConfig,omitempty"`

	// SrIovConfig: Configuration for SR-IOV.
	SrIovConfig *BareMetalSrIovConfig `json:"srIovConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdvancedNetworking")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedNetworking") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNetworkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNodeAccessConfig: Specifies the node access related settings
// for the bare metal user cluster.
type BareMetalNodeAccessConfig struct {
	// LoginUser: LoginUser is the user name used to access node machines.
	// It defaults to "root" if not set.
	LoginUser string `json:"loginUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LoginUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LoginUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNodeAccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNodeAccessConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNodeConfig: BareMetalNodeConfig lists machine addresses to
// access Nodes.
type BareMetalNodeConfig struct {
	// Labels: The labels assigned to this node. An object containing a list
	// of key/value pairs. The labels here, unioned with the labels set on
	// BareMetalNodePoolConfig are the set of labels that will be applied to
	// the node. If there are any conflicts, the BareMetalNodeConfig labels
	// take precedence. Example: { "name": "wrench", "mass": "1.3kg",
	// "count": "3" }.
	Labels map[string]string `json:"labels,omitempty"`

	// NodeIp: The default IPv4 address for SSH access and Kubernetes node.
	// Example: 192.168.0.1
	NodeIp string `json:"nodeIp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNodePool: Resource that represents a bare metal node pool.
type BareMetalNodePool struct {
	// Annotations: Annotations on the bare metal node pool. This field has
	// the same restrictions as Kubernetes annotations. The total size of
	// all keys and values combined is limited to 256k. Key can have 2
	// segments: prefix (optional) and name (required), separated by a slash
	// (/). Prefix must be a DNS subdomain. Name must be 63 characters or
	// less, begin and end with alphanumerics, with dashes (-), underscores
	// (_), dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// CreateTime: Output only. The time at which this bare metal node pool
	// was created.
	CreateTime string `json:"createTime,omitempty"`

	// DeleteTime: Output only. The time at which this bare metal node pool
	// was deleted. If the resource is not deleted, this must be empty
	DeleteTime string `json:"deleteTime,omitempty"`

	// DisplayName: The display name for the bare metal node pool.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Allows clients
	// to perform consistent read-modify-writes through optimistic
	// concurrency control.
	Etag string `json:"etag,omitempty"`

	// Name: Immutable. The bare metal node pool resource name.
	Name string `json:"name,omitempty"`

	// NodePoolConfig: Required. Node pool configuration.
	NodePoolConfig *BareMetalNodePoolConfig `json:"nodePoolConfig,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the bare metal node pool.
	Reconciling bool `json:"reconciling,omitempty"`

	// State: Output only. The current state of the bare metal node pool.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the bare metal
	// node pool is being created.
	//   "RUNNING" - The RUNNING state indicates the bare metal node pool
	// has been created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the bare metal
	// node pool is being updated. It remains available, but potentially
	// with degraded performance.
	//   "STOPPING" - The STOPPING state indicates the bare metal node pool
	// is being deleted.
	//   "ERROR" - The ERROR state indicates the bare metal node pool is in
	// a broken unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the bare metal node pool
	// requires user action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. ResourceStatus representing the detailed node
	// pool status.
	Status *ResourceStatus `json:"status,omitempty"`

	// Uid: Output only. The unique identifier of the bare metal node pool.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time at which this bare metal node pool
	// was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// UpgradePolicy: The worker node pool upgrade policy.
	UpgradePolicy *BareMetalNodePoolUpgradePolicy `json:"upgradePolicy,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNodePool) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNodePool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNodePoolConfig: BareMetalNodePoolConfig describes the
// configuration of all nodes within a given bare metal node pool.
type BareMetalNodePoolConfig struct {
	// KubeletConfig: The modifiable kubelet configurations for the bare
	// metal machines.
	KubeletConfig *BareMetalKubeletConfig `json:"kubeletConfig,omitempty"`

	// Labels: The labels assigned to nodes of this node pool. An object
	// containing a list of key/value pairs. Example: { "name": "wrench",
	// "mass": "1.3kg", "count": "3" }.
	Labels map[string]string `json:"labels,omitempty"`

	// NodeConfigs: Required. The list of machine addresses in the bare
	// metal node pool.
	NodeConfigs []*BareMetalNodeConfig `json:"nodeConfigs,omitempty"`

	// OperatingSystem: Specifies the nodes operating system (default:
	// LINUX).
	//
	// Possible values:
	//   "OPERATING_SYSTEM_UNSPECIFIED" - No operating system runtime
	// selected.
	//   "LINUX" - Linux operating system.
	OperatingSystem string `json:"operatingSystem,omitempty"`

	// Taints: The initial taints assigned to nodes of this node pool.
	Taints []*NodeTaint `json:"taints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KubeletConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KubeletConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNodePoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNodePoolConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalNodePoolUpgradePolicy: BareMetalNodePoolUpgradePolicy
// defines the node pool upgrade policy.
type BareMetalNodePoolUpgradePolicy struct {
	// ParallelUpgradeConfig: The parallel upgrade settings for worker node
	// pools.
	ParallelUpgradeConfig *BareMetalParallelUpgradeConfig `json:"parallelUpgradeConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ParallelUpgradeConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ParallelUpgradeConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalNodePoolUpgradePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalNodePoolUpgradePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalOsEnvironmentConfig: Specifies operating system settings for
// cluster provisioning.
type BareMetalOsEnvironmentConfig struct {
	// PackageRepoExcluded: Whether the package repo should not be included
	// when initializing bare metal machines.
	PackageRepoExcluded bool `json:"packageRepoExcluded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PackageRepoExcluded")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PackageRepoExcluded") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalOsEnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalOsEnvironmentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalParallelUpgradeConfig: BareMetalParallelUpgradeConfig
// defines the parallel upgrade settings for worker node pools.
type BareMetalParallelUpgradeConfig struct {
	// ConcurrentNodes: Required. The maximum number of nodes that can be
	// upgraded at once. Defaults to 1.
	ConcurrentNodes int64 `json:"concurrentNodes,omitempty"`

	// MinimumAvailableNodes: The minimum number of nodes that should be
	// healthy and available during an upgrade. If set to the default value
	// of 0, it is possible that none of the nodes will be available during
	// an upgrade.
	MinimumAvailableNodes int64 `json:"minimumAvailableNodes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConcurrentNodes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConcurrentNodes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalParallelUpgradeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalParallelUpgradeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalPortConfig: Specifies load balancer ports for the bare metal
// user cluster.
type BareMetalPortConfig struct {
	// ControlPlaneLoadBalancerPort: The port that control plane hosted load
	// balancers will listen on.
	ControlPlaneLoadBalancerPort int64 `json:"controlPlaneLoadBalancerPort,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ControlPlaneLoadBalancerPort") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ControlPlaneLoadBalancerPort") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalPortConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalPortConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalProxyConfig: Specifies the cluster proxy configuration.
type BareMetalProxyConfig struct {
	// NoProxy: A list of IPs, hostnames, and domains that should skip the
	// proxy. Examples: ["127.0.0.1", "example.com", ".corp", "localhost"].
	NoProxy []string `json:"noProxy,omitempty"`

	// Uri: Required. Specifies the address of your proxy server. Examples:
	// `http://domain` Do not provide credentials in the format
	// `http://(username:password@)domain` these will be rejected by the
	// server.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NoProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NoProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalProxyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalProxyConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalSecurityConfig: Specifies the security related settings for
// the bare metal user cluster.
type BareMetalSecurityConfig struct {
	// Authorization: Configures user access to the user cluster.
	Authorization *Authorization `json:"authorization,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Authorization") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Authorization") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalSecurityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalSecurityConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalSrIovConfig: Specifies the SR-IOV networking operator
// config.
type BareMetalSrIovConfig struct {
	// Enabled: Whether to install the SR-IOV operator.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalSrIovConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalSrIovConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalStorageConfig: BareMetalStorageConfig specifies the cluster
// storage configuration.
type BareMetalStorageConfig struct {
	// LvpNodeMountsConfig: Required. Specifies the config for local
	// PersistentVolumes backed by mounted node disks. These disks need to
	// be formatted and mounted by the user, which can be done before or
	// after cluster creation.
	LvpNodeMountsConfig *BareMetalLvpConfig `json:"lvpNodeMountsConfig,omitempty"`

	// LvpShareConfig: Required. Specifies the config for local
	// PersistentVolumes backed by subdirectories in a shared filesystem.
	// These subdirectores are automatically created during cluster
	// creation.
	LvpShareConfig *BareMetalLvpShareConfig `json:"lvpShareConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LvpNodeMountsConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LvpNodeMountsConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalStorageConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalVersionInfo: Contains information about a specific Anthos on
// bare metal version.
type BareMetalVersionInfo struct {
	// Dependencies: The list of upgrade dependencies for this version.
	Dependencies []*UpgradeDependency `json:"dependencies,omitempty"`

	// HasDependencies: If set, the cluster dependencies (e.g. the admin
	// cluster, other user clusters managed by the same admin cluster,
	// version skew policy, etc) must be upgraded before this version can be
	// installed or upgraded to.
	HasDependencies bool `json:"hasDependencies,omitempty"`

	// Version: Version number e.g. 1.13.1.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dependencies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dependencies") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalVersionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalVersionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalVipConfig: Specifies the VIP config for the bare metal load
// balancer.
type BareMetalVipConfig struct {
	// ControlPlaneVip: The VIP which you previously set aside for the
	// Kubernetes API of this bare metal user cluster.
	ControlPlaneVip string `json:"controlPlaneVip,omitempty"`

	// IngressVip: The VIP which you previously set aside for ingress
	// traffic into this bare metal user cluster.
	IngressVip string `json:"ingressVip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ControlPlaneVip") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneVip") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalVipConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalVipConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BareMetalWorkloadNodeConfig: Specifies the workload node
// configurations.
type BareMetalWorkloadNodeConfig struct {
	// ContainerRuntime: Specifies which container runtime will be used.
	//
	// Possible values:
	//   "CONTAINER_RUNTIME_UNSPECIFIED" - No container runtime selected.
	//   "CONTAINERD" - Containerd runtime.
	ContainerRuntime string `json:"containerRuntime,omitempty"`

	// MaxPodsPerNode: The maximum number of pods a node can run. The size
	// of the CIDR range assigned to the node will be derived from this
	// parameter.
	MaxPodsPerNode int64 `json:"maxPodsPerNode,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ContainerRuntime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerRuntime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BareMetalWorkloadNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BareMetalWorkloadNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently
	// deleted. For example, `alice@example.com?uid=123456789012345678901`.
	// If the user is recovered, this value reverts to `user:{emailid}` and
	// the recovered user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for
// Operations.CancelOperation.
type CancelOperationRequest struct {
}

// ClusterUser: ClusterUser configures user principals for an RBAC
// policy.
type ClusterUser struct {
	// Username: Required. The name of the user, e.g. `my-gcp-id@gmail.com`.
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Username") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Username") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ClusterUser) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterUser
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// EnrollBareMetalAdminClusterRequest: Message for enrolling an existing
// bare metal admin cluster to the GKE on-prem API.
type EnrollBareMetalAdminClusterRequest struct {
	// BareMetalAdminClusterId: User provided OnePlatform identifier that is
	// used as part of the resource name. This must be unique among all GKE
	// on-prem clusters within a project and location and will return a 409
	// if the cluster already exists. This value must be up to 40 characters
	// and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
	BareMetalAdminClusterId string `json:"bareMetalAdminClusterId,omitempty"`

	// Membership: Required. This is the full resource name of this admin
	// cluster's fleet membership.
	Membership string `json:"membership,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BareMetalAdminClusterId") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BareMetalAdminClusterId")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnrollBareMetalAdminClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollBareMetalAdminClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnrollBareMetalClusterRequest: Message for enrolling an existing bare
// metal cluster to the Anthos On-Prem API.
type EnrollBareMetalClusterRequest struct {
	// AdminClusterMembership: Required. The admin cluster this bare metal
	// user cluster belongs to. This is the full resource name of the admin
	// cluster's fleet membership. In the future, references to other
	// resource types might be allowed if admin clusters are modeled as
	// their own resources.
	AdminClusterMembership string `json:"adminClusterMembership,omitempty"`

	// BareMetalClusterId: User provided OnePlatform identifier that is used
	// as part of the resource name. This must be unique among all bare
	// metal clusters within a project and location and will return a 409 if
	// the cluster already exists. This value must be up to 40 characters
	// and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
	BareMetalClusterId string `json:"bareMetalClusterId,omitempty"`

	// LocalName: The object name of the bare metal cluster custom resource
	// on the associated admin cluster. This field is used to support
	// conflicting resource names when enrolling existing clusters to the
	// API. When not provided, this field will resolve to the
	// bare_metal_cluster_id. Otherwise, it must match the object name of
	// the bare metal cluster custom resource. It is not modifiable outside
	// / beyond the enrollment operation.
	LocalName string `json:"localName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdminClusterMembership") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminClusterMembership")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnrollBareMetalClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollBareMetalClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnrollBareMetalNodePoolRequest: Message for enrolling an existing
// bare metal node pool to the GKE on-prem API.
type EnrollBareMetalNodePoolRequest struct {
	// BareMetalNodePoolId: User provided OnePlatform identifier that is
	// used as part of the resource name. This value must be up to 40
	// characters and follow RFC-1123 (https://tools.ietf.org/html/rfc1123)
	// format.
	BareMetalNodePoolId string `json:"bareMetalNodePoolId,omitempty"`

	// ValidateOnly: If set, only validate the request, but do not actually
	// enroll the node pool.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BareMetalNodePoolId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BareMetalNodePoolId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnrollBareMetalNodePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollBareMetalNodePoolRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnrollVmwareAdminClusterRequest: Message for enrolling an existing
// VMware admin cluster to the GKE on-prem API.
type EnrollVmwareAdminClusterRequest struct {
	// Membership: Required. This is the full resource name of this admin
	// cluster's fleet membership.
	Membership string `json:"membership,omitempty"`

	// VmwareAdminClusterId: User provided OnePlatform identifier that is
	// used as part of the resource name. This must be unique among all GKE
	// on-prem clusters within a project and location and will return a 409
	// if the cluster already exists. This value must be up to 40 characters
	// and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
	VmwareAdminClusterId string `json:"vmwareAdminClusterId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Membership") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnrollVmwareAdminClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollVmwareAdminClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnrollVmwareClusterRequest: Message for enrolling an existing VMware
// cluster to the Anthos On-Prem API.
type EnrollVmwareClusterRequest struct {
	// AdminClusterMembership: Required. The admin cluster this VMware user
	// cluster belongs to. This is the full resource name of the admin
	// cluster's fleet membership. In the future, references to other
	// resource types might be allowed if admin clusters are modeled as
	// their own resources.
	AdminClusterMembership string `json:"adminClusterMembership,omitempty"`

	// LocalName: The object name of the VMware OnPremUserCluster custom
	// resource on the associated admin cluster. This field is used to
	// support conflicting resource names when enrolling existing clusters
	// to the API. When not provided, this field will resolve to the
	// vmware_cluster_id. Otherwise, it must match the object name of the
	// VMware OnPremUserCluster custom resource. It is not modifiable
	// outside / beyond the enrollment operation.
	LocalName string `json:"localName,omitempty"`

	// ValidateOnly: Validate the request without actually doing any
	// updates.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// VmwareClusterId: User provided OnePlatform identifier that is used as
	// part of the resource name. This must be unique among all GKE on-prem
	// clusters within a project and location and will return a 409 if the
	// cluster already exists. This value must be up to 40 characters and
	// follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
	VmwareClusterId string `json:"vmwareClusterId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdminClusterMembership") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminClusterMembership")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnrollVmwareClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollVmwareClusterRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnrollVmwareNodePoolRequest: Message for enrolling a VMware node
// pool.
type EnrollVmwareNodePoolRequest struct {
	// VmwareNodePoolId: The target node pool id to be enrolled.
	VmwareNodePoolId string `json:"vmwareNodePoolId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "VmwareNodePoolId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VmwareNodePoolId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnrollVmwareNodePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EnrollVmwareNodePoolRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Fleet: Fleet related configuration. Fleets are a Google Cloud concept
// for logically organizing clusters, letting you use and manage
// multi-cluster capabilities and apply consistent policies across your
// systems. See Anthos Fleets
// (`https://cloud.google.com/anthos/multicluster-management/fleets`)
// for more details on Anthos multi-cluster capabilities using Fleets.
// ##
type Fleet struct {
	// Membership: Output only. The name of the managed fleet Membership
	// resource associated to this cluster. Membership names are formatted
	// as `projects//locations//memberships/`.
	Membership string `json:"membership,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Membership") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Fleet) MarshalJSON() ([]byte, error) {
	type NoMethod Fleet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListBareMetalAdminClustersResponse: Response message for listing bare
// metal admin clusters.
type ListBareMetalAdminClustersResponse struct {
	// BareMetalAdminClusters: The list of bare metal admin cluster.
	BareMetalAdminClusters []*BareMetalAdminCluster `json:"bareMetalAdminClusters,omitempty"`

	// NextPageToken: A token identifying a page of results the server
	// should return. If the token is not empty this means that more results
	// are available and should be retrieved by repeating the request with
	// the provided page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "BareMetalAdminClusters") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BareMetalAdminClusters")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListBareMetalAdminClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBareMetalAdminClustersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListBareMetalClustersResponse: Response message for listing bare
// metal Clusters.
type ListBareMetalClustersResponse struct {
	// BareMetalClusters: The list of bare metal Clusters.
	BareMetalClusters []*BareMetalCluster `json:"bareMetalClusters,omitempty"`

	// NextPageToken: A token identifying a page of results the server
	// should return. If the token is not empty this means that more results
	// are available and should be retrieved by repeating the request with
	// the provided page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BareMetalClusters")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BareMetalClusters") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListBareMetalClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBareMetalClustersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListBareMetalNodePoolsResponse: Response message for listing bare
// metal node pools.
type ListBareMetalNodePoolsResponse struct {
	// BareMetalNodePools: The node pools from the specified parent
	// resource.
	BareMetalNodePools []*BareMetalNodePool `json:"bareMetalNodePools,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BareMetalNodePools")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BareMetalNodePools") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ListBareMetalNodePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBareMetalNodePoolsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for
// Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*Location `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for
// Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListVmwareAdminClustersResponse: Response message for listing VMware
// admin clusters.
type ListVmwareAdminClustersResponse struct {
	// NextPageToken: A token identifying a page of results the server
	// should return. If the token is not empty this means that more results
	// are available and should be retrieved by repeating the request with
	// the provided page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// VmwareAdminClusters: The list of VMware admin cluster.
	VmwareAdminClusters []*VmwareAdminCluster `json:"vmwareAdminClusters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListVmwareAdminClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVmwareAdminClustersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListVmwareClustersResponse: Response message for listing VMware
// Clusters.
type ListVmwareClustersResponse struct {
	// NextPageToken: A token identifying a page of results the server
	// should return. If the token is not empty this means that more results
	// are available and should be retrieved by repeating the request with
	// the provided page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// VmwareClusters: The list of VMware Cluster.
	VmwareClusters []*VmwareCluster `json:"vmwareClusters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListVmwareClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVmwareClustersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListVmwareNodePoolsResponse: Response message for listing VMware node
// pools.
type ListVmwareNodePoolsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// VmwareNodePools: The node pools from the specified parent resource.
	VmwareNodePools []*VmwareNodePool `json:"vmwareNodePools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListVmwareNodePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVmwareNodePoolsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// NodeTaint: NodeTaint applied to every Kubernetes node in a node pool.
// Kubernetes taints can be used together with tolerations to control
// how workloads are scheduled to your nodes. Node taints are permanent.
type NodeTaint struct {
	// Effect: The taint effect.
	//
	// Possible values:
	//   "EFFECT_UNSPECIFIED" - Not set.
	//   "NO_SCHEDULE" - Do not allow new pods to schedule onto the node
	// unless they tolerate the taint, but allow all pods submitted to
	// Kubelet without going through the scheduler to start, and allow all
	// already-running pods to continue running. Enforced by the scheduler.
	//   "PREFER_NO_SCHEDULE" - Like TaintEffectNoSchedule, but the
	// scheduler tries not to schedule new pods onto the node, rather than
	// prohibiting new pods from scheduling onto the node entirely. Enforced
	// by the scheduler.
	//   "NO_EXECUTE" - Evict any already-running pods that do not tolerate
	// the taint. Currently enforced by NodeController.
	Effect string `json:"effect,omitempty"`

	// Key: Key associated with the effect.
	Key string `json:"key,omitempty"`

	// Value: Value associated with the effect.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Effect") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Effect") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *NodeTaint) MarshalJSON() ([]byte, error) {
	type NoMethod NodeTaint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running
// operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`

	// ControlPlaneDisconnected: Output only. Denotes if the local managing
	// cluster's control plane is currently disconnected. This is expected
	// to occur temporarily during self-managed cluster upgrades.
	ControlPlaneDisconnected bool `json:"controlPlaneDisconnected,omitempty"`

	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have
	// successfully been cancelled have [Operation.error] value with a
	// [google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`

	// StatusMessage: Output only. Human-readable status of the operation,
	// if any.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Target: Output only. Server-defined resource path for the target of
	// the operation.
	Target string `json:"target,omitempty"`

	// Type: Output only. Type of operation being executed.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Not set.
	//   "CREATE" - The resource is being created.
	//   "DELETE" - The resource is being deleted.
	//   "UPDATE" - The resource is being updated.
	//   "UPGRADE" - The resource is being upgraded.
	Type string `json:"type,omitempty"`

	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts,
// service accounts, Google groups, and domains (such as G Suite). A
// `role` is a named list of permissions; each `role` can be an IAM
// predefined role or a user-created custom role. For some types of
// Google Cloud resources, a `binding` can also specify a `condition`,
// which is a logical expression that allows access to a resource only
// if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or
// both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// For a description of IAM and its features, see the IAM documentation
// (https://cloud.google.com/iam/docs/).
type Policy struct {
	// Bindings: Associates a list of `members`, or principals, with a
	// `role`. Optionally, may specify a `condition` that determines how and
	// when the `bindings` are applied. Each of the `bindings` must contain
	// at least one principal. The `bindings` in a `Policy` can refer to up
	// to 1,500 principals; up to 250 of these principals can be Google
	// groups. Each occurrence of a principal counts towards these limits.
	// For example, if the `bindings` grant 50 different roles to
	// `user:alice@example.com`, and not to any other principal, then you
	// can add another 1,450 principals to the `bindings` in the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bindings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryBareMetalAdminVersionConfigResponse: Response message for
// querying bare metal admin cluster version config.
type QueryBareMetalAdminVersionConfigResponse struct {
	// Versions: List of available versions to install or to upgrade to.
	Versions []*BareMetalVersionInfo `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Versions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Versions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryBareMetalAdminVersionConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryBareMetalAdminVersionConfigResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryBareMetalVersionConfigResponse: Response message for querying
// bare metal admin cluster version config.
type QueryBareMetalVersionConfigResponse struct {
	// Versions: List of available versions to install or to upgrade to.
	Versions []*BareMetalVersionInfo `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Versions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Versions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryBareMetalVersionConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryBareMetalVersionConfigResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryVmwareVersionConfigResponse: Response message for querying
// VMware user cluster version config.
type QueryVmwareVersionConfigResponse struct {
	// Versions: List of available versions to install or to upgrade to.
	Versions []*VmwareVersionInfo `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Versions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Versions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryVmwareVersionConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryVmwareVersionConfigResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceCondition: ResourceCondition provides a standard mechanism
// for higher-level status reporting from controller.
type ResourceCondition struct {
	// LastTransitionTime: Last time the condition transit from one status
	// to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`

	// Message: Human-readable message indicating details about last
	// transition.
	Message string `json:"message,omitempty"`

	// Reason: Machine-readable message indicating details about last
	// transition.
	Reason string `json:"reason,omitempty"`

	// State: state of the condition.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "STATE_TRUE" - Resource is in the condition.
	//   "STATE_FALSE" - Resource is not in the condition.
	//   "STATE_UNKNOWN" - Kubernetes controller can't decide if the
	// resource is in the condition or not.
	State string `json:"state,omitempty"`

	// Type: Type of the condition. (e.g., ClusterRunning, NodePoolRunning
	// or ServerSidePreflightReady)
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastTransitionTime")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastTransitionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResourceCondition) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceCondition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceStatus: ResourceStatus describes why a cluster or node pool
// has a certain status. (e.g., ERROR or DEGRADED).
type ResourceStatus struct {
	// Conditions: ResourceCondition provide a standard mechanism for
	// higher-level status reporting from controller.
	Conditions []*ResourceCondition `json:"conditions,omitempty"`

	// ErrorMessage: Human-friendly representation of the error message from
	// controller. The error message can be temporary as the controller
	// controller creates a cluster or node pool. If the error message
	// persists for a longer period of time, it can be used to surface error
	// message to indicate real problems requiring user intervention.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conditions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the
	// `resource`. The size of the policy is limited to a few 10s of KB. An
	// empty policy is a valid policy but certain Google Cloud services
	// (such as Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions`
// method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`.
	// Permissions with wildcards (such as `*` or `storage.*`) are not
	// allowed. For more information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that
	// the caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpgradeDependency: UpgradeDependency represents a dependency when
// upgrading a resource.
type UpgradeDependency struct {
	// CurrentVersion: Current version of the dependency e.g. 1.15.0.
	CurrentVersion string `json:"currentVersion,omitempty"`

	// LocalName: Local name of the dependency.
	LocalName string `json:"localName,omitempty"`

	// ResourceName: Resource name of the dependency.
	ResourceName string `json:"resourceName,omitempty"`

	// TargetVersion: Target version of the dependency e.g. 1.16.1. This is
	// the version the dependency needs to be upgraded to before a resource
	// can be upgraded.
	TargetVersion string `json:"targetVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UpgradeDependency) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeDependency
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValidationCheck: ValidationCheck represents the result of preflight
// check.
type ValidationCheck struct {
	// Option: Options used for the validation check
	//
	// Possible values:
	//   "OPTIONS_UNSPECIFIED" - Default value. Standard preflight
	// validation check will be used.
	//   "SKIP_VALIDATION_CHECK_BLOCKING" - Prevent failed preflight checks
	// from failing.
	//   "SKIP_VALIDATION_ALL" - Skip all preflight check validations.
	Option string `json:"option,omitempty"`

	// Scenario: Output only. The scenario when the preflight checks were
	// run.
	//
	// Possible values:
	//   "SCENARIO_UNSPECIFIED" - Default value. This value is unused.
	//   "CREATE" - The validation check occurred during a create flow.
	//   "UPDATE" - The validation check occurred during an update flow.
	Scenario string `json:"scenario,omitempty"`

	// Status: Output only. The detailed validation check status.
	Status *ValidationCheckStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Option") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Option") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValidationCheck) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValidationCheckResult: ValidationCheckResult defines the details
// about the validation check.
type ValidationCheckResult struct {
	// Category: The category of the validation.
	Category string `json:"category,omitempty"`

	// Description: The description of the validation check.
	Description string `json:"description,omitempty"`

	// Details: Detailed failure information, which might be unformatted.
	Details string `json:"details,omitempty"`

	// Reason: A human-readable message of the check failure.
	Reason string `json:"reason,omitempty"`

	// State: The validation check state.
	//
	// Possible values:
	//   "STATE_UNKNOWN" - The default value. The check result is unknown.
	//   "STATE_FAILURE" - The check failed.
	//   "STATE_SKIPPED" - The check was skipped.
	//   "STATE_FATAL" - The check itself failed to complete.
	//   "STATE_WARNING" - The check encountered a warning.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValidationCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationCheckResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ValidationCheckStatus: ValidationCheckStatus defines the detailed
// validation check status.
type ValidationCheckStatus struct {
	// Result: Individual checks which failed as part of the Preflight check
	// execution.
	Result []*ValidationCheckResult `json:"result,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Result") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ValidationCheckStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ValidationCheckStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAAGConfig: Specifies anti affinity group config for the VMware
// user cluster.
type VmwareAAGConfig struct {
	// AagConfigDisabled: Spread nodes across at least three physical hosts
	// (requires at least three hosts). Enabled by default.
	AagConfigDisabled bool `json:"aagConfigDisabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AagConfigDisabled")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AagConfigDisabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAAGConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAAGConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAddressPool: Represents an IP pool used by the load balancer.
type VmwareAddressPool struct {
	// Addresses: Required. The addresses that are part of this pool. Each
	// address must be either in the CIDR form (1.2.3.0/24) or range form
	// (1.2.3.1-1.2.3.5).
	Addresses []string `json:"addresses,omitempty"`

	// AvoidBuggyIps: If true, avoid using IPs ending in .0 or .255. This
	// avoids buggy consumer devices mistakenly dropping IPv4 traffic for
	// those special IP addresses.
	AvoidBuggyIps bool `json:"avoidBuggyIps,omitempty"`

	// ManualAssign: If true, prevent IP addresses from being automatically
	// assigned.
	ManualAssign bool `json:"manualAssign,omitempty"`

	// Pool: Required. The name of the address pool.
	Pool string `json:"pool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Addresses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAddressPool) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAddressPool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminAddonNodeConfig: VmwareAdminAddonNodeConfig contains
// add-on node configurations for VMware admin cluster.
type VmwareAdminAddonNodeConfig struct {
	// AutoResizeConfig: VmwareAutoResizeConfig config specifies auto resize
	// config.
	AutoResizeConfig *VmwareAutoResizeConfig `json:"autoResizeConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoResizeConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoResizeConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminAddonNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminAddonNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminCluster: Resource that represents a VMware admin cluster.
type VmwareAdminCluster struct {
	// AddonNode: The VMware admin cluster addon node configuration.
	AddonNode *VmwareAdminAddonNodeConfig `json:"addonNode,omitempty"`

	// Annotations: Annotations on the VMware admin cluster. This field has
	// the same restrictions as Kubernetes annotations. The total size of
	// all keys and values combined is limited to 256k. Key can have 2
	// segments: prefix (optional) and name (required), separated by a slash
	// (/). Prefix must be a DNS subdomain. Name must be 63 characters or
	// less, begin and end with alphanumerics, with dashes (-), underscores
	// (_), dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// AntiAffinityGroups: The VMware admin cluster anti affinity group
	// configuration.
	AntiAffinityGroups *VmwareAAGConfig `json:"antiAffinityGroups,omitempty"`

	// AutoRepairConfig: The VMware admin cluster auto repair configuration.
	AutoRepairConfig *VmwareAutoRepairConfig `json:"autoRepairConfig,omitempty"`

	// BootstrapClusterMembership: The bootstrap cluster this VMware admin
	// cluster belongs to.
	BootstrapClusterMembership string `json:"bootstrapClusterMembership,omitempty"`

	// ControlPlaneNode: The VMware admin cluster control plane node
	// configuration.
	ControlPlaneNode *VmwareAdminControlPlaneNodeConfig `json:"controlPlaneNode,omitempty"`

	// CreateTime: Output only. The time at which VMware admin cluster was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: A human readable description of this VMware admin
	// cluster.
	Description string `json:"description,omitempty"`

	// Endpoint: Output only. The DNS name of VMware admin cluster's API
	// server.
	Endpoint string `json:"endpoint,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Allows clients
	// to perform consistent read-modify-writes through optimistic
	// concurrency control.
	Etag string `json:"etag,omitempty"`

	// Fleet: Output only. Fleet configuration for the cluster.
	Fleet *Fleet `json:"fleet,omitempty"`

	// ImageType: The OS image type for the VMware admin cluster.
	ImageType string `json:"imageType,omitempty"`

	// LoadBalancer: The VMware admin cluster load balancer configuration.
	LoadBalancer *VmwareAdminLoadBalancerConfig `json:"loadBalancer,omitempty"`

	// LocalName: Output only. The object name of the VMware
	// OnPremAdminCluster custom resource. This field is used to support
	// conflicting names when enrolling existing clusters to the API. When
	// used as a part of cluster enrollment, this field will differ from the
	// ID in the resource name. For new clusters, this field will match the
	// user provided cluster name and be visible in the last component of
	// the resource name. It is not modifiable. All users should use this
	// name to access their cluster using gkectl or kubectl and should
	// expect to see the local name when viewing admin cluster controller
	// logs.
	LocalName string `json:"localName,omitempty"`

	// Name: Immutable. The VMware admin cluster resource name.
	Name string `json:"name,omitempty"`

	// NetworkConfig: The VMware admin cluster network configuration.
	NetworkConfig *VmwareAdminNetworkConfig `json:"networkConfig,omitempty"`

	// OnPremVersion: The Anthos clusters on the VMware version for the
	// admin cluster.
	OnPremVersion string `json:"onPremVersion,omitempty"`

	// PlatformConfig: The VMware platform configuration.
	PlatformConfig *VmwarePlatformConfig `json:"platformConfig,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the VMware admin cluster.
	Reconciling bool `json:"reconciling,omitempty"`

	// State: Output only. The current state of VMware admin cluster.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the cluster is
	// being created.
	//   "RUNNING" - The RUNNING state indicates the cluster has been
	// created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the cluster is
	// being updated. It remains available, but potentially with degraded
	// performance.
	//   "STOPPING" - The STOPPING state indicates the cluster is being
	// deleted.
	//   "ERROR" - The ERROR state indicates the cluster is in a broken
	// unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the cluster requires user
	// action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. ResourceStatus representing detailed cluster
	// state.
	Status *ResourceStatus `json:"status,omitempty"`

	// Uid: Output only. The unique identifier of the VMware admin cluster.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time at which VMware admin cluster was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// Vcenter: The VMware admin cluster VCenter configuration.
	Vcenter *VmwareAdminVCenterConfig `json:"vcenter,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AddonNode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonNode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminCluster) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminCluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminControlPlaneNodeConfig: VmwareAdminControlPlaneNodeConfig
// contains control plane node configuration for VMware admin cluster.
type VmwareAdminControlPlaneNodeConfig struct {
	// Cpus: The number of vCPUs for the control-plane node of the admin
	// cluster.
	Cpus int64 `json:"cpus,omitempty,string"`

	// Memory: The number of mebibytes of memory for the control-plane node
	// of the admin cluster.
	Memory int64 `json:"memory,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Cpus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cpus") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminControlPlaneNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminControlPlaneNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminF5BigIpConfig: VmwareAdminF5BigIpConfig represents
// configuration parameters for an F5 BIG-IP load balancer.
type VmwareAdminF5BigIpConfig struct {
	// Address: The load balancer's IP address.
	Address string `json:"address,omitempty"`

	// Partition: The preexisting partition to be used by the load balancer.
	// This partition is usually created for the admin cluster for example:
	// 'my-f5-admin-partition'.
	Partition string `json:"partition,omitempty"`

	// SnatPool: The pool name. Only necessary, if using SNAT.
	SnatPool string `json:"snatPool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminF5BigIpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminF5BigIpConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminLoadBalancerConfig: VmwareAdminLoadBalancerConfig contains
// load balancer configuration for VMware admin cluster.
type VmwareAdminLoadBalancerConfig struct {
	// F5Config: Configuration for F5 Big IP typed load balancers.
	F5Config *VmwareAdminF5BigIpConfig `json:"f5Config,omitempty"`

	// ManualLbConfig: Manually configured load balancers.
	ManualLbConfig *VmwareAdminManualLbConfig `json:"manualLbConfig,omitempty"`

	// MetalLbConfig: MetalLB load balancers.
	MetalLbConfig *VmwareAdminMetalLbConfig `json:"metalLbConfig,omitempty"`

	// VipConfig: The VIPs used by the load balancer.
	VipConfig *VmwareAdminVipConfig `json:"vipConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "F5Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "F5Config") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminLoadBalancerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminLoadBalancerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type VmwareAdminManualLbConfig struct {
	// AddonsNodePort: NodePort for add-ons server in the admin cluster.
	AddonsNodePort int64 `json:"addonsNodePort,omitempty"`

	// ControlPlaneNodePort: NodePort for control plane service. The
	// Kubernetes API server in the admin cluster is implemented as a
	// Service of type NodePort (ex. 30968).
	ControlPlaneNodePort int64 `json:"controlPlaneNodePort,omitempty"`

	// IngressHttpNodePort: NodePort for ingress service's http. The ingress
	// service in the admin cluster is implemented as a Service of type
	// NodePort (ex. 32527).
	IngressHttpNodePort int64 `json:"ingressHttpNodePort,omitempty"`

	// IngressHttpsNodePort: NodePort for ingress service's https. The
	// ingress service in the admin cluster is implemented as a Service of
	// type NodePort (ex. 30139).
	IngressHttpsNodePort int64 `json:"ingressHttpsNodePort,omitempty"`

	// KonnectivityServerNodePort: NodePort for konnectivity server service
	// running as a sidecar in each kube-apiserver pod (ex. 30564).
	KonnectivityServerNodePort int64 `json:"konnectivityServerNodePort,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddonsNodePort") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonsNodePort") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminManualLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminManualLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminMetalLbConfig: VmwareAdminMetalLbConfig represents
// configuration parameters for a MetalLB load balancer. For admin
// clusters, currently no configurations is needed.
type VmwareAdminMetalLbConfig struct {
}

// VmwareAdminNetworkConfig: VmwareAdminNetworkConfig contains network
// configuration for VMware admin cluster.
type VmwareAdminNetworkConfig struct {
	// DhcpIpConfig: Configuration settings for a DHCP IP configuration.
	DhcpIpConfig *VmwareDhcpIpConfig `json:"dhcpIpConfig,omitempty"`

	// HostConfig: Represents common network settings irrespective of the
	// host's IP address.
	HostConfig *VmwareHostConfig `json:"hostConfig,omitempty"`

	// PodAddressCidrBlocks: Required. All pods in the cluster are assigned
	// an RFC1918 IPv4 address from these ranges. Only a single range is
	// supported. This field cannot be changed after creation.
	PodAddressCidrBlocks []string `json:"podAddressCidrBlocks,omitempty"`

	// ServiceAddressCidrBlocks: Required. All services in the cluster are
	// assigned an RFC1918 IPv4 address from these ranges. Only a single
	// range is supported. This field cannot be changed after creation.
	ServiceAddressCidrBlocks []string `json:"serviceAddressCidrBlocks,omitempty"`

	// StaticIpConfig: Configuration settings for a static IP configuration.
	StaticIpConfig *VmwareStaticIpConfig `json:"staticIpConfig,omitempty"`

	// VcenterNetwork: vcenter_network specifies vCenter network name.
	VcenterNetwork string `json:"vcenterNetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DhcpIpConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DhcpIpConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminNetworkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminVCenterConfig: VmwareAdminVCenterConfig contains VCenter
// configuration for VMware admin cluster.
type VmwareAdminVCenterConfig struct {
	// Address: The vCenter IP address.
	Address string `json:"address,omitempty"`

	// CaCertData: Contains the vCenter CA certificate public key for SSL
	// verification.
	CaCertData string `json:"caCertData,omitempty"`

	// Cluster: The name of the vCenter cluster for the admin cluster.
	Cluster string `json:"cluster,omitempty"`

	// DataDisk: The name of the virtual machine disk (VMDK) for the admin
	// cluster.
	DataDisk string `json:"dataDisk,omitempty"`

	// Datacenter: The name of the vCenter datacenter for the admin cluster.
	Datacenter string `json:"datacenter,omitempty"`

	// Datastore: The name of the vCenter datastore for the admin cluster.
	Datastore string `json:"datastore,omitempty"`

	// Folder: The name of the vCenter folder for the admin cluster.
	Folder string `json:"folder,omitempty"`

	// ResourcePool: The name of the vCenter resource pool for the admin
	// cluster.
	ResourcePool string `json:"resourcePool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminVCenterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminVCenterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAdminVipConfig: VmwareAdminVipConfig for VMware load balancer
// configurations.
type VmwareAdminVipConfig struct {
	// AddonsVip: The VIP to configure the load balancer for add-ons.
	AddonsVip string `json:"addonsVip,omitempty"`

	// ControlPlaneVip: The VIP which you previously set aside for the
	// Kubernetes API of the admin cluster.
	ControlPlaneVip string `json:"controlPlaneVip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddonsVip") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonsVip") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAdminVipConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAdminVipConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAutoRepairConfig: Specifies config to enable/disable auto
// repair. The cluster-health-controller is deployed only if Enabled is
// true.
type VmwareAutoRepairConfig struct {
	// Enabled: Whether auto repair is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAutoRepairConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAutoRepairConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareAutoResizeConfig: Represents auto resizing configurations for
// the VMware user cluster.
type VmwareAutoResizeConfig struct {
	// Enabled: Whether to enable controle plane node auto resizing.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareAutoResizeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareAutoResizeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareBundleConfig: VmwareBundleConfig represents configuration for
// the bundle.
type VmwareBundleConfig struct {
	// Status: Output only. Resource status for the bundle.
	Status *ResourceStatus `json:"status,omitempty"`

	// Version: The version of the bundle.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareBundleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareBundleConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareCluster: Resource that represents a VMware user cluster. ##
type VmwareCluster struct {
	// AdminClusterMembership: Required. The admin cluster this VMware user
	// cluster belongs to. This is the full resource name of the admin
	// cluster's fleet membership. In the future, references to other
	// resource types might be allowed if admin clusters are modeled as
	// their own resources.
	AdminClusterMembership string `json:"adminClusterMembership,omitempty"`

	// AdminClusterName: Output only. The resource name of the VMware admin
	// cluster hosting this user cluster.
	AdminClusterName string `json:"adminClusterName,omitempty"`

	// Annotations: Annotations on the VMware user cluster. This field has
	// the same restrictions as Kubernetes annotations. The total size of
	// all keys and values combined is limited to 256k. Key can have 2
	// segments: prefix (optional) and name (required), separated by a slash
	// (/). Prefix must be a DNS subdomain. Name must be 63 characters or
	// less, begin and end with alphanumerics, with dashes (-), underscores
	// (_), dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// AntiAffinityGroups: AAGConfig specifies whether to spread VMware user
	// cluster nodes across at least three physical hosts in the datacenter.
	AntiAffinityGroups *VmwareAAGConfig `json:"antiAffinityGroups,omitempty"`

	// Authorization: RBAC policy that will be applied and managed by the
	// Anthos On-Prem API.
	Authorization *Authorization `json:"authorization,omitempty"`

	// AutoRepairConfig: Configuration for auto repairing.
	AutoRepairConfig *VmwareAutoRepairConfig `json:"autoRepairConfig,omitempty"`

	// ControlPlaneNode: VMware user cluster control plane nodes must have
	// either 1 or 3 replicas.
	ControlPlaneNode *VmwareControlPlaneNodeConfig `json:"controlPlaneNode,omitempty"`

	// CreateTime: Output only. The time at which VMware user cluster was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DataplaneV2: VmwareDataplaneV2Config specifies configuration for
	// Dataplane V2.
	DataplaneV2 *VmwareDataplaneV2Config `json:"dataplaneV2,omitempty"`

	// DeleteTime: Output only. The time at which VMware user cluster was
	// deleted.
	DeleteTime string `json:"deleteTime,omitempty"`

	// Description: A human readable description of this VMware user
	// cluster.
	Description string `json:"description,omitempty"`

	// EnableControlPlaneV2: Enable control plane V2. Default to false.
	EnableControlPlaneV2 bool `json:"enableControlPlaneV2,omitempty"`

	// Endpoint: Output only. The DNS name of VMware user cluster's API
	// server.
	Endpoint string `json:"endpoint,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Allows clients
	// to perform consistent read-modify-writes through optimistic
	// concurrency control.
	Etag string `json:"etag,omitempty"`

	// Fleet: Output only. Fleet configuration for the cluster.
	Fleet *Fleet `json:"fleet,omitempty"`

	// LoadBalancer: Load balancer configuration.
	LoadBalancer *VmwareLoadBalancerConfig `json:"loadBalancer,omitempty"`

	// LocalName: Output only. The object name of the VMware
	// OnPremUserCluster custom resource on the associated admin cluster.
	// This field is used to support conflicting names when enrolling
	// existing clusters to the API. When used as a part of cluster
	// enrollment, this field will differ from the ID in the resource name.
	// For new clusters, this field will match the user provided cluster
	// name and be visible in the last component of the resource name. It is
	// not modifiable. All users should use this name to access their
	// cluster using gkectl or kubectl and should expect to see the local
	// name when viewing admin cluster controller logs.
	LocalName string `json:"localName,omitempty"`

	// Name: Immutable. The VMware user cluster resource name.
	Name string `json:"name,omitempty"`

	// NetworkConfig: The VMware user cluster network configuration.
	NetworkConfig *VmwareNetworkConfig `json:"networkConfig,omitempty"`

	// OnPremVersion: Required. The Anthos clusters on the VMware version
	// for your user cluster.
	OnPremVersion string `json:"onPremVersion,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the VMware user cluster.
	Reconciling bool `json:"reconciling,omitempty"`

	// State: Output only. The current state of VMware user cluster.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the cluster is
	// being created.
	//   "RUNNING" - The RUNNING state indicates the cluster has been
	// created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the cluster is
	// being updated. It remains available, but potentially with degraded
	// performance.
	//   "STOPPING" - The STOPPING state indicates the cluster is being
	// deleted.
	//   "ERROR" - The ERROR state indicates the cluster is in a broken
	// unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the cluster requires user
	// action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. ResourceStatus representing detailed cluster
	// state.
	Status *ResourceStatus `json:"status,omitempty"`

	// Storage: Storage configuration.
	Storage *VmwareStorageConfig `json:"storage,omitempty"`

	// Uid: Output only. The unique identifier of the VMware user cluster.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time at which VMware user cluster was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValidationCheck: Output only. ValidationCheck represents the result
	// of the preflight check job.
	ValidationCheck *ValidationCheck `json:"validationCheck,omitempty"`

	// Vcenter: Output only. VmwareVCenterConfig specifies vCenter config
	// for the user cluster. Inherited from the admin cluster.
	Vcenter *VmwareVCenterConfig `json:"vcenter,omitempty"`

	// VmTrackingEnabled: Enable VM tracking.
	VmTrackingEnabled bool `json:"vmTrackingEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdminClusterMembership") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminClusterMembership")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareCluster) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareCluster
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareControlPlaneNodeConfig: Specifies control plane node config for
// the VMware user cluster.
type VmwareControlPlaneNodeConfig struct {
	// AutoResizeConfig: AutoResizeConfig provides auto resizing
	// configurations.
	AutoResizeConfig *VmwareAutoResizeConfig `json:"autoResizeConfig,omitempty"`

	// Cpus: The number of CPUs for each admin cluster node that serve as
	// control planes for this VMware user cluster. (default: 4 CPUs)
	Cpus int64 `json:"cpus,omitempty,string"`

	// Memory: The megabytes of memory for each admin cluster node that
	// serves as a control plane for this VMware user cluster (default: 8192
	// MB memory).
	Memory int64 `json:"memory,omitempty,string"`

	// Replicas: The number of control plane nodes for this VMware user
	// cluster. (default: 1 replica).
	Replicas int64 `json:"replicas,omitempty,string"`

	// VsphereConfig: Output only. Vsphere-specific config.
	VsphereConfig *VmwareControlPlaneVsphereConfig `json:"vsphereConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoResizeConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoResizeConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareControlPlaneNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareControlPlaneNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareControlPlaneV2Config: Specifies control plane V2 config.
type VmwareControlPlaneV2Config struct {
	// ControlPlaneIpBlock: Static IP addresses for the control plane nodes.
	ControlPlaneIpBlock *VmwareIpBlock `json:"controlPlaneIpBlock,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ControlPlaneIpBlock")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneIpBlock") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareControlPlaneV2Config) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareControlPlaneV2Config
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareControlPlaneVsphereConfig: Specifies control plane node config.
type VmwareControlPlaneVsphereConfig struct {
	// Datastore: The Vsphere datastore used by the control plane Node.
	Datastore string `json:"datastore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Datastore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Datastore") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareControlPlaneVsphereConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareControlPlaneVsphereConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareDataplaneV2Config: Contains configurations for Dataplane V2,
// which is optimized dataplane for Kubernetes networking. For more
// information, see:
// https://cloud.google.com/kubernetes-engine/docs/concepts/dataplane-v2
type VmwareDataplaneV2Config struct {
	// AdvancedNetworking: Enable advanced networking which requires
	// dataplane_v2_enabled to be set true.
	AdvancedNetworking bool `json:"advancedNetworking,omitempty"`

	// DataplaneV2Enabled: Enables Dataplane V2.
	DataplaneV2Enabled bool `json:"dataplaneV2Enabled,omitempty"`

	// WindowsDataplaneV2Enabled: Enable Dataplane V2 for clusters with
	// Windows nodes.
	WindowsDataplaneV2Enabled bool `json:"windowsDataplaneV2Enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdvancedNetworking")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedNetworking") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareDataplaneV2Config) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareDataplaneV2Config
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareDhcpIpConfig: Represents the network configuration required for
// the VMware user clusters with DHCP IP configurations.
type VmwareDhcpIpConfig struct {
	// Enabled: enabled is a flag to mark if DHCP IP allocation is used for
	// VMware user clusters.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareDhcpIpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareDhcpIpConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareF5BigIpConfig: Represents configuration parameters for an F5
// BIG-IP load balancer.
type VmwareF5BigIpConfig struct {
	// Address: The load balancer's IP address.
	Address string `json:"address,omitempty"`

	// Partition: The preexisting partition to be used by the load balancer.
	// This partition is usually created for the admin cluster for example:
	// 'my-f5-admin-partition'.
	Partition string `json:"partition,omitempty"`

	// SnatPool: The pool name. Only necessary, if using SNAT.
	SnatPool string `json:"snatPool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareF5BigIpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareF5BigIpConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareHostConfig: Represents the common parameters for all the hosts
// irrespective of their IP address.
type VmwareHostConfig struct {
	// DnsSearchDomains: DNS search domains.
	DnsSearchDomains []string `json:"dnsSearchDomains,omitempty"`

	// DnsServers: DNS servers.
	DnsServers []string `json:"dnsServers,omitempty"`

	// NtpServers: NTP servers.
	NtpServers []string `json:"ntpServers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DnsSearchDomains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DnsSearchDomains") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareHostConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareHostConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareHostIp: Represents VMware user cluster node's network
// configuration.
type VmwareHostIp struct {
	// Hostname: Hostname of the machine. VM's name will be used if this
	// field is empty.
	Hostname string `json:"hostname,omitempty"`

	// Ip: IP could be an IP address (like 1.2.3.4) or a CIDR (like
	// 1.2.3.0/24).
	Ip string `json:"ip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hostname") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hostname") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareHostIp) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareHostIp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareIpBlock: Represents a collection of IP addresses to assign to
// nodes.
type VmwareIpBlock struct {
	// Gateway: The network gateway used by the VMware user cluster.
	Gateway string `json:"gateway,omitempty"`

	// Ips: The node's network configurations used by the VMware user
	// cluster.
	Ips []*VmwareHostIp `json:"ips,omitempty"`

	// Netmask: The netmask used by the VMware user cluster.
	Netmask string `json:"netmask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Gateway") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Gateway") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareIpBlock) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareIpBlock
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareLoadBalancerConfig: Specifies the locad balancer config for the
// VMware user cluster.
type VmwareLoadBalancerConfig struct {
	// F5Config: Configuration for F5 Big IP typed load balancers.
	F5Config *VmwareF5BigIpConfig `json:"f5Config,omitempty"`

	// ManualLbConfig: Manually configured load balancers.
	ManualLbConfig *VmwareManualLbConfig `json:"manualLbConfig,omitempty"`

	// MetalLbConfig: Configuration for MetalLB typed load balancers.
	MetalLbConfig *VmwareMetalLbConfig `json:"metalLbConfig,omitempty"`

	// VipConfig: The VIPs used by the load balancer.
	VipConfig *VmwareVipConfig `json:"vipConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "F5Config") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "F5Config") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareLoadBalancerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareLoadBalancerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareManualLbConfig: Represents configuration parameters for an
// already existing manual load balancer. Given the nature of manual
// load balancers it is expected that said load balancer will be fully
// managed by users. IMPORTANT: Please note that the Anthos On-Prem API
// will not generate or update ManualLB configurations it can only bind
// a pre-existing configuration to a new VMware user cluster.
type VmwareManualLbConfig struct {
	// ControlPlaneNodePort: NodePort for control plane service. The
	// Kubernetes API server in the admin cluster is implemented as a
	// Service of type NodePort (ex. 30968).
	ControlPlaneNodePort int64 `json:"controlPlaneNodePort,omitempty"`

	// IngressHttpNodePort: NodePort for ingress service's http. The ingress
	// service in the admin cluster is implemented as a Service of type
	// NodePort (ex. 32527).
	IngressHttpNodePort int64 `json:"ingressHttpNodePort,omitempty"`

	// IngressHttpsNodePort: NodePort for ingress service's https. The
	// ingress service in the admin cluster is implemented as a Service of
	// type NodePort (ex. 30139).
	IngressHttpsNodePort int64 `json:"ingressHttpsNodePort,omitempty"`

	// KonnectivityServerNodePort: NodePort for konnectivity server service
	// running as a sidecar in each kube-apiserver pod (ex. 30564).
	KonnectivityServerNodePort int64 `json:"konnectivityServerNodePort,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ControlPlaneNodePort") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneNodePort") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareManualLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareManualLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareMetalLbConfig: Represents configuration parameters for the
// MetalLB load balancer.
type VmwareMetalLbConfig struct {
	// AddressPools: Required. AddressPools is a list of non-overlapping IP
	// pools used by load balancer typed services. All addresses must be
	// routable to load balancer nodes. IngressVIP must be included in the
	// pools.
	AddressPools []*VmwareAddressPool `json:"addressPools,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressPools") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressPools") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareMetalLbConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareMetalLbConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareNetworkConfig: Specifies network config for the VMware user
// cluster.
type VmwareNetworkConfig struct {
	// ControlPlaneV2Config: Configuration for control plane V2 mode.
	ControlPlaneV2Config *VmwareControlPlaneV2Config `json:"controlPlaneV2Config,omitempty"`

	// DhcpIpConfig: Configuration settings for a DHCP IP configuration.
	DhcpIpConfig *VmwareDhcpIpConfig `json:"dhcpIpConfig,omitempty"`

	// HostConfig: Represents common network settings irrespective of the
	// host's IP address.
	HostConfig *VmwareHostConfig `json:"hostConfig,omitempty"`

	// PodAddressCidrBlocks: Required. All pods in the cluster are assigned
	// an RFC1918 IPv4 address from these ranges. Only a single range is
	// supported. This field cannot be changed after creation.
	PodAddressCidrBlocks []string `json:"podAddressCidrBlocks,omitempty"`

	// ServiceAddressCidrBlocks: Required. All services in the cluster are
	// assigned an RFC1918 IPv4 address from these ranges. Only a single
	// range is supported. This field cannot be changed after creation.
	ServiceAddressCidrBlocks []string `json:"serviceAddressCidrBlocks,omitempty"`

	// StaticIpConfig: Configuration settings for a static IP configuration.
	StaticIpConfig *VmwareStaticIpConfig `json:"staticIpConfig,omitempty"`

	// VcenterNetwork: Output only. vcenter_network specifies vCenter
	// network name. Inherited from the admin cluster.
	VcenterNetwork string `json:"vcenterNetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ControlPlaneV2Config") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneV2Config") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareNetworkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareNetworkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareNodeConfig: Parameters that describe the configuration of all
// nodes within a given node pool.
type VmwareNodeConfig struct {
	// BootDiskSizeGb: VMware disk size to be used during creation.
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty,string"`

	// Cpus: The number of CPUs for each node in the node pool.
	Cpus int64 `json:"cpus,omitempty,string"`

	// EnableLoadBalancer: Allow node pool traffic to be load balanced. Only
	// works for clusters with MetalLB load balancers.
	EnableLoadBalancer bool `json:"enableLoadBalancer,omitempty"`

	// Image: The OS image name in vCenter, only valid when using Windows.
	Image string `json:"image,omitempty"`

	// ImageType: Required. The OS image to be used for each node in a node
	// pool. Currently `cos`, `ubuntu`, `ubuntu_containerd` and `windows`
	// are supported.
	ImageType string `json:"imageType,omitempty"`

	// Labels: The map of Kubernetes labels (key/value pairs) to be applied
	// to each node. These will added in addition to any default label(s)
	// that Kubernetes may apply to the node. In case of conflict in label
	// keys, the applied set may differ depending on the Kubernetes version
	// -- it's best to assume the behavior is undefined and conflicts should
	// be avoided. For more information, including usage and the valid
	// values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `json:"labels,omitempty"`

	// MemoryMb: The megabytes of memory for each node in the node pool.
	MemoryMb int64 `json:"memoryMb,omitempty,string"`

	// Replicas: The number of nodes in the node pool.
	Replicas int64 `json:"replicas,omitempty,string"`

	// Taints: The initial taints assigned to nodes of this node pool.
	Taints []*NodeTaint `json:"taints,omitempty"`

	// VsphereConfig: Output only. Specifies the vSphere config for node
	// pool.
	VsphereConfig *VmwareVsphereConfig `json:"vsphereConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BootDiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BootDiskSizeGb") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareNodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareNodePool: Resource VmwareNodePool represents a VMware node
// pool. ##
type VmwareNodePool struct {
	// Annotations: Annotations on the node pool. This field has the same
	// restrictions as Kubernetes annotations. The total size of all keys
	// and values combined is limited to 256k. Key can have 2 segments:
	// prefix (optional) and name (required), separated by a slash (/).
	// Prefix must be a DNS subdomain. Name must be 63 characters or less,
	// begin and end with alphanumerics, with dashes (-), underscores (_),
	// dots (.), and alphanumerics between.
	Annotations map[string]string `json:"annotations,omitempty"`

	// Config: Required. The node configuration of the node pool.
	Config *VmwareNodeConfig `json:"config,omitempty"`

	// CreateTime: Output only. The time at which this node pool was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DeleteTime: Output only. The time at which this node pool was
	// deleted. If the resource is not deleted, this must be empty
	DeleteTime string `json:"deleteTime,omitempty"`

	// DisplayName: The display name for the node pool.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Allows clients
	// to perform consistent read-modify-writes through optimistic
	// concurrency control.
	Etag string `json:"etag,omitempty"`

	// Name: Immutable. The resource name of this node pool.
	Name string `json:"name,omitempty"`

	// NodePoolAutoscaling: Node pool autoscaling config for the node pool.
	NodePoolAutoscaling *VmwareNodePoolAutoscalingConfig `json:"nodePoolAutoscaling,omitempty"`

	// OnPremVersion: Anthos version for the node pool. Defaults to the user
	// cluster version.
	OnPremVersion string `json:"onPremVersion,omitempty"`

	// Reconciling: Output only. If set, there are currently changes in
	// flight to the node pool.
	Reconciling bool `json:"reconciling,omitempty"`

	// State: Output only. The current state of the node pool.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not set.
	//   "PROVISIONING" - The PROVISIONING state indicates the node pool is
	// being created.
	//   "RUNNING" - The RUNNING state indicates the node pool has been
	// created and is fully usable.
	//   "RECONCILING" - The RECONCILING state indicates that the node pool
	// is being updated. It remains available, but potentially with degraded
	// performance.
	//   "STOPPING" - The STOPPING state indicates the cluster is being
	// deleted
	//   "ERROR" - The ERROR state indicates the node pool is in a broken
	// unrecoverable state.
	//   "DEGRADED" - The DEGRADED state indicates the node pool requires
	// user action to restore full functionality.
	State string `json:"state,omitempty"`

	// Status: Output only. ResourceStatus representing the detailed VMware
	// node pool state.
	Status *ResourceStatus `json:"status,omitempty"`

	// Uid: Output only. The unique identifier of the node pool.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time at which this node pool was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareNodePool) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareNodePool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareNodePoolAutoscalingConfig: NodePoolAutoscaling config for the
// NodePool to allow for the kubernetes to scale NodePool.
type VmwareNodePoolAutoscalingConfig struct {
	// MaxReplicas: Maximum number of replicas in the NodePool.
	MaxReplicas int64 `json:"maxReplicas,omitempty"`

	// MinReplicas: Minimum number of replicas in the NodePool.
	MinReplicas int64 `json:"minReplicas,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxReplicas") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxReplicas") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareNodePoolAutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareNodePoolAutoscalingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwarePlatformConfig: VmwarePlatformConfig represents configuration
// for the VMware platform.
type VmwarePlatformConfig struct {
	// Bundles: Output only. The list of bundles installed in the admin
	// cluster.
	Bundles []*VmwareBundleConfig `json:"bundles,omitempty"`

	// PlatformVersion: Output only. The platform version e.g. 1.13.2.
	PlatformVersion string `json:"platformVersion,omitempty"`

	// RequiredPlatformVersion: Input only. The required platform version
	// e.g. 1.13.1. If the current platform version is lower than the target
	// version, the platform version will be updated to the target version.
	// If the target version is not installed in the platform (bundle
	// versions), download the target version bundle.
	RequiredPlatformVersion string `json:"requiredPlatformVersion,omitempty"`

	// Status: Output only. Resource status for the platform.
	Status *ResourceStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bundles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bundles") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwarePlatformConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwarePlatformConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareStaticIpConfig: Represents the network configuration required
// for the VMware user clusters with Static IP configurations.
type VmwareStaticIpConfig struct {
	// IpBlocks: Represents the configuration values for static IP
	// allocation to nodes.
	IpBlocks []*VmwareIpBlock `json:"ipBlocks,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpBlocks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpBlocks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareStaticIpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareStaticIpConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareStorageConfig: Specifies vSphere CSI components deployment
// config in the VMware user cluster.
type VmwareStorageConfig struct {
	// VsphereCsiDisabled: Whether or not to deploy vSphere CSI components
	// in the VMware user cluster. Enabled by default.
	VsphereCsiDisabled bool `json:"vsphereCsiDisabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "VsphereCsiDisabled")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "VsphereCsiDisabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareStorageConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareVCenterConfig: Represents configuration for the VMware VCenter
// for the user cluster.
type VmwareVCenterConfig struct {
	// Address: The vCenter IP address.
	Address string `json:"address,omitempty"`

	// CaCertData: Contains the vCenter CA certificate public key for SSL
	// verification.
	CaCertData string `json:"caCertData,omitempty"`

	// Cluster: The name of the vCenter cluster for the user cluster.
	Cluster string `json:"cluster,omitempty"`

	// Datacenter: The name of the vCenter datacenter for the user cluster.
	Datacenter string `json:"datacenter,omitempty"`

	// Datastore: The name of the vCenter datastore for the user cluster.
	Datastore string `json:"datastore,omitempty"`

	// Folder: The name of the vCenter folder for the user cluster.
	Folder string `json:"folder,omitempty"`

	// ResourcePool: The name of the vCenter resource pool for the user
	// cluster.
	ResourcePool string `json:"resourcePool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareVCenterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareVCenterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareVersionInfo: Contains information about a specific Anthos on
// VMware version.
type VmwareVersionInfo struct {
	// HasDependencies: If set, the cluster dependencies (e.g. the admin
	// cluster, other user clusters managed by the same admin cluster) must
	// be upgraded before this version can be installed or upgraded to.
	HasDependencies bool `json:"hasDependencies,omitempty"`

	// IsInstalled: If set, the version is installed in the admin cluster.
	// Otherwise, the version bundle must be downloaded and installed before
	// a user cluster can be created at or upgraded to this version.
	IsInstalled bool `json:"isInstalled,omitempty"`

	// Version: Version number e.g. 1.13.1-gke.1000.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HasDependencies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasDependencies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareVersionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareVersionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareVipConfig: Specifies the VIP config for the VMware user cluster
// load balancer.
type VmwareVipConfig struct {
	// ControlPlaneVip: The VIP which you previously set aside for the
	// Kubernetes API of this cluster.
	ControlPlaneVip string `json:"controlPlaneVip,omitempty"`

	// IngressVip: The VIP which you previously set aside for ingress
	// traffic into this cluster.
	IngressVip string `json:"ingressVip,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ControlPlaneVip") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ControlPlaneVip") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *VmwareVipConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareVipConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareVsphereConfig: VmwareVsphereConfig represents configuration for
// the VMware VCenter for node pool.
type VmwareVsphereConfig struct {
	// Datastore: The name of the vCenter datastore. Inherited from the user
	// cluster.
	Datastore string `json:"datastore,omitempty"`

	// Tags: Tags to apply to VMs.
	Tags []*VmwareVsphereTag `json:"tags,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Datastore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Datastore") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareVsphereConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareVsphereConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VmwareVsphereTag: VmwareVsphereTag describes a vSphere tag to be
// placed on VMs in the node pool. For more information, see
// https://docs.vmware.com/en/VMware-vSphere/7.0/com.vmware.vsphere.vcenterhost.doc/GUID-E8E854DD-AA97-4E0C-8419-CE84F93C4058.html
type VmwareVsphereTag struct {
	// Category: The Vsphere tag category.
	Category string `json:"category,omitempty"`

	// Tag: The Vsphere tag name.
	Tag string `json:"tag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VmwareVsphereTag) MarshalJSON() ([]byte, error) {
	type NoMethod VmwareVsphereTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "gkeonprem.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.get" call.
// Exactly one of *Location or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Location"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
//
//   - name: The resource that owns the locations collection, if
//     applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down
// results to a preferred subset. The filtering language accepts strings
// like "displayName=tokyo", and is documented in more detail in
// AIP-160 (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// received from the `next_page_token` field in the response. Send that
// page token to receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.list" call.
// Exactly one of *ListLocationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v1/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to narrow down results to a preferred subset. The filtering language accepts strings like `\"displayName=tokyo\"`, and is documented in more detail in [AIP-160](https://google.aip.dev/160).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return. If not set, the service selects a default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token received from the `next_page_token` field in the response. Send that page token to receive the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/locations",
	//   "response": {
	//     "$ref": "ListLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.create":

type ProjectsLocationsBareMetalAdminClustersCreateCall struct {
	s                     *Service
	parent                string
	baremetaladmincluster *BareMetalAdminCluster
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Create: Creates a new bare metal admin cluster in a given project and
// location. The API needs to be combined with creating a bootstrap
// cluster to work. See:
// https://cloud.google.com/anthos/clusters/docs/bare-metal/latest/installing/creating-clusters/create-admin-cluster-api#prepare_bootstrap_environment
//
//   - parent: The parent of the project and location where the cluster is
//     created in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalAdminClustersService) Create(parent string, baremetaladmincluster *BareMetalAdminCluster) *ProjectsLocationsBareMetalAdminClustersCreateCall {
	c := &ProjectsLocationsBareMetalAdminClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.baremetaladmincluster = baremetaladmincluster
	return c
}

// BareMetalAdminClusterId sets the optional parameter
// "bareMetalAdminClusterId": Required. User provided identifier that is
// used as part of the resource name; must conform to RFC-1034 and
// additionally restrict to lower-cased letters. This comes out roughly
// to: /^a-z+[a-z0-9]$/
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) BareMetalAdminClusterId(bareMetalAdminClusterId string) *ProjectsLocationsBareMetalAdminClustersCreateCall {
	c.urlParams_.Set("bareMetalAdminClusterId", bareMetalAdminClusterId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalAdminClustersCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetaladmincluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalAdminClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new bare metal admin cluster in a given project and location. The API needs to be combined with creating a bootstrap cluster to work. See: https://cloud.google.com/anthos/clusters/docs/bare-metal/latest/installing/creating-clusters/create-admin-cluster-api#prepare_bootstrap_environment",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "bareMetalAdminClusterId": {
	//       "description": "Required. User provided identifier that is used as part of the resource name; must conform to RFC-1034 and additionally restrict to lower-cased letters. This comes out roughly to: /^a-z+[a-z0-9]$/",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is created in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalAdminClusters",
	//   "request": {
	//     "$ref": "BareMetalAdminCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.enroll":

type ProjectsLocationsBareMetalAdminClustersEnrollCall struct {
	s                                  *Service
	parent                             string
	enrollbaremetaladminclusterrequest *EnrollBareMetalAdminClusterRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Enroll: Enrolls an existing bare metal admin cluster to the Anthos
// On-Prem API within a given project and location. Through enrollment,
// an existing admin cluster will become Anthos On-Prem API managed. The
// corresponding GCP resources will be created and all future
// modifications to the cluster will be expected to be performed through
// the API.
//
//   - parent: The parent of the project and location where the cluster is
//     enrolled in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalAdminClustersService) Enroll(parent string, enrollbaremetaladminclusterrequest *EnrollBareMetalAdminClusterRequest) *ProjectsLocationsBareMetalAdminClustersEnrollCall {
	c := &ProjectsLocationsBareMetalAdminClustersEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollbaremetaladminclusterrequest = enrollbaremetaladminclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersEnrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollbaremetaladminclusterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalAdminClusters:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls an existing bare metal admin cluster to the Anthos On-Prem API within a given project and location. Through enrollment, an existing admin cluster will become Anthos On-Prem API managed. The corresponding GCP resources will be created and all future modifications to the cluster will be expected to be performed through the API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is enrolled in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalAdminClusters:enroll",
	//   "request": {
	//     "$ref": "EnrollBareMetalAdminClusterRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.get":

type ProjectsLocationsBareMetalAdminClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single bare metal admin cluster.
//
//   - name: Name of the bare metal admin cluster to get. Format:
//     "projects/{project}/locations/{location}/bareMetalAdminClusters/{bar
//     e_metal_admin_cluster}".
func (r *ProjectsLocationsBareMetalAdminClustersService) Get(name string) *ProjectsLocationsBareMetalAdminClustersGetCall {
	c := &ProjectsLocationsBareMetalAdminClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for bare metal admin
// cluster. When `BASIC` is specified, only the cluster resource name
// and membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and membership.
//
//	"FULL" - Includes the complete configuration for bare metal admin
//
// cluster resource. This is the default value for
// GetBareMetalAdminClusterRequest method.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) View(view string) *ProjectsLocationsBareMetalAdminClustersGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalAdminClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.get" call.
// Exactly one of *BareMetalAdminCluster or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *BareMetalAdminCluster.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersGetCall) Do(opts ...googleapi.CallOption) (*BareMetalAdminCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BareMetalAdminCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single bare metal admin cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the bare metal admin cluster to get. Format: \"projects/{project}/locations/{location}/bareMetalAdminClusters/{bare_metal_admin_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal admin cluster. When `BASIC` is specified, only the cluster resource name and membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and membership.",
	//         "Includes the complete configuration for bare metal admin cluster resource. This is the default value for GetBareMetalAdminClusterRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "BareMetalAdminCluster"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.getIamPolicy":

type ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalAdminClustersService) GetIamPolicy(resource string) *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall {
	c := &ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalAdminClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.list":

type ProjectsLocationsBareMetalAdminClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists bare metal admin clusters in a given project and
// location.
//
//   - parent: The parent of the project and location where the clusters
//     are listed in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalAdminClustersService) List(parent string) *ProjectsLocationsBareMetalAdminClustersListCall {
	c := &ProjectsLocationsBareMetalAdminClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, at most
// 50 clusters will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying a page of results the server should return.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for bare metal admin
// clusters. When `BASIC` is specified, only the admin cluster resource
// name and membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete admin cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a admin cluster resource
//
// including admin cluster resource name and membership.
//
//	"FULL" - Includes the complete configuration for bare metal admin
//
// cluster resource. This is the default value for
// ListBareMetalAdminClustersRequest method.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) View(view string) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalAdminClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.list" call.
// Exactly one of *ListBareMetalAdminClustersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListBareMetalAdminClustersResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) Do(opts ...googleapi.CallOption) (*ListBareMetalAdminClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBareMetalAdminClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists bare metal admin clusters in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, at most 50 clusters will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying a page of results the server should return.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the clusters are listed in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal admin clusters. When `BASIC` is specified, only the admin cluster resource name and membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete admin cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a admin cluster resource including admin cluster resource name and membership.",
	//         "Includes the complete configuration for bare metal admin cluster resource. This is the default value for ListBareMetalAdminClustersRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalAdminClusters",
	//   "response": {
	//     "$ref": "ListBareMetalAdminClustersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalAdminClustersListCall) Pages(ctx context.Context, f func(*ListBareMetalAdminClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.patch":

type ProjectsLocationsBareMetalAdminClustersPatchCall struct {
	s                     *Service
	name                  string
	baremetaladmincluster *BareMetalAdminCluster
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Patch: Updates the parameters of a single bare metal admin cluster.
//
// - name: Immutable. The bare metal admin cluster resource name.
func (r *ProjectsLocationsBareMetalAdminClustersService) Patch(name string, baremetaladmincluster *BareMetalAdminCluster) *ProjectsLocationsBareMetalAdminClustersPatchCall {
	c := &ProjectsLocationsBareMetalAdminClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.baremetaladmincluster = baremetaladmincluster
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// BareMetalAdminCluster resource by the update. The fields specified in
// the update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the BareMetalAdminCluster
// message will be updated. Empty fields will be ignored unless a field
// mask is used.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBareMetalAdminClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalAdminClustersPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetaladmincluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single bare metal admin cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The bare metal admin cluster resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the BareMetalAdminCluster resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the BareMetalAdminCluster message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "BareMetalAdminCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.queryVersionConfig":

type ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall struct {
	s          *Service
	parent     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// QueryVersionConfig: Queries the bare metal admin cluster version
// config.
//
//   - parent: The parent of the project and location to query for version
//     config. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalAdminClustersService) QueryVersionConfig(parent string) *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall {
	c := &ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// UpgradeConfigClusterName sets the optional parameter
// "upgradeConfig.clusterName": The admin cluster resource name. This is
// the full resource name of the admin cluster resource. Format:
// "projects/{project}/locations/{location}/bareMetalAdminClusters/{bare_
// metal_admin_cluster}"
func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) UpgradeConfigClusterName(upgradeConfigClusterName string) *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall {
	c.urlParams_.Set("upgradeConfig.clusterName", upgradeConfigClusterName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalAdminClusters:queryVersionConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.queryVersionConfig" call.
// Exactly one of *QueryBareMetalAdminVersionConfigResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *QueryBareMetalAdminVersionConfigResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBareMetalAdminClustersQueryVersionConfigCall) Do(opts ...googleapi.CallOption) (*QueryBareMetalAdminVersionConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryBareMetalAdminVersionConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the bare metal admin cluster version config.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters:queryVersionConfig",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.queryVersionConfig",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location to query for version config. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "upgradeConfig.clusterName": {
	//       "description": "The admin cluster resource name. This is the full resource name of the admin cluster resource. Format: \"projects/{project}/locations/{location}/bareMetalAdminClusters/{bare_metal_admin_cluster}\"",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalAdminClusters:queryVersionConfig",
	//   "response": {
	//     "$ref": "QueryBareMetalAdminVersionConfigResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.setIamPolicy":

type ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalAdminClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall {
	c := &ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalAdminClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.testIamPermissions":

type ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalAdminClustersService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall {
	c := &ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.unenroll":

type ProjectsLocationsBareMetalAdminClustersUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls an existing bare metal admin cluster from the
// Anthos On-Prem API within a given project and location. Unenrollment
// removes the Cloud reference to the cluster without modifying the
// underlying OnPrem Resources. Clusters will continue to run; however,
// they will no longer be accessible through the Anthos On-Prem API or
// its clients.
//
//   - name: Name of the bare metal admin cluster to be unenrolled.
//     Format:
//     "projects/{project}/locations/{location}/bareMetalAdminClusters/{clu
//     ster}".
func (r *ProjectsLocationsBareMetalAdminClustersService) Unenroll(name string) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c := &ProjectsLocationsBareMetalAdminClustersUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal admin cluster is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the bare
// metal admin cluster. If an etag is provided and does not match the
// current etag of the cluster, deletion will be blocked and an ABORTED
// error will be returned.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) Etag(etag string) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// IgnoreErrors sets the optional parameter "ignoreErrors": If set to
// true, the unenrollment of a bare metal admin cluster resource will
// succeed even if errors occur during unenrollment. This parameter can
// be used when you want to unenroll admin cluster resource and the
// on-prem admin cluster is disconnected / unreachable. WARNING: Using
// this parameter when your admin cluster still exists may result in a
// deleted GCP admin cluster but existing resourcelink in on-prem admin
// cluster and membership.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) IgnoreErrors(ignoreErrors bool) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.urlParams_.Set("ignoreErrors", fmt.Sprint(ignoreErrors))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls an existing bare metal admin cluster from the Anthos On-Prem API within a given project and location. Unenrollment removes the Cloud reference to the cluster without modifying the underlying OnPrem Resources. Clusters will continue to run; however, they will no longer be accessible through the Anthos On-Prem API or its clients.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal admin cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the bare metal admin cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "ignoreErrors": {
	//       "description": "If set to true, the unenrollment of a bare metal admin cluster resource will succeed even if errors occur during unenrollment. This parameter can be used when you want to unenroll admin cluster resource and the on-prem admin cluster is disconnected / unreachable. WARNING: Using this parameter when your admin cluster still exists may result in a deleted GCP admin cluster but existing resourcelink in on-prem admin cluster and membership.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. Name of the bare metal admin cluster to be unenrolled. Format: \"projects/{project}/locations/{location}/bareMetalAdminClusters/{cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.operations.get":

type ProjectsLocationsBareMetalAdminClustersOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsBareMetalAdminClustersOperationsService) Get(name string) *ProjectsLocationsBareMetalAdminClustersOperationsGetCall {
	c := &ProjectsLocationsBareMetalAdminClustersOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalAdminClustersOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalAdminClusters.operations.list":

type ProjectsLocationsBareMetalAdminClustersOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsBareMetalAdminClustersOperationsService) List(name string) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c := &ProjectsLocationsBareMetalAdminClustersOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Filter(filter string) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalAdminClustersOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalAdminClusters.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalAdminClusters/{bareMetalAdminClustersId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalAdminClusters.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalAdminClustersOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalClusters.create":

type ProjectsLocationsBareMetalClustersCreateCall struct {
	s                *Service
	parent           string
	baremetalcluster *BareMetalCluster
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates a new bare metal cluster in a given project and
// location.
//
//   - parent: The parent of the project and location where the cluster is
//     created in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalClustersService) Create(parent string, baremetalcluster *BareMetalCluster) *ProjectsLocationsBareMetalClustersCreateCall {
	c := &ProjectsLocationsBareMetalClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.baremetalcluster = baremetalcluster
	return c
}

// BareMetalClusterId sets the optional parameter "bareMetalClusterId":
// Required. User provided identifier that is used as part of the
// resource name; must conform to RFC-1034 and additionally restrict to
// lower-cased letters. This comes out roughly to: /^a-z+[a-z0-9]$/
func (c *ProjectsLocationsBareMetalClustersCreateCall) BareMetalClusterId(bareMetalClusterId string) *ProjectsLocationsBareMetalClustersCreateCall {
	c.urlParams_.Set("bareMetalClusterId", bareMetalClusterId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalClustersCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetalcluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new bare metal cluster in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "bareMetalClusterId": {
	//       "description": "Required. User provided identifier that is used as part of the resource name; must conform to RFC-1034 and additionally restrict to lower-cased letters. This comes out roughly to: /^a-z+[a-z0-9]$/",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is created in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalClusters",
	//   "request": {
	//     "$ref": "BareMetalCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.delete":

type ProjectsLocationsBareMetalClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single bare metal Cluster.
//
//   - name: Name of the bare metal user cluster to be deleted. Format:
//     "projects/{project}/locations/{location}/bareMetalClusters/{bare_met
//     al_cluster}".
func (r *ProjectsLocationsBareMetalClustersService) Delete(name string) *ProjectsLocationsBareMetalClustersDeleteCall {
	c := &ProjectsLocationsBareMetalClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal cluster is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the bare
// metal Cluster. If an etag is provided and does not match the current
// etag of the cluster, deletion will be blocked and an ABORTED error
// will be returned.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Etag(etag string) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any node
// pools from the cluster will also be deleted.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Force(force bool) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// IgnoreErrors sets the optional parameter "ignoreErrors": If set to
// true, the deletion of a bare metal user cluster resource will succeed
// even if errors occur during deletion. This parameter can be used when
// you want to delete GCP's cluster resource and the on-prem admin
// cluster that hosts your user cluster is disconnected / unreachable or
// deleted. WARNING: Using this parameter when your user cluster still
// exists may result in a deleted GCP user cluster but an existing
// on-prem user cluster.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) IgnoreErrors(ignoreErrors bool) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("ignoreErrors", fmt.Sprint(ignoreErrors))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single bare metal Cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the bare metal Cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "force": {
	//       "description": "If set to true, any node pools from the cluster will also be deleted.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "ignoreErrors": {
	//       "description": "If set to true, the deletion of a bare metal user cluster resource will succeed even if errors occur during deletion. This parameter can be used when you want to delete GCP's cluster resource and the on-prem admin cluster that hosts your user cluster is disconnected / unreachable or deleted. WARNING: Using this parameter when your user cluster still exists may result in a deleted GCP user cluster but an existing on-prem user cluster.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. Name of the bare metal user cluster to be deleted. Format: \"projects/{project}/locations/{location}/bareMetalClusters/{bare_metal_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.enroll":

type ProjectsLocationsBareMetalClustersEnrollCall struct {
	s                             *Service
	parent                        string
	enrollbaremetalclusterrequest *EnrollBareMetalClusterRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Enroll: Enrolls an existing bare metal user cluster and its node
// pools to the Anthos On-Prem API within a given project and location.
// Through enrollment, an existing cluster will become Anthos On-Prem
// API managed. The corresponding GCP resources will be created and all
// future modifications to the cluster and/or its node pools will be
// expected to be performed through the API.
//
//   - parent: The parent of the project and location where the cluster is
//     enrolled in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalClustersService) Enroll(parent string, enrollbaremetalclusterrequest *EnrollBareMetalClusterRequest) *ProjectsLocationsBareMetalClustersEnrollCall {
	c := &ProjectsLocationsBareMetalClustersEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollbaremetalclusterrequest = enrollbaremetalclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersEnrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollbaremetalclusterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalClusters:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls an existing bare metal user cluster and its node pools to the Anthos On-Prem API within a given project and location. Through enrollment, an existing cluster will become Anthos On-Prem API managed. The corresponding GCP resources will be created and all future modifications to the cluster and/or its node pools will be expected to be performed through the API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is enrolled in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalClusters:enroll",
	//   "request": {
	//     "$ref": "EnrollBareMetalClusterRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.get":

type ProjectsLocationsBareMetalClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single bare metal Cluster.
//
//   - name: Name of the bare metal user cluster to get. Format:
//     "projects/{project}/locations/{location}/bareMetalClusters/{bare_met
//     al_cluster}".
func (r *ProjectsLocationsBareMetalClustersService) Get(name string) *ProjectsLocationsBareMetalClustersGetCall {
	c := &ProjectsLocationsBareMetalClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for bare metal user
// cluster. When `BASIC` is specified, only the cluster resource name
// and admin cluster membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and admin cluster membership.
//
//	"FULL" - Includes the complete configuration for bare metal cluster
//
// resource. This is the default value for GetBareMetalClusterRequest
// method.
func (c *ProjectsLocationsBareMetalClustersGetCall) View(view string) *ProjectsLocationsBareMetalClustersGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.get" call.
// Exactly one of *BareMetalCluster or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *BareMetalCluster.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersGetCall) Do(opts ...googleapi.CallOption) (*BareMetalCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BareMetalCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single bare metal Cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the bare metal user cluster to get. Format: \"projects/{project}/locations/{location}/bareMetalClusters/{bare_metal_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal user cluster. When `BASIC` is specified, only the cluster resource name and admin cluster membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and admin cluster membership.",
	//         "Includes the complete configuration for bare metal cluster resource. This is the default value for GetBareMetalClusterRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "BareMetalCluster"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.getIamPolicy":

type ProjectsLocationsBareMetalClustersGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersService) GetIamPolicy(resource string) *ProjectsLocationsBareMetalClustersGetIamPolicyCall {
	c := &ProjectsLocationsBareMetalClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBareMetalClustersGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.list":

type ProjectsLocationsBareMetalClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists bare metal clusters in a given project and location.
//
//   - parent: The parent of the project and location where the clusters
//     are listed in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalClustersService) List(parent string) *ProjectsLocationsBareMetalClustersListCall {
	c := &ProjectsLocationsBareMetalClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A resource filtering
// expression following https://google.aip.dev/160. When non-empty, only
// resource's whose attributes field matches the filter are returned.
func (c *ProjectsLocationsBareMetalClustersListCall) Filter(filter string) *ProjectsLocationsBareMetalClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, at most
// 50 clusters will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsLocationsBareMetalClustersListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying a page of results the server should return.
func (c *ProjectsLocationsBareMetalClustersListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for bare metal
// Clusters. When `BASIC` is specified, only the cluster resource name
// and admin cluster membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and admin cluster membership.
//
//	"FULL" - Includes the complete configuration for bare metal cluster
//
// resource. This is the default value for ListBareMetalClustersRequest
// method.
func (c *ProjectsLocationsBareMetalClustersListCall) View(view string) *ProjectsLocationsBareMetalClustersListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.list" call.
// Exactly one of *ListBareMetalClustersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListBareMetalClustersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersListCall) Do(opts ...googleapi.CallOption) (*ListBareMetalClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBareMetalClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists bare metal clusters in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A resource filtering expression following https://google.aip.dev/160. When non-empty, only resource's whose attributes field matches the filter are returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, at most 50 clusters will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying a page of results the server should return.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the clusters are listed in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal Clusters. When `BASIC` is specified, only the cluster resource name and admin cluster membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and admin cluster membership.",
	//         "Includes the complete configuration for bare metal cluster resource. This is the default value for ListBareMetalClustersRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalClusters",
	//   "response": {
	//     "$ref": "ListBareMetalClustersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalClustersListCall) Pages(ctx context.Context, f func(*ListBareMetalClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalClusters.patch":

type ProjectsLocationsBareMetalClustersPatchCall struct {
	s                *Service
	name             string
	baremetalcluster *BareMetalCluster
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Updates the parameters of a single bare metal Cluster.
//
// - name: Immutable. The bare metal user cluster resource name.
func (r *ProjectsLocationsBareMetalClustersService) Patch(name string, baremetalcluster *BareMetalCluster) *ProjectsLocationsBareMetalClustersPatchCall {
	c := &ProjectsLocationsBareMetalClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.baremetalcluster = baremetalcluster
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal cluster is not found, the request will
// create a new bare metal cluster with the provided configuration. The
// user must have both create and update permission to call Update with
// allow_missing set to true.
func (c *ProjectsLocationsBareMetalClustersPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// BareMetalCluster resource by the update. The fields specified in the
// update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the BareMetalCluster
// message will be updated. Empty fields will be ignored unless a field
// mask is used.
func (c *ProjectsLocationsBareMetalClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBareMetalClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalClustersPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetalcluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single bare metal Cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal cluster is not found, the request will create a new bare metal cluster with the provided configuration. The user must have both create and update permission to call Update with allow_missing set to true.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The bare metal user cluster resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the BareMetalCluster resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the BareMetalCluster message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "BareMetalCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.queryVersionConfig":

type ProjectsLocationsBareMetalClustersQueryVersionConfigCall struct {
	s          *Service
	parent     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// QueryVersionConfig: Queries the bare metal user cluster version
// config.
//
//   - parent: The parent of the project and location to query for version
//     config. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsBareMetalClustersService) QueryVersionConfig(parent string) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c := &ProjectsLocationsBareMetalClustersQueryVersionConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CreateConfigAdminClusterMembership sets the optional parameter
// "createConfig.adminClusterMembership": The admin cluster membership.
// This is the full resource name of the admin cluster's fleet
// membership. Format:
// "projects/{project}/locations/{location}/memberships/{membership}"
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) CreateConfigAdminClusterMembership(createConfigAdminClusterMembership string) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c.urlParams_.Set("createConfig.adminClusterMembership", createConfigAdminClusterMembership)
	return c
}

// CreateConfigAdminClusterName sets the optional parameter
// "createConfig.adminClusterName": The admin cluster resource name.
// This is the full resource name of the admin cluster resource. Format:
// "projects/{project}/locations/{location}/bareMetalAdminClusters/{bare_
// metal_admin_cluster}"
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) CreateConfigAdminClusterName(createConfigAdminClusterName string) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c.urlParams_.Set("createConfig.adminClusterName", createConfigAdminClusterName)
	return c
}

// UpgradeConfigClusterName sets the optional parameter
// "upgradeConfig.clusterName": The user cluster resource name. This is
// the full resource name of the user cluster resource. Format:
// "projects/{project}/locations/{location}/bareMetalClusters/{bare_metal
// _cluster}"
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) UpgradeConfigClusterName(upgradeConfigClusterName string) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c.urlParams_.Set("upgradeConfig.clusterName", upgradeConfigClusterName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersQueryVersionConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalClusters:queryVersionConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.queryVersionConfig" call.
// Exactly one of *QueryBareMetalVersionConfigResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *QueryBareMetalVersionConfigResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBareMetalClustersQueryVersionConfigCall) Do(opts ...googleapi.CallOption) (*QueryBareMetalVersionConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryBareMetalVersionConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the bare metal user cluster version config.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters:queryVersionConfig",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.queryVersionConfig",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "createConfig.adminClusterMembership": {
	//       "description": "The admin cluster membership. This is the full resource name of the admin cluster's fleet membership. Format: \"projects/{project}/locations/{location}/memberships/{membership}\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "createConfig.adminClusterName": {
	//       "description": "The admin cluster resource name. This is the full resource name of the admin cluster resource. Format: \"projects/{project}/locations/{location}/bareMetalAdminClusters/{bare_metal_admin_cluster}\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location to query for version config. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "upgradeConfig.clusterName": {
	//       "description": "The user cluster resource name. This is the full resource name of the user cluster resource. Format: \"projects/{project}/locations/{location}/bareMetalClusters/{bare_metal_cluster}\"",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalClusters:queryVersionConfig",
	//   "response": {
	//     "$ref": "QueryBareMetalVersionConfigResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.setIamPolicy":

type ProjectsLocationsBareMetalClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBareMetalClustersSetIamPolicyCall {
	c := &ProjectsLocationsBareMetalClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.testIamPermissions":

type ProjectsLocationsBareMetalClustersTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBareMetalClustersTestIamPermissionsCall {
	c := &ProjectsLocationsBareMetalClustersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.unenroll":

type ProjectsLocationsBareMetalClustersUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls an existing bare metal user cluster and its node
// pools from the Anthos On-Prem API within a given project and
// location. Unenrollment removes the Cloud reference to the cluster
// without modifying the underlying OnPrem Resources. Clusters and node
// pools will continue to run; however, they will no longer be
// accessible through the Anthos On-Prem API or its clients.
//
//   - name: Name of the bare metal user cluster to be unenrolled. Format:
//     "projects/{project}/locations/{location}/bareMetalClusters/{cluster}
//     ".
func (r *ProjectsLocationsBareMetalClustersService) Unenroll(name string) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c := &ProjectsLocationsBareMetalClustersUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal cluster is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the bare
// metal Cluster. If an etag is provided and does not match the current
// etag of the cluster, deletion will be blocked and an ABORTED error
// will be returned.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Etag(etag string) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": This is required if the
// cluster has any associated node pools. When set, any child node pools
// will also be unenrolled.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Force(force bool) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls an existing bare metal user cluster and its node pools from the Anthos On-Prem API within a given project and location. Unenrollment removes the Cloud reference to the cluster without modifying the underlying OnPrem Resources. Clusters and node pools will continue to run; however, they will no longer be accessible through the Anthos On-Prem API or its clients.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the bare metal Cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "force": {
	//       "description": "This is required if the cluster has any associated node pools. When set, any child node pools will also be unenrolled.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. Name of the bare metal user cluster to be unenrolled. Format: \"projects/{project}/locations/{location}/bareMetalClusters/{cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.create":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall struct {
	s                 *Service
	parent            string
	baremetalnodepool *BareMetalNodePool
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a new bare metal node pool in a given project,
// location and Bare Metal cluster.
//
//   - parent: The parent resource where this node pool will be created.
//     projects/{project}/locations/{location}/bareMetalClusters/{cluster}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Create(parent string, baremetalnodepool *BareMetalNodePool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.baremetalnodepool = baremetalnodepool
	return c
}

// BareMetalNodePoolId sets the optional parameter
// "bareMetalNodePoolId": The ID to use for the node pool, which will
// become the final component of the node pool's resource name. This
// value must be up to 63 characters, and valid characters are /a-z-/.
// The value must not be permitted to be a UUID (or UUID-like: anything
// matching /^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$/i).
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) BareMetalNodePoolId(bareMetalNodePoolId string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall {
	c.urlParams_.Set("bareMetalNodePoolId", bareMetalNodePoolId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually create the node pool.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetalnodepool)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalNodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new bare metal node pool in a given project, location and Bare Metal cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "bareMetalNodePoolId": {
	//       "description": "The ID to use for the node pool, which will become the final component of the node pool's resource name. This value must be up to 63 characters, and valid characters are /a-z-/. The value must not be permitted to be a UUID (or UUID-like: anything matching /^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$/i).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource where this node pool will be created. projects/{project}/locations/{location}/bareMetalClusters/{cluster}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually create the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalNodePools",
	//   "request": {
	//     "$ref": "BareMetalNodePool"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.delete":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single bare metal node pool.
//
//   - name: The name of the node pool to delete. Format:
//     projects/{project}/locations/{location}/bareMetalClusters/{cluster}/
//     bareMetalNodePools/{nodepool}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Delete(name string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal node pool is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// BareMetalNodePool. If an etag is provided and does not match the
// current etag of the node pool, deletion will be blocked and an
// ABORTED error will be returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) Etag(etag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// IgnoreErrors sets the optional parameter "ignoreErrors": If set to
// true, the deletion of a bare metal node pool resource will succeed
// even if errors occur during deletion. This parameter can be used when
// you want to delete GCP's node pool resource and you've already
// deleted the on-prem admin cluster that hosted your node pool.
// WARNING: Using this parameter when your user cluster still exists may
// result in a deleted GCP node pool but an existing on-prem node pool.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) IgnoreErrors(ignoreErrors bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.urlParams_.Set("ignoreErrors", fmt.Sprint(ignoreErrors))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually delete the node pool.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single bare metal node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal node pool is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the BareMetalNodePool. If an etag is provided and does not match the current etag of the node pool, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "ignoreErrors": {
	//       "description": "If set to true, the deletion of a bare metal node pool resource will succeed even if errors occur during deletion. This parameter can be used when you want to delete GCP's node pool resource and you've already deleted the on-prem admin cluster that hosted your node pool. WARNING: Using this parameter when your user cluster still exists may result in a deleted GCP node pool but an existing on-prem node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the node pool to delete. Format: projects/{project}/locations/{location}/bareMetalClusters/{cluster}/bareMetalNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually delete the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.enroll":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall struct {
	s                              *Service
	parent                         string
	enrollbaremetalnodepoolrequest *EnrollBareMetalNodePoolRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Enroll: Enrolls an existing bare metal node pool to the Anthos
// On-Prem API within a given project and location. Through enrollment,
// an existing node pool will become Anthos On-Prem API managed. The
// corresponding GCP resources will be created.
//
//   - parent: The parent resource where this node pool will be created.
//     projects/{project}/locations/{location}/bareMetalClusters/{cluster}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Enroll(parent string, enrollbaremetalnodepoolrequest *EnrollBareMetalNodePoolRequest) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollbaremetalnodepoolrequest = enrollbaremetalnodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollbaremetalnodepoolrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalNodePools:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls an existing bare metal node pool to the Anthos On-Prem API within a given project and location. Through enrollment, an existing node pool will become Anthos On-Prem API managed. The corresponding GCP resources will be created.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this node pool will be created. projects/{project}/locations/{location}/bareMetalClusters/{cluster}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalNodePools:enroll",
	//   "request": {
	//     "$ref": "EnrollBareMetalNodePoolRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.get":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single bare metal node pool.
//
//   - name: The name of the node pool to retrieve.
//     projects/{project}/locations/{location}/bareMetalClusters/{cluster}/
//     bareMetalNodePools/{nodepool}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Get(name string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for bare metal node
// pool. When `BASIC` is specified, only the node pool resource name is
// returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the
// same as `FULL', which returns the complete node pool configuration
// details.
//
// Possible values:
//
//	"NODE_POOL_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a node pool resource
//
// including node pool resource name.
//
//	"FULL" - Includes the complete configuration for bare metal node
//
// pool resource. This is the default value for
// GetBareMetalNodePoolRequest method.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) View(view string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.get" call.
// Exactly one of *BareMetalNodePool or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *BareMetalNodePool.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetCall) Do(opts ...googleapi.CallOption) (*BareMetalNodePool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BareMetalNodePool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single bare metal node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the node pool to retrieve. projects/{project}/locations/{location}/bareMetalClusters/{cluster}/bareMetalNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal node pool. When `BASIC` is specified, only the node pool resource name is returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete node pool configuration details.",
	//       "enum": [
	//         "NODE_POOL_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a node pool resource including node pool resource name.",
	//         "Includes the complete configuration for bare metal node pool resource. This is the default value for GetBareMetalNodePoolRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "BareMetalNodePool"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.getIamPolicy":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) GetIamPolicy(resource string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.list":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists bare metal node pools in a given project, location and
// bare metal cluster.
//
//   - parent: The parent, which owns this collection of node pools.
//     Format:
//     projects/{project}/locations/{location}/bareMetalClusters/{bareMetal
//     Cluster}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) List(parent string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of node pools to return. The service may return fewer than this
// value. If unspecified, at most 50 node pools will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListBareMetalNodePools` call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to `ListBareMetalNodePools` must match the call
// that provided the page token.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for bare metal node
// pools. When `BASIC` is specified, only the node pool resource name is
// returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the
// same as `FULL', which returns the complete node pool configuration
// details.
//
// Possible values:
//
//	"NODE_POOL_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a node pool resource
//
// including node pool resource name.
//
//	"FULL" - Includes the complete configuration for bare metal node
//
// pool resource. This is the default value for
// ListBareMetalNodePoolsRequest method.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) View(view string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/bareMetalNodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.list" call.
// Exactly one of *ListBareMetalNodePoolsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListBareMetalNodePoolsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) Do(opts ...googleapi.CallOption) (*ListBareMetalNodePoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBareMetalNodePoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists bare metal node pools in a given project, location and bare metal cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of node pools to return. The service may return fewer than this value. If unspecified, at most 50 node pools will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListBareMetalNodePools` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBareMetalNodePools` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, which owns this collection of node pools. Format: projects/{project}/locations/{location}/bareMetalClusters/{bareMetalCluster}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for bare metal node pools. When `BASIC` is specified, only the node pool resource name is returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete node pool configuration details.",
	//       "enum": [
	//         "NODE_POOL_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a node pool resource including node pool resource name.",
	//         "Includes the complete configuration for bare metal node pool resource. This is the default value for ListBareMetalNodePoolsRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/bareMetalNodePools",
	//   "response": {
	//     "$ref": "ListBareMetalNodePoolsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsListCall) Pages(ctx context.Context, f func(*ListBareMetalNodePoolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.patch":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall struct {
	s                 *Service
	name              string
	baremetalnodepool *BareMetalNodePool
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates the parameters of a single bare metal node pool.
//
// - name: Immutable. The bare metal node pool resource name.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Patch(name string, baremetalnodepool *BareMetalNodePool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.baremetalnodepool = baremetalnodepool
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal node pool is not found, the request will
// create a new bare metal node pool with the provided configuration.
// The user must have both create and update permission to call Update
// with allow_missing set to true.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// BareMetalNodePool resource by the update. The fields specified in the
// update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the BareMetalNodePool
// message will be updated. Empty fields will be ignored unless a field
// mask is used.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.baremetalnodepool)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single bare metal node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal node pool is not found, the request will create a new bare metal node pool with the provided configuration. The user must have both create and update permission to call Update with allow_missing set to true.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The bare metal node pool resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the BareMetalNodePool resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the BareMetalNodePool message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "BareMetalNodePool"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.setIamPolicy":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.testIamPermissions":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.unenroll":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls a bare metal node pool from Anthos On-Prem API.
//
//   - name: The name of the node pool to unenroll. Format:
//     projects/{project}/locations/{location}/bareMetalClusters/{cluster}/
//     bareMetalNodePools/{nodepool}.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsService) Unenroll(name string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the bare metal node pool is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the bare
// metal node pool. If an etag is provided and does not match the
// current etag of node pool, deletion will be blocked and an ABORTED
// error will be returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) Etag(etag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually unenroll the node pool.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls a bare metal node pool from Anthos On-Prem API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the bare metal node pool is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the bare metal node pool. If an etag is provided and does not match the current etag of node pool, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The name of the node pool to unenroll. Format: projects/{project}/locations/{location}/bareMetalClusters/{cluster}/bareMetalNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually unenroll the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.get":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService) Get(name string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.list":

type ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsService) List(name string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c := &ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Filter(filter string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/bareMetalNodePools/{bareMetalNodePoolsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.bareMetalNodePools.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/bareMetalNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.bareMetalClusters.operations.get":

type ProjectsLocationsBareMetalClustersOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsBareMetalClustersOperationsService) Get(name string) *ProjectsLocationsBareMetalClustersOperationsGetCall {
	c := &ProjectsLocationsBareMetalClustersOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.bareMetalClusters.operations.list":

type ProjectsLocationsBareMetalClustersOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsBareMetalClustersOperationsService) List(name string) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c := &ProjectsLocationsBareMetalClustersOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Filter(filter string) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) PageToken(pageToken string) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Context(ctx context.Context) *ProjectsLocationsBareMetalClustersOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBareMetalClustersOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.bareMetalClusters.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/bareMetalClusters/{bareMetalClustersId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.bareMetalClusters.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/bareMetalClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBareMetalClustersOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.operations.cancel":

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation.
// The server makes a best effort to cancel the operation, but success
// is not guaranteed. If the server doesn't support this method, it
// returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use
// Operations.GetOperation or other methods to check whether the
// cancellation succeeded or whether the operation completed despite
// cancellation. On successful cancellation, the operation is not
// deleted; instead, it becomes an operation with an Operation.error
// value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.operations.cancel" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.operations.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be cancelled.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:cancel",
	//   "request": {
	//     "$ref": "CancelOperationRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.operations.delete":

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that
// the client is no longer interested in the operation result. It does
// not cancel the operation. If the server doesn't support this method,
// it returns `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.operations.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.operations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource to be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.enroll":

type ProjectsLocationsVmwareAdminClustersEnrollCall struct {
	s                               *Service
	parent                          string
	enrollvmwareadminclusterrequest *EnrollVmwareAdminClusterRequest
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Enroll: Enrolls an existing VMware admin cluster to the Anthos
// On-Prem API within a given project and location. Through enrollment,
// an existing admin cluster will become Anthos On-Prem API managed. The
// corresponding GCP resources will be created and all future
// modifications to the cluster will be expected to be performed through
// the API.
//
//   - parent: The parent of the project and location where the cluster is
//     enrolled in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareAdminClustersService) Enroll(parent string, enrollvmwareadminclusterrequest *EnrollVmwareAdminClusterRequest) *ProjectsLocationsVmwareAdminClustersEnrollCall {
	c := &ProjectsLocationsVmwareAdminClustersEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollvmwareadminclusterrequest = enrollvmwareadminclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersEnrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollvmwareadminclusterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareAdminClusters:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls an existing VMware admin cluster to the Anthos On-Prem API within a given project and location. Through enrollment, an existing admin cluster will become Anthos On-Prem API managed. The corresponding GCP resources will be created and all future modifications to the cluster will be expected to be performed through the API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is enrolled in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareAdminClusters:enroll",
	//   "request": {
	//     "$ref": "EnrollVmwareAdminClusterRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.get":

type ProjectsLocationsVmwareAdminClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single VMware admin cluster.
//
//   - name: Name of the VMware admin cluster to be returned. Format:
//     "projects/{project}/locations/{location}/vmwareAdminClusters/{vmware
//     _admin_cluster}".
func (r *ProjectsLocationsVmwareAdminClustersService) Get(name string) *ProjectsLocationsVmwareAdminClustersGetCall {
	c := &ProjectsLocationsVmwareAdminClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for VMware admin
// cluster. When `BASIC` is specified, only the cluster resource name
// and membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and membership.
//
//	"FULL" - Includes the complete configuration for VMware admin
//
// cluster resource. This is the default value for
// GetVmwareAdminClusterRequest method.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) View(view string) *ProjectsLocationsVmwareAdminClustersGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareAdminClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.get" call.
// Exactly one of *VmwareAdminCluster or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *VmwareAdminCluster.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersGetCall) Do(opts ...googleapi.CallOption) (*VmwareAdminCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VmwareAdminCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single VMware admin cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the VMware admin cluster to be returned. Format: \"projects/{project}/locations/{location}/vmwareAdminClusters/{vmware_admin_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware admin cluster. When `BASIC` is specified, only the cluster resource name and membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and membership.",
	//         "Includes the complete configuration for VMware admin cluster resource. This is the default value for GetVmwareAdminClusterRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "VmwareAdminCluster"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.getIamPolicy":

type ProjectsLocationsVmwareAdminClustersGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareAdminClustersService) GetIamPolicy(resource string) *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall {
	c := &ProjectsLocationsVmwareAdminClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareAdminClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.list":

type ProjectsLocationsVmwareAdminClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists VMware admin clusters in a given project and location.
//
//   - parent: The parent of the project and location where the clusters
//     are listed in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareAdminClustersService) List(parent string) *ProjectsLocationsVmwareAdminClustersListCall {
	c := &ProjectsLocationsVmwareAdminClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, at most
// 50 clusters will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsLocationsVmwareAdminClustersListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareAdminClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying a page of results the server should return.
func (c *ProjectsLocationsVmwareAdminClustersListCall) PageToken(pageToken string) *ProjectsLocationsVmwareAdminClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for VMware admin
// clusters. When `BASIC` is specified, only the admin cluster resource
// name and membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete admin cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a admin cluster resource
//
// including admin cluster resource name and membership.
//
//	"FULL" - Includes the complete configuration for bare metal admin
//
// cluster resource. This is the default value for
// ListVmwareAdminClustersRequest method.
func (c *ProjectsLocationsVmwareAdminClustersListCall) View(view string) *ProjectsLocationsVmwareAdminClustersListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareAdminClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareAdminClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersListCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareAdminClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.list" call.
// Exactly one of *ListVmwareAdminClustersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListVmwareAdminClustersResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersListCall) Do(opts ...googleapi.CallOption) (*ListVmwareAdminClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVmwareAdminClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists VMware admin clusters in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, at most 50 clusters will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying a page of results the server should return.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the clusters are listed in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware admin clusters. When `BASIC` is specified, only the admin cluster resource name and membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete admin cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a admin cluster resource including admin cluster resource name and membership.",
	//         "Includes the complete configuration for bare metal admin cluster resource. This is the default value for ListVmwareAdminClustersRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareAdminClusters",
	//   "response": {
	//     "$ref": "ListVmwareAdminClustersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareAdminClustersListCall) Pages(ctx context.Context, f func(*ListVmwareAdminClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.patch":

type ProjectsLocationsVmwareAdminClustersPatchCall struct {
	s                  *Service
	name               string
	vmwareadmincluster *VmwareAdminCluster
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates the parameters of a single VMware admin cluster.
//
// - name: Immutable. The VMware admin cluster resource name.
func (r *ProjectsLocationsVmwareAdminClustersService) Patch(name string, vmwareadmincluster *VmwareAdminCluster) *ProjectsLocationsVmwareAdminClustersPatchCall {
	c := &ProjectsLocationsVmwareAdminClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.vmwareadmincluster = vmwareadmincluster
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// VMwareAdminCluster resource by the update. The fields specified in
// the update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the VmwareAdminCluster
// message will be updated. Empty fields will be ignored unless a field
// mask is used.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVmwareAdminClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareAdminClustersPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwareadmincluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single VMware admin cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The VMware admin cluster resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the VMwareAdminCluster resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the VmwareAdminCluster message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "VmwareAdminCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.setIamPolicy":

type ProjectsLocationsVmwareAdminClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareAdminClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall {
	c := &ProjectsLocationsVmwareAdminClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareAdminClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.testIamPermissions":

type ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareAdminClustersService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall {
	c := &ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.unenroll":

type ProjectsLocationsVmwareAdminClustersUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls an existing VMware admin cluster from the Anthos
// On-Prem API within a given project and location. Unenrollment removes
// the Cloud reference to the cluster without modifying the underlying
// OnPrem Resources. Clusters will continue to run; however, they will
// no longer be accessible through the Anthos On-Prem API or its
// clients.
//
//   - name: Name of the VMware admin cluster to be unenrolled. Format:
//     "projects/{project}/locations/{location}/vmwareAdminClusters/{cluste
//     r}".
func (r *ProjectsLocationsVmwareAdminClustersService) Unenroll(name string) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c := &ProjectsLocationsVmwareAdminClustersUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the VMware admin cluster is not found, the request will
// succeed but no action will be taken on the server and return a
// completed LRO.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// VMware admin cluster. If an etag is provided and does not match the
// current etag of the cluster, deletion will be blocked and an ABORTED
// error will be returned.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) Etag(etag string) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls an existing VMware admin cluster from the Anthos On-Prem API within a given project and location. Unenrollment removes the Cloud reference to the cluster without modifying the underlying OnPrem Resources. Clusters will continue to run; however, they will no longer be accessible through the Anthos On-Prem API or its clients.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the VMware admin cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the VMware admin cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Name of the VMware admin cluster to be unenrolled. Format: \"projects/{project}/locations/{location}/vmwareAdminClusters/{cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.operations.get":

type ProjectsLocationsVmwareAdminClustersOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsVmwareAdminClustersOperationsService) Get(name string) *ProjectsLocationsVmwareAdminClustersOperationsGetCall {
	c := &ProjectsLocationsVmwareAdminClustersOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareAdminClustersOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareAdminClusters.operations.list":

type ProjectsLocationsVmwareAdminClustersOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsVmwareAdminClustersOperationsService) List(name string) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c := &ProjectsLocationsVmwareAdminClustersOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Filter(filter string) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) PageToken(pageToken string) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Context(ctx context.Context) *ProjectsLocationsVmwareAdminClustersOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareAdminClusters.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareAdminClusters/{vmwareAdminClustersId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareAdminClusters.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareAdminClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareAdminClustersOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareClusters.create":

type ProjectsLocationsVmwareClustersCreateCall struct {
	s             *Service
	parent        string
	vmwarecluster *VmwareCluster
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a new VMware user cluster in a given project and
// location.
//
//   - parent: The parent of the project and location where this cluster
//     is created in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareClustersService) Create(parent string, vmwarecluster *VmwareCluster) *ProjectsLocationsVmwareClustersCreateCall {
	c := &ProjectsLocationsVmwareClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.vmwarecluster = vmwarecluster
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareClustersCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// VmwareClusterId sets the optional parameter "vmwareClusterId": User
// provided identifier that is used as part of the resource name; This
// value must be up to 40 characters and follow RFC-1123
// (https://tools.ietf.org/html/rfc1123) format.
func (c *ProjectsLocationsVmwareClustersCreateCall) VmwareClusterId(vmwareClusterId string) *ProjectsLocationsVmwareClustersCreateCall {
	c.urlParams_.Set("vmwareClusterId", vmwareClusterId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersCreateCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwarecluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new VMware user cluster in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location where this cluster is created in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "vmwareClusterId": {
	//       "description": "User provided identifier that is used as part of the resource name; This value must be up to 40 characters and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareClusters",
	//   "request": {
	//     "$ref": "VmwareCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.delete":

type ProjectsLocationsVmwareClustersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single VMware Cluster.
//
//   - name: Name of the VMware user cluster to be deleted. Format:
//     "projects/{project}/locations/{location}/vmwareClusters/{vmware_clus
//     ter}".
func (r *ProjectsLocationsVmwareClustersService) Delete(name string) *ProjectsLocationsVmwareClustersDeleteCall {
	c := &ProjectsLocationsVmwareClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the VMware cluster is not found, the request will succeed
// but no action will be taken on the server and return a completed LRO.
func (c *ProjectsLocationsVmwareClustersDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// VMware cluster. If an etag is provided and does not match the current
// etag of the cluster, deletion will be blocked and an ABORTED error
// will be returned.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Etag(etag string) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": If set to true, any node
// pools from the cluster will also be deleted.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Force(force bool) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// IgnoreErrors sets the optional parameter "ignoreErrors": If set to
// true, the deletion of a VMware user cluster resource will succeed
// even if errors occur during deletion. This parameter can be used when
// you want to delete GCP's cluster resource and the on-prem admin
// cluster that hosts your user cluster is disconnected / unreachable or
// deleted. WARNING: Using this parameter when your user cluster still
// exists may result in a deleted GCP user cluster but an existing
// on-prem user cluster.
func (c *ProjectsLocationsVmwareClustersDeleteCall) IgnoreErrors(ignoreErrors bool) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("ignoreErrors", fmt.Sprint(ignoreErrors))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareClustersDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single VMware Cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the VMware cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the VMware cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "force": {
	//       "description": "If set to true, any node pools from the cluster will also be deleted.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "ignoreErrors": {
	//       "description": "If set to true, the deletion of a VMware user cluster resource will succeed even if errors occur during deletion. This parameter can be used when you want to delete GCP's cluster resource and the on-prem admin cluster that hosts your user cluster is disconnected / unreachable or deleted. WARNING: Using this parameter when your user cluster still exists may result in a deleted GCP user cluster but an existing on-prem user cluster.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. Name of the VMware user cluster to be deleted. Format: \"projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.enroll":

type ProjectsLocationsVmwareClustersEnrollCall struct {
	s                          *Service
	parent                     string
	enrollvmwareclusterrequest *EnrollVmwareClusterRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Enroll: Enrolls an existing VMware user cluster and its node pools to
// the Anthos On-Prem API within a given project and location. Through
// enrollment, an existing cluster will become Anthos On-Prem API
// managed. The corresponding GCP resources will be created and all
// future modifications to the cluster and/or its node pools will be
// expected to be performed through the API.
//
//   - parent: The parent of the project and location where the cluster is
//     Enrolled in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareClustersService) Enroll(parent string, enrollvmwareclusterrequest *EnrollVmwareClusterRequest) *ProjectsLocationsVmwareClustersEnrollCall {
	c := &ProjectsLocationsVmwareClustersEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollvmwareclusterrequest = enrollvmwareclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersEnrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollvmwareclusterrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareClusters:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls an existing VMware user cluster and its node pools to the Anthos On-Prem API within a given project and location. Through enrollment, an existing cluster will become Anthos On-Prem API managed. The corresponding GCP resources will be created and all future modifications to the cluster and/or its node pools will be expected to be performed through the API.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the cluster is Enrolled in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareClusters:enroll",
	//   "request": {
	//     "$ref": "EnrollVmwareClusterRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.get":

type ProjectsLocationsVmwareClustersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single VMware Cluster.
//
//   - name: Name of the VMware user cluster to be returned. Format:
//     "projects/{project}/locations/{location}/vmwareClusters/{vmware_clus
//     ter}".
func (r *ProjectsLocationsVmwareClustersService) Get(name string) *ProjectsLocationsVmwareClustersGetCall {
	c := &ProjectsLocationsVmwareClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for VMware user
// cluster. When `BASIC` is specified, only the cluster resource name
// and admin cluster membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and admin cluster membership.
//
//	"FULL" - Includes the complete configuration for VMware cluster
//
// resource. This is the default value for GetVmwareClusterRequest
// method.
func (c *ProjectsLocationsVmwareClustersGetCall) View(view string) *ProjectsLocationsVmwareClustersGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.get" call.
// Exactly one of *VmwareCluster or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *VmwareCluster.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersGetCall) Do(opts ...googleapi.CallOption) (*VmwareCluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VmwareCluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single VMware Cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the VMware user cluster to be returned. Format: \"projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware user cluster. When `BASIC` is specified, only the cluster resource name and admin cluster membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and admin cluster membership.",
	//         "Includes the complete configuration for VMware cluster resource. This is the default value for GetVmwareClusterRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "VmwareCluster"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.getIamPolicy":

type ProjectsLocationsVmwareClustersGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersService) GetIamPolicy(resource string) *ProjectsLocationsVmwareClustersGetIamPolicyCall {
	c := &ProjectsLocationsVmwareClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsVmwareClustersGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.list":

type ProjectsLocationsVmwareClustersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists VMware Clusters in a given project and location.
//
//   - parent: The parent of the project and location where the clusters
//     are listed in. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareClustersService) List(parent string) *ProjectsLocationsVmwareClustersListCall {
	c := &ProjectsLocationsVmwareClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A resource filtering
// expression following https://google.aip.dev/160. When non-empty, only
// resource's whose attributes field matches the filter are returned.
func (c *ProjectsLocationsVmwareClustersListCall) Filter(filter string) *ProjectsLocationsVmwareClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, at most
// 50 clusters will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsLocationsVmwareClustersListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying a page of results the server should return.
func (c *ProjectsLocationsVmwareClustersListCall) PageToken(pageToken string) *ProjectsLocationsVmwareClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for VMware clusters.
// When `BASIC` is specified, only the cluster resource name and admin
// cluster membership are returned. The default/unset value
// `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the
// complete cluster configuration details.
//
// Possible values:
//
//	"CLUSTER_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a cluster resource
//
// including cluster resource name and admin cluster membership.
//
//	"FULL" - Includes the complete configuration for VMware cluster
//
// resource. This is the default value for ListVmwareClustersRequest
// method.
func (c *ProjectsLocationsVmwareClustersListCall) View(view string) *ProjectsLocationsVmwareClustersListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersListCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareClusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.list" call.
// Exactly one of *ListVmwareClustersResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListVmwareClustersResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersListCall) Do(opts ...googleapi.CallOption) (*ListVmwareClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVmwareClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists VMware Clusters in a given project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A resource filtering expression following https://google.aip.dev/160. When non-empty, only resource's whose attributes field matches the filter are returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, at most 50 clusters will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying a page of results the server should return.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location where the clusters are listed in. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware clusters. When `BASIC` is specified, only the cluster resource name and admin cluster membership are returned. The default/unset value `CLUSTER_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete cluster configuration details.",
	//       "enum": [
	//         "CLUSTER_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a cluster resource including cluster resource name and admin cluster membership.",
	//         "Includes the complete configuration for VMware cluster resource. This is the default value for ListVmwareClustersRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareClusters",
	//   "response": {
	//     "$ref": "ListVmwareClustersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareClustersListCall) Pages(ctx context.Context, f func(*ListVmwareClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareClusters.patch":

type ProjectsLocationsVmwareClustersPatchCall struct {
	s             *Service
	name          string
	vmwarecluster *VmwareCluster
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the parameters of a single VMware cluster.
//
// - name: Immutable. The VMware user cluster resource name.
func (r *ProjectsLocationsVmwareClustersService) Patch(name string, vmwarecluster *VmwareCluster) *ProjectsLocationsVmwareClustersPatchCall {
	c := &ProjectsLocationsVmwareClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.vmwarecluster = vmwarecluster
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// VMwareCluster resource by the update. The fields specified in the
// update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the VmwareCluster message
// will be updated. Empty fields will be ignored unless a field mask is
// used.
func (c *ProjectsLocationsVmwareClustersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVmwareClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareClustersPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersPatchCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwarecluster)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single VMware cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The VMware user cluster resource name.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the VMwareCluster resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the VmwareCluster message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "VmwareCluster"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.queryVersionConfig":

type ProjectsLocationsVmwareClustersQueryVersionConfigCall struct {
	s          *Service
	parent     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// QueryVersionConfig: Queries the VMware user cluster version config.
//
//   - parent: The parent of the project and location to query for version
//     config. Format: "projects/{project}/locations/{location}".
func (r *ProjectsLocationsVmwareClustersService) QueryVersionConfig(parent string) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c := &ProjectsLocationsVmwareClustersQueryVersionConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CreateConfigAdminClusterMembership sets the optional parameter
// "createConfig.adminClusterMembership": The admin cluster membership.
// This is the full resource name of the admin cluster's fleet
// membership. Format:
// "projects/{project}/locations/{location}/memberships/{membership}"
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) CreateConfigAdminClusterMembership(createConfigAdminClusterMembership string) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c.urlParams_.Set("createConfig.adminClusterMembership", createConfigAdminClusterMembership)
	return c
}

// CreateConfigAdminClusterName sets the optional parameter
// "createConfig.adminClusterName": The admin cluster resource name.
// This is the full resource name of the admin cluster resource. Format:
// "projects/{project}/locations/{location}/vmwareAdminClusters/{vmware_a
// dmin_cluster}"
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) CreateConfigAdminClusterName(createConfigAdminClusterName string) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c.urlParams_.Set("createConfig.adminClusterName", createConfigAdminClusterName)
	return c
}

// UpgradeConfigClusterName sets the optional parameter
// "upgradeConfig.clusterName": The user cluster resource name. This is
// the full resource name of the user cluster resource. Format:
// "projects/{project}/locations/{location}/vmwareClusters/{vmware_cluste
// r}"
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) UpgradeConfigClusterName(upgradeConfigClusterName string) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c.urlParams_.Set("upgradeConfig.clusterName", upgradeConfigClusterName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersQueryVersionConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareClusters:queryVersionConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.queryVersionConfig" call.
// Exactly one of *QueryVmwareVersionConfigResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *QueryVmwareVersionConfigResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersQueryVersionConfigCall) Do(opts ...googleapi.CallOption) (*QueryVmwareVersionConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryVmwareVersionConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Queries the VMware user cluster version config.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters:queryVersionConfig",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.queryVersionConfig",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "createConfig.adminClusterMembership": {
	//       "description": "The admin cluster membership. This is the full resource name of the admin cluster's fleet membership. Format: \"projects/{project}/locations/{location}/memberships/{membership}\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "createConfig.adminClusterName": {
	//       "description": "The admin cluster resource name. This is the full resource name of the admin cluster resource. Format: \"projects/{project}/locations/{location}/vmwareAdminClusters/{vmware_admin_cluster}\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent of the project and location to query for version config. Format: \"projects/{project}/locations/{location}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "upgradeConfig.clusterName": {
	//       "description": "The user cluster resource name. This is the full resource name of the user cluster resource. Format: \"projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}\"",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareClusters:queryVersionConfig",
	//   "response": {
	//     "$ref": "QueryVmwareVersionConfigResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.setIamPolicy":

type ProjectsLocationsVmwareClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsVmwareClustersSetIamPolicyCall {
	c := &ProjectsLocationsVmwareClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.testIamPermissions":

type ProjectsLocationsVmwareClustersTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsVmwareClustersTestIamPermissionsCall {
	c := &ProjectsLocationsVmwareClustersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.unenroll":

type ProjectsLocationsVmwareClustersUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls an existing VMware user cluster and its node
// pools from the Anthos On-Prem API within a given project and
// location. Unenrollment removes the Cloud reference to the cluster
// without modifying the underlying OnPrem Resources. Clusters and node
// pools will continue to run; however, they will no longer be
// accessible through the Anthos On-Prem API or UI.
//
//   - name: Name of the VMware user cluster to be unenrolled. Format:
//     "projects/{project}/locations/{location}/vmwareClusters/{vmware_clus
//     ter}".
func (r *ProjectsLocationsVmwareClustersService) Unenroll(name string) *ProjectsLocationsVmwareClustersUnenrollCall {
	c := &ProjectsLocationsVmwareClustersUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the VMware cluster is not found, the request will succeed
// but no action will be taken on the server and return a completed LRO.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// VMware Cluster. If an etag is provided and does not match the current
// etag of the cluster, deletion will be blocked and an ABORTED error
// will be returned.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Etag(etag string) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Force sets the optional parameter "force": This is required if the
// cluster has any associated node pools. When set, any child node pools
// will also be unenrolled.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Force(force bool) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls an existing VMware user cluster and its node pools from the Anthos On-Prem API within a given project and location. Unenrollment removes the Cloud reference to the cluster without modifying the underlying OnPrem Resources. Clusters and node pools will continue to run; however, they will no longer be accessible through the Anthos On-Prem API or UI.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the VMware cluster is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the VMware Cluster. If an etag is provided and does not match the current etag of the cluster, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "force": {
	//       "description": "This is required if the cluster has any associated node pools. When set, any child node pools will also be unenrolled.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. Name of the VMware user cluster to be unenrolled. Format: \"projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.operations.get":

type ProjectsLocationsVmwareClustersOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsVmwareClustersOperationsService) Get(name string) *ProjectsLocationsVmwareClustersOperationsGetCall {
	c := &ProjectsLocationsVmwareClustersOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.operations.list":

type ProjectsLocationsVmwareClustersOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsVmwareClustersOperationsService) List(name string) *ProjectsLocationsVmwareClustersOperationsListCall {
	c := &ProjectsLocationsVmwareClustersOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Filter(filter string) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) PageToken(pageToken string) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareClustersOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.create":

type ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall struct {
	s              *Service
	parent         string
	vmwarenodepool *VmwareNodePool
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a new VMware node pool in a given project, location
// and VMWare cluster.
//
//   - parent: The parent resource where this node pool will be created.
//     projects/{project}/locations/{location}/vmwareClusters/{cluster}.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Create(parent string, vmwarenodepool *VmwareNodePool) *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.vmwarenodepool = vmwarenodepool
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually create the node pool.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// VmwareNodePoolId sets the optional parameter "vmwareNodePoolId": The
// ID to use for the node pool, which will become the final component of
// the node pool's resource name. This value must be up to 40 characters
// and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format. The
// value must not be permitted to be a UUID (or UUID-like: anything
// matching /^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$/i).
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) VmwareNodePoolId(vmwareNodePoolId string) *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall {
	c.urlParams_.Set("vmwareNodePoolId", vmwareNodePoolId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwarenodepool)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareNodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new VMware node pool in a given project, location and VMWare cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this node pool will be created. projects/{project}/locations/{location}/vmwareClusters/{cluster}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually create the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "vmwareNodePoolId": {
	//       "description": "The ID to use for the node pool, which will become the final component of the node pool's resource name. This value must be up to 40 characters and follow RFC-1123 (https://tools.ietf.org/html/rfc1123) format. The value must not be permitted to be a UUID (or UUID-like: anything matching /^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$/i).",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareNodePools",
	//   "request": {
	//     "$ref": "VmwareNodePool"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.delete":

type ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single VMware node pool.
//
//   - name: The name of the node pool to delete. Format:
//     projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmw
//     areNodePools/{nodepool}.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Delete(name string) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the VMware node pool is not found, the request will succeed
// but no action will be taken on the server and return a completed LRO.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) AllowMissing(allowMissing bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// VmwareNodePool. If an etag is provided and does not match the current
// etag of the node pool, deletion will be blocked and an ABORTED error
// will be returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) Etag(etag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// IgnoreErrors sets the optional parameter "ignoreErrors": If set to
// true, the deletion of a VMware node pool resource will succeed even
// if errors occur during deletion. This parameter can be used when you
// want to delete GCP's node pool resource and you've already deleted
// the on-prem admin cluster that hosted your node pool. WARNING: Using
// this parameter when your user cluster still exists may result in a
// deleted GCP node pool but an existing on-prem node pool.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) IgnoreErrors(ignoreErrors bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.urlParams_.Set("ignoreErrors", fmt.Sprint(ignoreErrors))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually delete the node pool.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a single VMware node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the VMware node pool is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the VmwareNodePool. If an etag is provided and does not match the current etag of the node pool, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "ignoreErrors": {
	//       "description": "If set to true, the deletion of a VMware node pool resource will succeed even if errors occur during deletion. This parameter can be used when you want to delete GCP's node pool resource and you've already deleted the on-prem admin cluster that hosted your node pool. WARNING: Using this parameter when your user cluster still exists may result in a deleted GCP node pool but an existing on-prem node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Required. The name of the node pool to delete. Format: projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmwareNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually delete the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.enroll":

type ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall struct {
	s                           *Service
	parent                      string
	enrollvmwarenodepoolrequest *EnrollVmwareNodePoolRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Enroll: Enrolls a VMware node pool to Anthos On-Prem API
//
// - parent: The parent resource where the node pool is enrolled in.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Enroll(parent string, enrollvmwarenodepoolrequest *EnrollVmwareNodePoolRequest) *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.enrollvmwarenodepoolrequest = enrollvmwarenodepoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.enrollvmwarenodepoolrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareNodePools:enroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.enroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsEnrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Enrolls a VMware node pool to Anthos On-Prem API",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools:enroll",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.enroll",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where the node pool is enrolled in.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareNodePools:enroll",
	//   "request": {
	//     "$ref": "EnrollVmwareNodePoolRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.get":

type ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single VMware node pool.
//
//   - name: The name of the node pool to retrieve.
//     projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmw
//     areNodePools/{nodepool}.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Get(name string) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": View for VMware node pool.
// When `BASIC` is specified, only the node pool resource name is
// returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the
// same as `FULL', which returns the complete node pool configuration
// details.
//
// Possible values:
//
//	"NODE_POOL_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a node pool resource
//
// including node pool resource name.
//
//	"FULL" - Includes the complete configuration for VMware node pool
//
// resource. This is the default value for GetVmwareNodePoolRequest
// method.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) View(view string) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.get" call.
// Exactly one of *VmwareNodePool or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *VmwareNodePool.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetCall) Do(opts ...googleapi.CallOption) (*VmwareNodePool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VmwareNodePool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details of a single VMware node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the node pool to retrieve. projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmwareNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware node pool. When `BASIC` is specified, only the node pool resource name is returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete node pool configuration details.",
	//       "enum": [
	//         "NODE_POOL_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a node pool resource including node pool resource name.",
	//         "Includes the complete configuration for VMware node pool resource. This is the default value for GetVmwareNodePoolRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "VmwareNodePool"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.getIamPolicy":

type ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) GetIamPolicy(resource string) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset. The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1. To learn
// which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.getIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.list":

type ProjectsLocationsVmwareClustersVmwareNodePoolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists VMware node pools in a given project, location and VMWare
// cluster.
//
//   - parent: The parent, which owns this collection of node pools.
//     Format:
//     projects/{project}/locations/{location}/vmwareClusters/{vmwareCluste
//     r}.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) List(parent string) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of node pools to return. The service may return fewer than this
// value. If unspecified, at most 50 node pools will be returned. The
// maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListVmwareNodePools` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListVmwareNodePools` must match the call that provided
// the page token.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) PageToken(pageToken string) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": View for VMware node pools.
// When `BASIC` is specified, only the node pool resource name is
// returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the
// same as `FULL', which returns the complete node pool configuration
// details.
//
// Possible values:
//
//	"NODE_POOL_VIEW_UNSPECIFIED" - If the value is not set, the default
//
// `FULL` view is used.
//
//	"BASIC" - Includes basic information of a node pool resource
//
// including node pool resource name.
//
//	"FULL" - Includes the complete configuration for VMware node pool
//
// resource. This is the default value for ListVmwareNodePoolsRequest
// method.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) View(view string) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/vmwareNodePools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.list" call.
// Exactly one of *ListVmwareNodePoolsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListVmwareNodePoolsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) Do(opts ...googleapi.CallOption) (*ListVmwareNodePoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVmwareNodePoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists VMware node pools in a given project, location and VMWare cluster.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of node pools to return. The service may return fewer than this value. If unspecified, at most 50 node pools will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListVmwareNodePools` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListVmwareNodePools` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent, which owns this collection of node pools. Format: projects/{project}/locations/{location}/vmwareClusters/{vmwareCluster}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "View for VMware node pools. When `BASIC` is specified, only the node pool resource name is returned. The default/unset value `NODE_POOL_VIEW_UNSPECIFIED` is the same as `FULL', which returns the complete node pool configuration details.",
	//       "enum": [
	//         "NODE_POOL_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "If the value is not set, the default `FULL` view is used.",
	//         "Includes basic information of a node pool resource including node pool resource name.",
	//         "Includes the complete configuration for VMware node pool resource. This is the default value for ListVmwareNodePoolsRequest method."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/vmwareNodePools",
	//   "response": {
	//     "$ref": "ListVmwareNodePoolsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsListCall) Pages(ctx context.Context, f func(*ListVmwareNodePoolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.patch":

type ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall struct {
	s              *Service
	name           string
	vmwarenodepool *VmwareNodePool
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates the parameters of a single VMware node pool.
//
// - name: Immutable. The resource name of this node pool.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Patch(name string, vmwarenodepool *VmwareNodePool) *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.vmwarenodepool = vmwarenodepool
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field
// mask is used to specify the fields to be overwritten in the
// VMwareNodePool resource by the update. The fields specified in the
// update_mask are relative to the resource, not the full request. A
// field will be overwritten if it is in the mask. If the user does not
// provide a mask then all populated fields in the VMwareNodePool
// message will be updated. Empty fields will be ignored unless a field
// mask is used.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Validate the
// request without actually doing any updates.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.vmwarenodepool)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the parameters of a single VMware node pool.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}",
	//   "httpMethod": "PATCH",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The resource name of this node pool.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Field mask is used to specify the fields to be overwritten in the VMwareNodePool resource by the update. The fields specified in the update_mask are relative to the resource, not the full request. A field will be overwritten if it is in the mask. If the user does not provide a mask then all populated fields in the VMwareNodePool message will be updated. Empty fields will be ignored unless a field mask is used.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Validate the request without actually doing any updates.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "VmwareNodePool"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.setIamPolicy":

type ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy. Can return `NOT_FOUND`,
// `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.setIamPolicy" call.
// Exactly one of *Policy or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.testIamPermissions":

type ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a `NOT_FOUND` error. Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.testIamPermissions" call.
// Exactly one of *TestIamPermissionsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.unenroll":

type ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Unenroll: Unenrolls a VMware node pool to Anthos On-Prem API
//
//   - name: The name of the node pool to unenroll. Format:
//     projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmw
//     areNodePools/{nodepool}.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsService) Unenroll(name string) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the VMware node pool is not found, the request will succeed
// but no action will be taken on the server and return a completed LRO.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) AllowMissing(allowMissing bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Etag sets the optional parameter "etag": The current etag of the
// VMware node pool. If an etag is provided and does not match the
// current etag of node pool, deletion will be blocked and an ABORTED
// error will be returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) Etag(etag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": If set, only
// validate the request, but do not actually unenroll the node pool.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) ValidateOnly(validateOnly bool) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:unenroll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.unenroll" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsUnenrollCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unenrolls a VMware node pool to Anthos On-Prem API",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}:unenroll",
	//   "httpMethod": "DELETE",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.unenroll",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the VMware node pool is not found, the request will succeed but no action will be taken on the server and return a completed LRO.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "etag": {
	//       "description": "The current etag of the VMware node pool. If an etag is provided and does not match the current etag of node pool, deletion will be blocked and an ABORTED error will be returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The name of the node pool to unenroll. Format: projects/{project}/locations/{location}/vmwareClusters/{cluster}/vmwareNodePools/{nodepool}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "If set, only validate the request, but do not actually unenroll the node pool.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}:unenroll",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.get":

type ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService) Get(name string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.list":

type ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsService) List(name string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c := &ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Filter(filter string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.list" call.
// Exactly one of *ListOperationsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/vmwareClusters/{vmwareClustersId}/vmwareNodePools/{vmwareNodePoolsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "gkeonprem.projects.locations.vmwareClusters.vmwareNodePools.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/vmwareClusters/[^/]+/vmwareNodePools/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "ListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
