// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contactcenterinsights provides access to the Contact Center AI Insights API.
//
// For product documentation, see: https://cloud.google.com/contact-center/insights/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contactcenterinsights/v1"
//	...
//	ctx := context.Background()
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contactcenterinsights // import "google.golang.org/api/contactcenterinsights/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "contactcenterinsights:v1"
const apiName = "contactcenterinsights"
const apiVersion = "v1"
const basePath = "https://contactcenterinsights.googleapis.com/"
const basePathTemplate = "https://contactcenterinsights.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://contactcenterinsights.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AnalysisRules = NewProjectsLocationsAnalysisRulesService(s)
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.EncryptionSpec = NewProjectsLocationsEncryptionSpecService(s)
	rs.Insightsdata = NewProjectsLocationsInsightsdataService(s)
	rs.IssueModels = NewProjectsLocationsIssueModelsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PhraseMatchers = NewProjectsLocationsPhraseMatchersService(s)
	rs.QaScorecards = NewProjectsLocationsQaScorecardsService(s)
	rs.Views = NewProjectsLocationsViewsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AnalysisRules *ProjectsLocationsAnalysisRulesService

	Conversations *ProjectsLocationsConversationsService

	EncryptionSpec *ProjectsLocationsEncryptionSpecService

	Insightsdata *ProjectsLocationsInsightsdataService

	IssueModels *ProjectsLocationsIssueModelsService

	Operations *ProjectsLocationsOperationsService

	PhraseMatchers *ProjectsLocationsPhraseMatchersService

	QaScorecards *ProjectsLocationsQaScorecardsService

	Views *ProjectsLocationsViewsService
}

func NewProjectsLocationsAnalysisRulesService(s *Service) *ProjectsLocationsAnalysisRulesService {
	rs := &ProjectsLocationsAnalysisRulesService{s: s}
	return rs
}

type ProjectsLocationsAnalysisRulesService struct {
	s *Service
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsConversationsAnalysesService(s)
	rs.FeedbackLabels = NewProjectsLocationsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsConversationsAnalysesService

	FeedbackLabels *ProjectsLocationsConversationsFeedbackLabelsService
}

func NewProjectsLocationsConversationsAnalysesService(s *Service) *ProjectsLocationsConversationsAnalysesService {
	rs := &ProjectsLocationsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsEncryptionSpecService(s *Service) *ProjectsLocationsEncryptionSpecService {
	rs := &ProjectsLocationsEncryptionSpecService{s: s}
	return rs
}

type ProjectsLocationsEncryptionSpecService struct {
	s *Service
}

func NewProjectsLocationsInsightsdataService(s *Service) *ProjectsLocationsInsightsdataService {
	rs := &ProjectsLocationsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsIssueModelsService(s *Service) *ProjectsLocationsIssueModelsService {
	rs := &ProjectsLocationsIssueModelsService{s: s}
	rs.Issues = NewProjectsLocationsIssueModelsIssuesService(s)
	return rs
}

type ProjectsLocationsIssueModelsService struct {
	s *Service

	Issues *ProjectsLocationsIssueModelsIssuesService
}

func NewProjectsLocationsIssueModelsIssuesService(s *Service) *ProjectsLocationsIssueModelsIssuesService {
	rs := &ProjectsLocationsIssueModelsIssuesService{s: s}
	return rs
}

type ProjectsLocationsIssueModelsIssuesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPhraseMatchersService(s *Service) *ProjectsLocationsPhraseMatchersService {
	rs := &ProjectsLocationsPhraseMatchersService{s: s}
	return rs
}

type ProjectsLocationsPhraseMatchersService struct {
	s *Service
}

func NewProjectsLocationsQaScorecardsService(s *Service) *ProjectsLocationsQaScorecardsService {
	rs := &ProjectsLocationsQaScorecardsService{s: s}
	rs.Revisions = NewProjectsLocationsQaScorecardsRevisionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsService struct {
	s *Service

	Revisions *ProjectsLocationsQaScorecardsRevisionsService
}

func NewProjectsLocationsQaScorecardsRevisionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsService{s: s}
	rs.QaQuestions = NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsService struct {
	s *Service

	QaQuestions *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService
}

func NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsService{s: s}
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsService struct {
	s *Service
}

func NewProjectsLocationsViewsService(s *Service) *ProjectsLocationsViewsService {
	rs := &ProjectsLocationsViewsService{s: s}
	return rs
}

type ProjectsLocationsViewsService struct {
	s *Service
}

// GoogleCloudContactcenterinsightsV1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResult: The result of an analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisRule: The CCAI Insights project
// wide analysis rule. This rule will be applied to all conversations that
// match the filter defined in the rule. For a conversation matches the filter,
// the annotators specified in the rule will be run. If a conversation matches
// multiple rules, a union of all the annotators will be run. One project can
// have multiple analysis rules.
type GoogleCloudContactcenterinsightsV1AnalysisRule struct {
	// Active: If true, apply this rule to conversations. Otherwise, this rule is
	// inactive and saved as a draft.
	Active bool `json:"active,omitempty"`
	// AnalysisPercentage: Percentage of conversations that we should apply this
	// analysis setting automatically, between [0, 1]. For example, 0.1 means 10%.
	// Conversations are sampled in a determenestic way. The original
	// runtime_percentage & upload percentage will be replaced by defining filters
	// on the conversation.
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: Selector of annotators to run and the phrase matchers to
	// use for conversations that matches the conversation_filter. If not
	// specified, NO annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// ConversationFilter: Filter for the conversations that should apply this
	// analysis rule. An empty filter means this analysis rule applies to all
	// conversations.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// CreateTime: Output only. The time at which this analysis rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name of the analysis rule.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the analysis rule. Format:
	// projects/{project}/locations/{location}/analysisRules/{analysis_rule}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which this analysis rule
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1AnalysisRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig: Configuration
// for the QA feature.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList:
// Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig:
// Configuration for summarization.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnswerFeedback: The feedback that the
// customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata: The
// metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse: The
// response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata:
// Metadata for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DownloadStats: Output only. Statistics for BulkDownloadFeedbackLabels
	// operation.
	DownloadStats *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats `json:"downloadStats,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for download.
	Request *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadS
// tats: Statistics for BulkDownloadFeedbackLabels operation.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats struct {
	// FileNames: Output only. Full name of the files written to Cloud storage.
	FileNames []string `json:"fileNames,omitempty"`
	// ProcessedObjectCount: The number of objects processed during the download
	// operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulDownloadCount: The number of new feedback labels downloaded during
	// this operation. Different from "processed" because some labels might not be
	// downloaded because an error.
	SuccessfulDownloadCount int64 `json:"successfulDownloadCount,omitempty"`
	// TotalFilesWritten: Total number of files written to the provided Cloud
	// Storage bucket.
	TotalFilesWritten int64 `json:"totalFilesWritten,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest: Request
// for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest struct {
	// ConversationFilter: Optional. Filter parent conversations to download
	// feedback labels for. When specified, the feedback labels will be downloaded
	// for the conversations that match the filter. If `template_qa_scorecard_id`
	// is set, all the conversations that match the filter will be paired with the
	// questions under the scorecard for labeling.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// FeedbackLabelType: Optional. The type of feedback labels that will be
	// downloaded.
	//
	// Possible values:
	//   "FEEDBACK_LABEL_TYPE_UNSPECIFIED" - Unspecified format
	//   "QUALITY_AI" - Downloaded file will contain all Quality AI labels from the
	// latest scorecard revision.
	//   "TOPIC_MODELING" - Downloaded file will contain only Topic Modeling
	// labels.
	FeedbackLabelType string `json:"feedbackLabelType,omitempty"`
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// GcsDestination: A cloud storage bucket destination.
	GcsDestination *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination `json:"gcsDestination,omitempty"`
	// MaxDownloadCount: Optional. Limits the maximum number of feedback labels
	// that will be downloaded. The first `N` feedback labels will be downloaded.
	MaxDownloadCount int64 `json:"maxDownloadCount,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// TemplateQaScorecardId: Optional. If set, a template for labeling
	// conversations and scorecard questions will be created from the
	// conversation_filter and the questions under the scorecard(s). The feedback
	// label `filter` will be ignored.
	TemplateQaScorecardId []string `json:"templateQaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestina
// tion: Google Cloud Storage Object details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination struct {
	// AddWhitespace: Optional. Add whitespace to the JSON file. Makes easier to
	// read, but increases file size. Only applicable for JSON format.
	AddWhitespace bool `json:"addWhitespace,omitempty"`
	// AlwaysPrintEmptyFields: Optional. Always print fields with no presence. This
	// is useful for printing fields that are not set, like implicit 0 value or
	// empty lists/maps. Only applicable for JSON format.
	AlwaysPrintEmptyFields bool `json:"alwaysPrintEmptyFields,omitempty"`
	// Format: Required. File format in which the labels will be exported.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format. 1,000 labels are stored per CSV file by default.
	//   "JSON" - JSON format. 1 label stored per JSON file by default.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI to write the feedback
	// labels to. The file name will be used as a prefix for the files written to
	// the bucket if the output needs to be split across multiple files, otherwise
	// it will be used as is. The file extension will be appended to the file name
	// based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
	ObjectUri string `json:"objectUri,omitempty"`
	// RecordsPerFileCount: Optional. The number of records per file. Applicable
	// for either format.
	RecordsPerFileCount int64 `json:"recordsPerFileCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AddWhitespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddWhitespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse:
// Response for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest: The
// request for bulk uploading feedback labels.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest struct {
	// GcsSource: A cloud storage bucket source.
	GcsSource *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource `json:"gcsSource,omitempty"`
	// ValidateOnly: Optional. If set, upload will not happen and the labels will
	// be validated. If not set, then default behavior will be to upload the labels
	// after validation is complete.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource:
// Google Cloud Storage Object details to get the feedback label file from.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource struct {
	// Format: Required. File format which will be ingested.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format.
	//   "JSON" - JSON format.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI of the file to import.
	// Format: `gs://bucket_name/object_name`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse: Response
// of querying an issue model's statistics.
type GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse struct {
	// CurrentStats: The latest label statistics for the queried issue model.
	// Includes results on both training data and data labeled after deployment.
	CurrentStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"currentStats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponse: The response for
// calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponse struct {
	// AverageDuration: The average duration of all conversations. The average is
	// calculated using only conversations that have a time duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageTurnCount: The average number of turns per conversation.
	AverageTurnCount int64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The total number of conversations.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// ConversationCountTimeSeries: A time series representing the count of
	// conversations created over time that match that requested filter criteria.
	ConversationCountTimeSeries *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries `json:"conversationCountTimeSeries,omitempty"`
	// CustomHighlighterMatches: A map associating each custom highlighter resource
	// name with its respective number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int64 `json:"customHighlighterMatches,omitempty"`
	// IssueMatches: A map associating each issue resource name with its respective
	// number of matches in the set of conversations. Key has the format:
	// `projects//locations//issueModels//issues/` Deprecated, use
	// `issue_matches_stats` field instead.
	IssueMatches map[string]int64 `json:"issueMatches,omitempty"`
	// IssueMatchesStats: A map associating each issue resource name with its
	// respective number of matches in the set of conversations. Key has the
	// format: `projects//locations//issueModels//issues/`
	IssueMatchesStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueMatchesStats,omitempty"`
	// SmartHighlighterMatches: A map associating each smart highlighter display
	// name with its respective number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int64 `json:"smartHighlighterMatches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AverageDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries: A time
// series representing conversations over time.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries struct {
	// IntervalDuration: The duration of each interval.
	IntervalDuration string `json:"intervalDuration,omitempty"`
	// Points: An ordered list of intervals from earliest to latest, where each
	// interval represents the number of conversations that transpired during the
	// time window.
	Points []*GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval `json:"points,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntervalDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntervalDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval:
// A single interval in a time series.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval struct {
	// ConversationCount: The number of conversations created in this interval.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// StartTime: The start time of this interval.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CallAnnotation: A piece of metadata that
// applies to a window of a call.
type GoogleCloudContactcenterinsightsV1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Conversation: The conversation resource.
type GoogleCloudContactcenterinsightsV1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium, if unspecified will default to
	// PHONE_CALL.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telphony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCallMetadata: Call-specific
// metadata.
type GoogleCloudContactcenterinsightsV1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataSource: The conversation
// source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSentiment: One channel of
// conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadata: Conversation
// metadata related to quality management.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo:
// Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Team: A user-specified string representing the agent's team.
	Team string `json:"team,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData:
// Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment: A
// segment of a full transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDial
// ogflowSegmentMetadata: Metadata from Dialogflow relating to the current
// transcript segment.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWord
// Info: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata: Metadata
// for a create analysis operation.
type GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata: Metadata for
// creating an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelRequest: The request to
// create an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata: Metadata for
// deleting an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest: The request to
// delete an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata: Metadata for
// deploying an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelRequest: The request to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelResponse: The response to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest: The
// request to deploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DialogflowInteractionData: Dialogflow
// interaction data.
type GoogleCloudContactcenterinsightsV1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1DialogflowSource: A Dialogflow source of
// conversation data.
type GoogleCloudContactcenterinsightsV1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dimension: A dimension determines the
// grouping key for the query. In SQL terms, these would be part of both the
// "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata: Metadata
// about the agent dimension.
type GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata struct {
	// AgentDisplayName: Optional. The agent's name
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata: Metadata
// about the issue dimension.
type GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata:
//
//	Metadata about the QA question-answer dimension. This is useful for showing
//
// the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata:
// Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Entity: The data for an entity annotation.
// Represents a phrase in the conversation that is a known entity, such as a
// person, an organization, or location.
type GoogleCloudContactcenterinsightsV1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1EntityMentionData: The data for an entity
// mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExactMatchConfig: Exact match
// configuration.
type GoogleCloudContactcenterinsightsV1ExactMatchConfig struct {
	// CaseSensitive: Whether to consider case sensitivity when performing an exact
	// match.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExactMatchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExactMatchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata: Metadata for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest: The request to
// export insights.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestinatio
// n: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse: Response for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata: Metadata used
// for export issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequest: Request to export
// an issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination:
// Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelResponse: Response from
// export issue model
type GoogleCloudContactcenterinsightsV1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1FeedbackLabel: Represents a conversation,
// resource, and label provided by the user.
type GoogleCloudContactcenterinsightsV1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label.
	Label string `json:"label,omitempty"`
	// LabeledResource: Resource name of the resource to be labeled.
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1HoldData: The data for a hold annotation.
type GoogleCloudContactcenterinsightsV1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata: Metadata used
// for import issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequest: Request to import
// an issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource: Google
// Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelResponse: Response from
// import issue model
type GoogleCloudContactcenterinsightsV1ImportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadata: The metadata
// for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1IngestConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversati
// onsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequest: The request to
// ingest conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfi
// g: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource struct {
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Required. The Cloud Storage bucket containing source objects.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketObjectType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketObjectType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectC
// onfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsResponse: The response
// to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata: Metadata
// for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse: The
// response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1Intent: The data for an intent. Represents
// a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IntentMatchData: The data for an intent
// match. Represents an intent match for a text segment in the conversation. A
// text segment can be part of a sentence, a complete sentence, or an utterance
// with multiple sentences.
type GoogleCloudContactcenterinsightsV1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayDescription: Representative description of the issue.
	DisplayDescription string `json:"displayDescription,omitempty"`
	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Name string `json:"name,omitempty"`
	// SampleUtterances: Output only. Resource names of the sample representative
	// utterances that match to this issue.
	SampleUtterances []string `json:"sampleUtterances,omitempty"`
	// UpdateTime: Output only. The most recent time that this issue was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueAssignment: Information about the
// issue.
type GoogleCloudContactcenterinsightsV1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analyis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1IssueMatchData: The data for an issue
// match annotation.
type GoogleCloudContactcenterinsightsV1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModel: The issue model resource.
type GoogleCloudContactcenterinsightsV1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig: Configs for the
// input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats: Aggregated
// statistics about an issue.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelResult: Issue Modeling result on
// a conversation.
type GoogleCloudContactcenterinsightsV1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysesResponse: The response to list
// analyses.
type GoogleCloudContactcenterinsightsV1ListAnalysesResponse struct {
	// Analyses: The analyses that match the request.
	Analyses []*GoogleCloudContactcenterinsightsV1Analysis `json:"analyses,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Analyses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Analyses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse: The response of
// listing views.
type GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse struct {
	// AnalysisRules: The analysis_rule that match the request.
	AnalysisRules []*GoogleCloudContactcenterinsightsV1AnalysisRule `json:"analysisRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisRules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListConversationsResponse: The response of
// listing conversations.
type GoogleCloudContactcenterinsightsV1ListConversationsResponse struct {
	// Conversations: The conversations that match the request.
	Conversations []*GoogleCloudContactcenterinsightsV1Conversation `json:"conversations,omitempty"`
	// NextPageToken: A token which can be sent as `page_token` to retrieve the
	// next page. If this field is set, it means there is another page available.
	// If it is not set, it means no other pages are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse: The response
// for listing feedback labels.
type GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssueModelsResponse: The response of
// listing issue models.
type GoogleCloudContactcenterinsightsV1ListIssueModelsResponse struct {
	// IssueModels: The issue models that match the request.
	IssueModels []*GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssueModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssueModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssuesResponse: The response of
// listing issues.
type GoogleCloudContactcenterinsightsV1ListIssuesResponse struct {
	// Issues: The issues that match the request.
	Issues []*GoogleCloudContactcenterinsightsV1Issue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Issues") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse: The response
// of listing phrase matchers.
type GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PhraseMatchers: The phrase matchers that match the request.
	PhraseMatchers []*GoogleCloudContactcenterinsightsV1PhraseMatcher `json:"phraseMatchers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse: The response from
// a ListQaQuestions request.
type GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaQuestions: The QaQuestions under the parent.
	QaQuestions []*GoogleCloudContactcenterinsightsV1QaQuestion `json:"qaQuestions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse: The
// response from a ListQaScorecardRevisions request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecardRevisions: The QaScorecards under the parent.
	QaScorecardRevisions []*GoogleCloudContactcenterinsightsV1QaScorecardRevision `json:"qaScorecardRevisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse: The response
// from a ListQaScorecards request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecards: The QaScorecards under the parent.
	QaScorecards []*GoogleCloudContactcenterinsightsV1QaScorecard `json:"qaScorecards,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListViewsResponse: The response of listing
// views.
type GoogleCloudContactcenterinsightsV1ListViewsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Views: The views that match the request.
	Views []*GoogleCloudContactcenterinsightsV1View `json:"views,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchData: The data for a matched
// phrase matcher. Represents information identifying a phrase matcher for a
// given match.
type GoogleCloudContactcenterinsightsV1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRule: The data for a phrase
// match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRule struct {
	// Config: Provides additional information about the rule that specifies how to
	// apply the rule.
	Config *GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig `json:"config,omitempty"`
	// Negated: Specifies whether the phrase must be missing from the transcript
	// segment or present in the transcript segment.
	Negated bool `json:"negated,omitempty"`
	// Query: Required. The phrase to be matched.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig: Configuration
// information of a phrase match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig struct {
	// ExactMatchConfig: The configuration for the exact match rule.
	ExactMatchConfig *GoogleCloudContactcenterinsightsV1ExactMatchConfig `json:"exactMatchConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatchConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatchConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup: A message
// representing a rule in the phrase matcher.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup struct {
	// PhraseMatchRules: A list of phrase match rules that are included in this
	// group.
	PhraseMatchRules []*GoogleCloudContactcenterinsightsV1PhraseMatchRule `json:"phraseMatchRules,omitempty"`
	// Type: Required. The type of this phrase match rule group.
	//
	// Possible values:
	//   "PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rules or there is no match.
	//   "ANY_OF" - If any of the phrase match rules are met, there is a match.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhraseMatchRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhraseMatchRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatcher: The phrase matcher
// resource.
type GoogleCloudContactcenterinsightsV1PhraseMatcher struct {
	// ActivationUpdateTime: Output only. The most recent time at which the
	// activation status was updated.
	ActivationUpdateTime string `json:"activationUpdateTime,omitempty"`
	// Active: Applies the phrase matcher only when it is active.
	Active bool `json:"active,omitempty"`
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The resource name of the phrase matcher. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	Name string `json:"name,omitempty"`
	// PhraseMatchRuleGroups: A list of phase match rule groups that are included
	// in this matcher.
	PhraseMatchRuleGroups []*GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup `json:"phraseMatchRuleGroups,omitempty"`
	// RevisionCreateTime: Output only. The timestamp of when the revision was
	// created. It is also the create time when a new matcher is added.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. Immutable. The revision ID of the phrase matcher. A
	// new revision is committed whenever the matcher is changed, except when it is
	// activated or deactivated. A server generated random ID will be used.
	// Example: locations/global/phraseMatchers/my-first-matcher@1234567
	RevisionId string `json:"revisionId,omitempty"`
	// RoleMatch: The role whose utterances the phrase matcher should be matched
	// against. If the role is ROLE_UNSPECIFIED it will be matched against any
	// utterances in the transcript.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	RoleMatch string `json:"roleMatch,omitempty"`
	// Type: Required. The type of this phrase matcher.
	//
	// Possible values:
	//   "PHRASE_MATCHER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rule groups or there is no match.
	//   "ANY_OF" - If any of the phrase match rule groups are met, there is a
	// match.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The most recent time at which the phrase matcher
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionTag: The customized version tag to use for the phrase matcher. If not
	// specified, it will default to `revision_id`.
	VersionTag string `json:"versionTag,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActivationUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationUpdateTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1QaAnswer struct {
	// AnswerSources: List of all individual answers given to the question.
	AnswerSources []*GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The main answer value, incorporating any manual edits if they
	// exist.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource: A question may have
// multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue: Message for holding
// the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer
// values for a question.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestion: A single question to be scored
// by the Insights QA feature.
type GoogleCloudContactcenterinsightsV1QaQuestion struct {
	// Abbreviation: Short, descriptive string, used in the UI where it's not
	// practical to display the full question body. E.g., "Greeting".
	Abbreviation string `json:"abbreviation,omitempty"`
	// AnswerChoices: A list of valid answers to the question, which the LLM must
	// choose from.
	AnswerChoices []*GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice `json:"answerChoices,omitempty"`
	// AnswerInstructions: Instructions describing how to determine the answer.
	AnswerInstructions string `json:"answerInstructions,omitempty"`
	// CreateTime: Output only. The time at which this question was created.
	CreateTime string `json:"createTime,omitempty"`
	// Metrics: Metrics of the underlying tuned LLM over a holdout/test set while
	// fine tuning the underlying LLM for the given question. This field will only
	// be populated if and only if the question is part of a scorecard revision
	// that has been tuned.
	Metrics *GoogleCloudContactcenterinsightsV1QaQuestionMetrics `json:"metrics,omitempty"`
	// Name: Identifier. The resource name of the question. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}/qaQuestions/{qa_question}
	Name string `json:"name,omitempty"`
	// Order: Defines the order of the question within its parent scorecard
	// revision.
	Order int64 `json:"order,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags for the question. Used for
	// grouping/organization and for weighting the score of each question.
	Tags []string `json:"tags,omitempty"`
	// TuningMetadata: Metadata about the tuning operation for the question.This
	// field will only be populated if and only if the question is part of a
	// scorecard revision that has been tuned.
	TuningMetadata *GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata `json:"tuningMetadata,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Abbreviation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abbreviation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice: Message
// representing a possible answer to the question.
type GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations.
	NaValue bool `json:"naValue,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// Score: Numerical score of the answer, used for generating the overall score
	// of a QaScorecardResult. If the answer uses na_value, this field is unused.
	Score float64 `json:"score,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	var s1 struct {
		NumValue gensupport.JSONFloat64 `json:"numValue"`
		Score    gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumValue = float64(s1.NumValue)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionMetrics: A wrapper representing
// metrics calculated against a test-set on a LLM that was fine tuned for this
// question.
type GoogleCloudContactcenterinsightsV1QaQuestionMetrics struct {
	// Accuracy: Output only. Accuracy of the model. Measures the percentage of
	// correct answers the model gave on the test set.
	Accuracy float64 `json:"accuracy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accuracy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accuracy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	var s1 struct {
		Accuracy gensupport.JSONFloat64 `json:"accuracy"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Accuracy = float64(s1.Accuracy)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata: Metadata about
// the tuning operation for the question. Will only be set if a scorecard
// containing this question has been tuned.
type GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata struct {
	// DatasetValidationWarnings: A list of any applicable data validation warnings
	// about the question's feedback labels.
	//
	// Possible values:
	//   "DATASET_VALIDATION_WARNING_UNSPECIFIED" - Unspecified data validation
	// warning.
	//   "TOO_MANY_INVALID_FEEDBACK_LABELS" - A non-trivial percentage of the
	// feedback labels are invalid.
	//   "INSUFFICIENT_FEEDBACK_LABELS" - The quantity of valid feedback labels
	// provided is less than the recommended minimum.
	//   "INSUFFICIENT_FEEDBACK_LABELS_PER_ANSWER" - One or more of the answers
	// have less than the recommended minimum of feedback labels.
	//   "ALL_FEEDBACK_LABELS_HAVE_THE_SAME_ANSWER" - All the labels in the dataset
	// come from a single answer choice.
	DatasetValidationWarnings []string `json:"datasetValidationWarnings,omitempty"`
	// TotalValidLabelCount: Total number of valid labels provided for the question
	// at the time of tuining.
	TotalValidLabelCount int64 `json:"totalValidLabelCount,omitempty,string"`
	// TuningError: Error status of the tuning operation for the question. Will
	// only be set if the tuning operation failed.
	TuningError string `json:"tuningError,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetValidationWarnings")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetValidationWarnings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecard: A QaScorecard represents a
// collection of questions to be scored during analysis.
type GoogleCloudContactcenterinsightsV1QaScorecard struct {
	// CreateTime: Output only. The time at which this scorecard was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A text description explaining the intent of the scorecard.
	Description string `json:"description,omitempty"`
	// DisplayName: The user-specified display name of the scorecard.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The scorecard name. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the scorecard was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecardResult: The results of scoring
// a single conversation against a QaScorecard. Contains a collection of
// QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult: Tags and
// their corresponding results.
type GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource: A scorecard
// result may have multiple sets of scores from varying sources, one of which
// becomes the "main" answer above. A ScoreSource represents each individual
// set of scores.
type GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardRevision: A revision of a
// QaScorecard. Modifying published scorecard fields would invalidate existing
// scorecard results — the questions may have changed, or the score weighting
// will make existing scores impossible to understand. So changes must create a
// new revision, rather than modifying the existing resource.
type GoogleCloudContactcenterinsightsV1QaScorecardRevision struct {
	// AlternateIds: Output only. Alternative IDs for this revision of the
	// scorecard, e.g., `latest`.
	AlternateIds []string `json:"alternateIds,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard revision. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}
	Name string `json:"name,omitempty"`
	// Snapshot: The snapshot of the scorecard at the time of this revision's
	// creation.
	Snapshot *GoogleCloudContactcenterinsightsV1QaScorecard `json:"snapshot,omitempty"`
	// State: Output only. State of the scorecard revision, indicating whether it's
	// ready to be used in analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "EDITABLE" - The scorecard revision can be edited.
	//   "TRAINING" - Scorecard model training is in progress.
	//   "TRAINING_FAILED" - Scorecard revision model training failed.
	//   "READY" - The revision can be used in analysis.
	//   "DELETING" - Scorecard is being deleted.
	//   "TRAINING_CANCELLED" - Scorecard model training was explicitly cancelled
	// by the user.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsMetadata: The metadata from
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsMetadata struct {
}

// GoogleCloudContactcenterinsightsV1QueryMetricsRequest: The request for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsRequest struct {
	// Dimensions: The dimensions that determine the grouping key for the query.
	// Defaults to no dimension if this field is unspecified. If a dimension is
	// specified, its key must also be specified. Each dimension's key must be
	// unique. If a time granularity is also specified, metric values in the
	// dimension will be bucketed by this granularity. Up to one dimension is
	// supported for now.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// Filter: Required. Filter to select a subset of conversations to compute the
	// metrics. Must specify a window of the conversation create time to compute
	// the metrics. The returned metrics will be from the range [DATE(starting
	// create time), DATE(ending create time)).
	Filter string `json:"filter,omitempty"`
	// MeasureMask: Measures to return. Defaults to all measures if this field is
	// unspecified. A valid mask should traverse from the `measure` field from the
	// response. For example, a path from a measure mask to get the conversation
	// count is "conversation_measure.count".
	MeasureMask string `json:"measureMask,omitempty"`
	// TimeGranularity: The time granularity of each data point in the time series.
	// Defaults to NONE if this field is unspecified.
	//
	// Possible values:
	//   "TIME_GRANULARITY_UNSPECIFIED" - The time granularity is unspecified and
	// will default to NONE.
	//   "NONE" - No time granularity. The response won't contain a time series.
	// This is the default value if no time granularity is specified.
	//   "DAILY" - Data points in the time series will aggregate at a daily
	// granularity. 1 day means [midnight to midnight).
	//   "HOURLY" - Data points in the time series will aggregate at a daily
	// granularity. 1 HOUR means [01:00 to 02:00).
	//   "PER_MINUTE" - Data points in the time series will aggregate at a daily
	// granularity. PER_MINUTE means [01:00 to 01:01).
	//   "PER_5_MINUTES" - Data points in the time series will aggregate at a 1
	// minute granularity. PER_5_MINUTES means [01:00 to 01:05).
	//   "MONTHLY" - Data points in the time series will aggregate at a monthly
	// granularity. 1 MONTH means [01st of the month to 1st of the next month).
	TimeGranularity string `json:"timeGranularity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponse: The response for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across the selected dimension. i.e. if group_by agent is specified this
	// field will contain the average across all agents. This field is only
	// populated if the request specifies a Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint: A data
// point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: Average QA normalized score. Will exclude 0's in
	// average calculation.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageAgentSentimentScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageAgentSentimentScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AverageAgentSentimentScore        gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore       gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore          gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore  gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage          gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageTurnCount                  gensupport.JSONFloat64 `json:"averageTurnCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries: A
// time series of metric values.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RedactionConfig: DLP resources used for
// redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotation: An annotation that was
// generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput: Explicit input
// used for generating the answer
type GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SentimentData: The data for a sentiment
// annotation.
type GoogleCloudContactcenterinsightsV1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// abolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1Settings: The CCAI Insights project wide
// settings. Use these settings to configure the behavior of Insights. View
// these settings with `getsettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings)
// and change the settings with `updateSettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
type GoogleCloudContactcenterinsightsV1Settings struct {
	// AnalysisConfig: Default analysis settings.
	AnalysisConfig *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig `json:"analysisConfig,omitempty"`
	// ConversationTtl: The default TTL for newly-created conversations. If a
	// conversation has a specified expiration, that value will be used instead.
	// Changing this value will not change the expiration of existing
	// conversations. Conversations with no expire time persist until they are
	// deleted.
	ConversationTtl string `json:"conversationTtl,omitempty"`
	// CreateTime: Output only. The time at which the settings was created.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: A language code to be applied to each transcript segment
	// unless the segment already specifies a language code. Language code defaults
	// to "en-US" if it is neither specified on the segment nor here.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Immutable. The resource name of the settings resource. Format:
	// projects/{project}/locations/{location}/settings
	Name string `json:"name,omitempty"`
	// PubsubNotificationSettings: A map that maps a notification trigger to a
	// Pub/Sub topic. Each time a specified trigger occurs, Insights will notify
	// the corresponding Pub/Sub topic. Keys are notification triggers. Supported
	// keys are: * "all-triggers": Notify each time any of the supported triggers
	// occurs. * "create-analysis": Notify each time an analysis is created. *
	// "create-conversation": Notify each time a conversation is created. *
	// "export-insights-data": Notify each time an export is complete. *
	// "ingest-conversations": Notify each time an IngestConversations LRO is
	// complete. * "update-conversation": Notify each time a conversation is
	// updated via UpdateConversation. * "upload-conversation": Notify when an
	// UploadConversation LRO is complete. Values are Pub/Sub topics. The format of
	// each Pub/Sub topic is: projects/{project}/topics/{topic}
	PubsubNotificationSettings map[string]string `json:"pubsubNotificationSettings,omitempty"`
	// RedactionConfig: Default DLP redaction resources to be applied while
	// ingesting conversations. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text resources to use while
	// ingesting audio files. Optional, CCAI Insights will create a default if not
	// provided. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// UpdateTime: Output only. The time at which the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Settings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig: Default
// configuration when creating Analyses in Insights.
type GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig struct {
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// RuntimeIntegrationAnalysisPercentage: Percentage of conversations created
	// using Dialogflow runtime integration to analyze automatically, between [0,
	// 100].
	RuntimeIntegrationAnalysisPercentage float64 `json:"runtimeIntegrationAnalysisPercentage,omitempty"`
	// UploadConversationAnalysisPercentage: Percentage of conversations created
	// using the UploadConversation endpoint to analyze automatically, between [0,
	// 100].
	UploadConversationAnalysisPercentage float64 `json:"uploadConversationAnalysisPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	var s1 struct {
		RuntimeIntegrationAnalysisPercentage gensupport.JSONFloat64 `json:"runtimeIntegrationAnalysisPercentage"`
		UploadConversationAnalysisPercentage gensupport.JSONFloat64 `json:"uploadConversationAnalysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RuntimeIntegrationAnalysisPercentage = float64(s1.RuntimeIntegrationAnalysisPercentage)
	s.UploadConversationAnalysisPercentage = float64(s1.UploadConversationAnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData: Agent Assist
// Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SmartReplyData: Agent Assist Smart Reply
// data.
type GoogleCloudContactcenterinsightsV1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1SpeechConfig struct {
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeechRecognizer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeechRecognizer") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest: Request
// for TuneQaScorecardRevision endpoint.
type GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest struct {
	// Filter: Required. Filter for selecting the feedback labels that needs to be
	// used for training. This filter can be used to limit the feedback labels used
	// for tuning to a feedback labels created or updated for a specific
	// time-window etc.
	Filter string `json:"filter,omitempty"`
	// ValidateOnly: Optional. Run in validate only mode, no fine tuning will
	// actually run. Data quality validations like training data distributions will
	// run. Even when set to false, the data quality validations will still run but
	// once the validations complete we will proceed with the fine tune, if
	// applicable.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata: Metadata for
// undeploying an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest: The request to
// undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse: The response
// to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest: The
// request to undeploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1UploadConversationMetadata: The metadata
// for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UploadConversationRequest: Request to
// upload a conversation.
type GoogleCloudContactcenterinsightsV1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1View: The View resource.
type GoogleCloudContactcenterinsightsV1View struct {
	// CreateTime: Output only. The time at which this view was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The human-readable display name of the view.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the view. Format:
	// projects/{project}/locations/{location}/views/{view}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the view was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Value: String with specific view properties, must be non-empty.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1View) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1View
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1alpha1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1alpha1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResult: The result of an
// analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1alpha1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1alpha1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1alpha1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1alpha1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig:
// Configuration for the QA feature.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardLis
// t: Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig:
//
//	Configuration for summarization.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback: The feedback that
// the customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata:
// The metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse:
// The response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1CallAnnotation: A piece of metadata
// that applies to a window of a call.
type GoogleCloudContactcenterinsightsV1alpha1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1alpha1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1alpha1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1alpha1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1alpha1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1alpha1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1alpha1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Conversation: The conversation
// resource.
type GoogleCloudContactcenterinsightsV1alpha1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1alpha1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium, if unspecified will default to
	// PHONE_CALL.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telphony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata:
// Call-specific metadata.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource: The
// conversation source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1alpha1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment: One
// channel of conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata:
// Conversation metadata related to quality management.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo:
//
//	Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Team: A user-specified string representing the agent's team.
	Team string `json:"team,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionDa
// ta: Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// nt: A segment of a full transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntDialogflowSegmentMetadata: Metadata from Dialogflow relating to the
// current transcript segment.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntWordInfo: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata:
// Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata: Metadata
// for creating an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest: The request
// to create an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata: Metadata
// for deleting an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest: The request
// to delete an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata: Metadata
// for deploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest: The request
// to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse: The
// response to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData:
// Dialogflow interaction data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowSource: A Dialogflow
// source of conversation data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Dimension: A dimension determines
// the grouping key for the query. In SQL terms, these would be part of both
// the "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1alpha1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata:
// Metadata about the agent dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata struct {
	// AgentDisplayName: Optional. The agent's name
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata:
// Metadata about the issue dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMet
// adata: Metadata about the QA question-answer dimension. This is useful for
// showing the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata:
//
//	Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Entity: The data for an entity
// annotation. Represents a phrase in the conversation that is a known entity,
// such as a person, an organization, or location.
type GoogleCloudContactcenterinsightsV1alpha1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1EntityMentionData: The data for an
// entity mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1alpha1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata: Metadata
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest: The
// request to export insights.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDest
// ination: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse: Response
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata: Metadata
// used for export issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest: Request to
// export an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
// : Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse: Response
// from export issue model
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel: Represents a
// conversation, resource, and label provided by the user.
type GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label.
	Label string `json:"label,omitempty"`
	// LabeledResource: Resource name of the resource to be labeled.
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1alpha1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1HoldData: The data for a hold
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata: Metadata
// used for import issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest: Request to
// import an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource:
// Google Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse: Response
// from import issue model
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata: The
// metadata for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConv
// ersationsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest: The
// request to ingest conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversatio
// nConfig: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource struct {
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Required. The Cloud Storage bucket containing source objects.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketObjectType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketObjectType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptO
// bjectConfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse: The
// response to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata:
// Metadata for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse:
// The response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1Intent: The data for an intent.
// Represents a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IntentMatchData: The data for an
// intent match. Represents an intent match for a text segment in the
// conversation. A text segment can be part of a sentence, a complete sentence,
// or an utterance with multiple sentences.
type GoogleCloudContactcenterinsightsV1alpha1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1alpha1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1IssueAssignment: Information about
// the issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analyis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1IssueMatchData: The data for an
// issue match annotation.
type GoogleCloudContactcenterinsightsV1alpha1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModel: The issue model
// resource.
type GoogleCloudContactcenterinsightsV1alpha1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig: Configs
// for the input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats:
// Aggregated statistics about an issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelResult: Issue Modeling
// result on a conversation.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse: The
// response for listing feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData: The data for a
// matched phrase matcher. Represents information identifying a phrase matcher
// for a given match.
type GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswer struct {
	// AnswerSources: List of all individual answers given to the question.
	AnswerSources []*GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The main answer value, incorporating any manual edits if they
	// exist.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource: A question may
// have multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue: Message for
// holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the
// possible answer values for a question.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult: The results of
// scoring a single conversation against a QaScorecard. Contains a collection
// of QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1alpha1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult: Tags
// and their corresponding results.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource: A
// scorecard result may have multiple sets of scores from varying sources, one
// of which becomes the "main" answer above. A ScoreSource represents each
// individual set of scores.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata: The metadata
// from querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata struct {
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse: The response
// for querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across the selected dimension. i.e. if group_by agent is specified this
	// field will contain the average across all agents. This field is only
	// populated if the request specifies a Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1alpha1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint:
// A data point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: Average QA normalized score. Will exclude 0's in
	// average calculation.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageAgentSentimentScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageAgentSentimentScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AverageAgentSentimentScore        gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore       gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore          gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore  gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage          gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageTurnCount                  gensupport.JSONFloat64 `json:"averageTurnCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries:
// A time series of metric values.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RedactionConfig: DLP resources used
// for redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1alpha1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation: An annotation
// that was generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput: Explicit
// input used for generating the answer
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SentimentData: The data for a
// sentiment annotation.
type GoogleCloudContactcenterinsightsV1alpha1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// abolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData: Agent
// Assist Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SmartReplyData: Agent Assist Smart
// Reply data.
type GoogleCloudContactcenterinsightsV1alpha1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1alpha1SpeechConfig struct {
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeechRecognizer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeechRecognizer") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata: Metadata
// for undeploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest: The
// request to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse: The
// response to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata: The
// metadata for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest: Request
// to upload a conversation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1alpha1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeInterval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type GoogleTypeInterval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsBulkDownloadFeedbackLabelsCall struct {
	s                                                                   *Service
	parent                                                              string
	googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest
	urlParams_                                                          gensupport.URLParams
	ctx_                                                                context.Context
	header_                                                             http.Header
}

// BulkDownloadFeedbackLabels: Download feedback labels in bulk.
//
// - parent: The parent resource for new feedback labels.
func (r *ProjectsLocationsService) BulkDownloadFeedbackLabels(parent string, googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c := &ProjectsLocationsBulkDownloadFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest = googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:bulkDownloadFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.bulkDownloadFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsBulkUploadFeedbackLabelsCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkUploadFeedbackLabels: Upload feedback labels in bulk.
//
// - parent: The parent resource for new feedback labels.
func (r *ProjectsLocationsService) BulkUploadFeedbackLabels(parent string, googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c := &ProjectsLocationsBulkUploadFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest = googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:bulkUploadFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.bulkUploadFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsGetEncryptionSpecCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEncryptionSpec: Gets location-level encryption key specification.
//
// - name: The name of the encryption spec resource to get.
func (r *ProjectsLocationsService) GetEncryptionSpec(name string) *ProjectsLocationsGetEncryptionSpecCall {
	c := &ProjectsLocationsGetEncryptionSpecCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetEncryptionSpecCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetEncryptionSpecCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetEncryptionSpecCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetEncryptionSpecCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetEncryptionSpecCall) Context(ctx context.Context) *ProjectsLocationsGetEncryptionSpecCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetEncryptionSpecCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetEncryptionSpecCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.getEncryptionSpec" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1EncryptionSpec.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetEncryptionSpecCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1EncryptionSpec, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1EncryptionSpec{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets project-level settings.
//
// - name: The name of the settings resource to get.
func (r *ProjectsLocationsService) GetSettings(name string) *ProjectsLocationsGetSettingsCall {
	c := &ProjectsLocationsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetSettingsCall) Context(ctx context.Context) *ProjectsLocationsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsListAllFeedbackLabelsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListAllFeedbackLabels: List all feedback labels by project number.
//
// - parent: The parent resource of all feedback labels per project.
func (r *ProjectsLocationsService) ListAllFeedbackLabels(parent string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c := &ProjectsLocationsListAllFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset in the entire project. Supports disjunctions (OR) and
// conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id`
// * `min_create_time` * `max_create_time` * `min_update_time` *
// `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Filter(filter string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// feedback labels to return in the response. A valid page size ranges from 0
// to 100,000 inclusive. If the page size is zero or unspecified, a default
// page size of 100 will be chosen. Note that a call might return fewer results
// than the requested page size.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) PageSize(pageSize int64) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAllFeedbackLabelsResponse`. This value indicates that this is a
// continuation of a prior `ListAllFeedbackLabels` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) PageToken(pageToken string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) IfNoneMatch(entityTag string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListAllFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:listAllFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.listAllFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQueryMetricsCall struct {
	s                                                     *Service
	location                                              string
	googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// QueryMetrics: Query metrics.
//
//   - location: The location of the data.
//     "projects/{project}/locations/{location}".
func (r *ProjectsLocationsService) QueryMetrics(location string, googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest) *ProjectsLocationsQueryMetricsCall {
	c := &ProjectsLocationsQueryMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudcontactcenterinsightsv1querymetricsrequest = googlecloudcontactcenterinsightsv1querymetricsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQueryMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsQueryMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQueryMetricsCall) Context(ctx context.Context) *ProjectsLocationsQueryMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQueryMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQueryMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1querymetricsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:queryMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.queryMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQueryMetricsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsUpdateSettingsCall struct {
	s                                          *Service
	name                                       string
	googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// UpdateSettings: Updates project-level settings.
//
//   - name: Immutable. The resource name of the settings resource. Format:
//     projects/{project}/locations/{location}/settings.
func (r *ProjectsLocationsService) UpdateSettings(name string, googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings) *ProjectsLocationsUpdateSettingsCall {
	c := &ProjectsLocationsUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1settings = googlecloudcontactcenterinsightsv1settings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *ProjectsLocationsUpdateSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUpdateSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUpdateSettingsCall) Context(ctx context.Context) *ProjectsLocationsUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1settings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.updateSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsAnalysisRulesCreateCall struct {
	s                                              *Service
	parent                                         string
	googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a analysis rule.
//
//   - parent: The parent resource of the analysis rule. Required. The location
//     to create a analysis rule for. Format: `projects//locations/` or
//     `projects//locations/`.
func (r *ProjectsLocationsAnalysisRulesService) Create(parent string, googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule) *ProjectsLocationsAnalysisRulesCreateCall {
	c := &ProjectsLocationsAnalysisRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1analysisrule = googlecloudcontactcenterinsightsv1analysisrule
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1analysisrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analysisRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsAnalysisRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a analysis rule.
//
// - name: The name of the analysis rule to delete.
func (r *ProjectsLocationsAnalysisRulesService) Delete(name string) *ProjectsLocationsAnalysisRulesDeleteCall {
	c := &ProjectsLocationsAnalysisRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsAnalysisRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a analysis rule.
//
// - name: The name of the AnalysisRule to get.
func (r *ProjectsLocationsAnalysisRulesService) Get(name string) *ProjectsLocationsAnalysisRulesGetCall {
	c := &ProjectsLocationsAnalysisRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAnalysisRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAnalysisRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesGetCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsAnalysisRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists analysis rules.
//
// - parent: The parent resource of the analysis rules.
func (r *ProjectsLocationsAnalysisRulesService) List(parent string) *ProjectsLocationsAnalysisRulesListCall {
	c := &ProjectsLocationsAnalysisRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// analysis rule to return in the response. If this value is zero, the service
// will select a default size. A call may return fewer objects than requested.
// A non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsAnalysisRulesListCall) PageSize(pageSize int64) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAnalysisRulesResponse`; indicates that this is a continuation of a
// prior `ListAnalysisRules` call and the system should return the next page of
// data.
func (c *ProjectsLocationsAnalysisRulesListCall) PageToken(pageToken string) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAnalysisRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAnalysisRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesListCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analysisRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAnalysisRulesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAnalysisRulesPatchCall struct {
	s                                              *Service
	name                                           string
	googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a analysis rule.
//
//   - name: Identifier. The resource name of the analysis rule. Format:
//     projects/{project}/locations/{location}/analysisRules/{analysis_rule}.
func (r *ProjectsLocationsAnalysisRulesService) Patch(name string, googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule) *ProjectsLocationsAnalysisRulesPatchCall {
	c := &ProjectsLocationsAnalysisRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1analysisrule = googlecloudcontactcenterinsightsv1analysisrule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. If the update_mask is not provided, the update will be applied
// to all fields.
func (c *ProjectsLocationsAnalysisRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAnalysisRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1analysisrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsBulkAnalyzeCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkAnalyze: Analyzes multiple conversations in a single request.
//
// - parent: The parent resource to create analyses in.
func (r *ProjectsLocationsConversationsService) BulkAnalyze(parent string, googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c := &ProjectsLocationsConversationsBulkAnalyzeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest = googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Context(ctx context.Context) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsBulkAnalyzeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:bulkAnalyze")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.bulkAnalyze" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsBulkDeleteCall struct {
	s                                                                *Service
	parent                                                           string
	googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// BulkDelete: Deletes multiple conversations in a single request.
//
//   - parent: The parent resource to delete conversations from. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsConversationsService) BulkDelete(parent string, googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest) *ProjectsLocationsConversationsBulkDeleteCall {
	c := &ProjectsLocationsConversationsBulkDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest = googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsBulkDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsBulkDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsBulkDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:bulkDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.bulkDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsCalculateStatsCall struct {
	s            *Service
	location     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateStats: Gets conversation statistics.
//
// - location: The location of the conversations.
func (r *ProjectsLocationsConversationsService) CalculateStats(location string) *ProjectsLocationsConversationsCalculateStatsCall {
	c := &ProjectsLocationsConversationsCalculateStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. This field is useful for getting statistics about
// conversations with specific properties.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Filter(filter string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsCalculateStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Context(ctx context.Context) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCalculateStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}/conversations:calculateStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.calculateStats" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateStatsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsCreateCall struct {
	s                                              *Service
	parent                                         string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a conversation. Note that this method does not support audio
// transcription or redaction. Use `conversations.upload` instead.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) Create(parent string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsCreateCall {
	c := &ProjectsLocationsConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// ConversationId sets the optional parameter "conversationId": A unique ID for
// the new conversation. This ID will become the final component of the
// conversation's resource name. If no ID is specified, a server-generated ID
// will be used. This value should be 4-64 characters and must match the
// regular expression `^[a-z0-9-]{4,64}$`. Valid characters are `a-z-`
func (c *ProjectsLocationsConversationsCreateCall) ConversationId(conversationId string) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("conversationId", conversationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a conversation.
//
// - name: The name of the conversation to delete.
func (r *ProjectsLocationsConversationsService) Delete(name string) *ProjectsLocationsConversationsDeleteCall {
	c := &ProjectsLocationsConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// conversation's analyses will also be deleted. Otherwise, the request will
// only succeed if the conversation has no analyses.
func (c *ProjectsLocationsConversationsDeleteCall) Force(force bool) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a conversation.
//
// - name: The name of the conversation to get.
func (r *ProjectsLocationsConversationsService) Get(name string) *ProjectsLocationsConversationsGetCall {
	c := &ProjectsLocationsConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `FULL`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsConversationsGetCall) View(view string) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsIngestCall struct {
	s                                                            *Service
	parent                                                       string
	googlecloudcontactcenterinsightsv1ingestconversationsrequest *GoogleCloudContactcenterinsightsV1IngestConversationsRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// Ingest: Imports conversations and processes them according to the user's
// configuration.
//
// - parent: The parent resource for new conversations.
func (r *ProjectsLocationsConversationsService) Ingest(parent string, googlecloudcontactcenterinsightsv1ingestconversationsrequest *GoogleCloudContactcenterinsightsV1IngestConversationsRequest) *ProjectsLocationsConversationsIngestCall {
	c := &ProjectsLocationsConversationsIngestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1ingestconversationsrequest = googlecloudcontactcenterinsightsv1ingestconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsIngestCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsIngestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsIngestCall) Context(ctx context.Context) *ProjectsLocationsConversationsIngestCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsIngestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsIngestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1ingestconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:ingest")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.ingest" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsIngestCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists conversations.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) List(parent string) *ProjectsLocationsConversationsListCall {
	c := &ProjectsLocationsConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying conversations with specific properties.
func (c *ProjectsLocationsConversationsListCall) Filter(filter string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The attribute by which to
// order conversations in the response. If empty, conversations will be ordered
// by descending creation time. Supported values are one of the following: *
// create_time * customer_satisfaction_rating * duration * latest_analysis *
// start_time * turn_count The default sort order is ascending. To specify
// order, append `asc` or `desc` (`create_time desc`). For more details, see
// Google AIPs Ordering (https://google.aip.dev/132#ordering).
func (c *ProjectsLocationsConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// conversations to return in the response. A valid page size ranges from 0 to
// 100,000 inclusive. If the page size is zero or unspecified, a default page
// size of 100 will be chosen. Note that a call might return fewer results than
// the requested page size.
func (c *ProjectsLocationsConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListConversationsResponse`. This value indicates that this is a
// continuation of a prior `ListConversations` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsConversationsListCall) PageToken(pageToken string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `BASIC`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsConversationsListCall) View(view string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsListCall) Context(ctx context.Context) *ProjectsLocationsConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListConversationsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConversationsPatchCall struct {
	s                                              *Service
	name                                           string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a conversation.
//
//   - name: Immutable. The resource name of the conversation. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}.
func (r *ProjectsLocationsConversationsService) Patch(name string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsPatchCall {
	c := &ProjectsLocationsConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. All possible fields can be updated by passing `*`, or a subset
// of the following updateable fields can be provided: * `agent_id` *
// `language_code` * `labels` * `metadata` * `quality_metadata` *
// `call_metadata` * `start_time` * `expire_time` or `ttl` *
// `data_source.gcs_source.audio_uri` or
// `data_source.dialogflow_source.audio_uri`
func (c *ProjectsLocationsConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsUploadCall struct {
	s                                                           *Service
	parent                                                      string
	googlecloudcontactcenterinsightsv1uploadconversationrequest *GoogleCloudContactcenterinsightsV1UploadConversationRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Upload: Create a long-running conversation upload operation. This method
// differs from `CreateConversation` by allowing audio transcription and
// optional DLP redaction.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) Upload(parent string, googlecloudcontactcenterinsightsv1uploadconversationrequest *GoogleCloudContactcenterinsightsV1UploadConversationRequest) *ProjectsLocationsConversationsUploadCall {
	c := &ProjectsLocationsConversationsUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1uploadconversationrequest = googlecloudcontactcenterinsightsv1uploadconversationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsUploadCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsUploadCall) Context(ctx context.Context) *ProjectsLocationsConversationsUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1uploadconversationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:upload")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsUploadCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsAnalysesCreateCall struct {
	s                                          *Service
	parent                                     string
	googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates an analysis. The long running operation is done when the
// analysis has completed.
//
// - parent: The parent resource of the analysis.
func (r *ProjectsLocationsConversationsAnalysesService) Create(parent string, googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis) *ProjectsLocationsConversationsAnalysesCreateCall {
	c := &ProjectsLocationsConversationsAnalysesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1analysis = googlecloudcontactcenterinsightsv1analysis
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1analysis)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsAnalysesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsAnalysesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an analysis.
//
// - name: The name of the analysis to delete.
func (r *ProjectsLocationsConversationsAnalysesService) Delete(name string) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c := &ProjectsLocationsConversationsAnalysesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsAnalysesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsAnalysesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an analysis.
//
// - name: The name of the analysis to get.
func (r *ProjectsLocationsConversationsAnalysesService) Get(name string) *ProjectsLocationsConversationsAnalysesGetCall {
	c := &ProjectsLocationsConversationsAnalysesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsAnalysesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsAnalysesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Analysis.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsAnalysesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Analysis, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Analysis{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsAnalysesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists analyses.
//
// - parent: The parent resource of the analyses.
func (r *ProjectsLocationsConversationsAnalysesService) List(parent string) *ProjectsLocationsConversationsAnalysesListCall {
	c := &ProjectsLocationsConversationsAnalysesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying conversations with specific properties.
func (c *ProjectsLocationsConversationsAnalysesListCall) Filter(filter string) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// analyses to return in the response. If this value is zero, the service will
// select a default size. A call might return fewer objects than requested. A
// non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsConversationsAnalysesListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAnalysesResponse`; indicates that this is a continuation of a
// prior `ListAnalyses` call and the system should return the next page of
// data.
func (c *ProjectsLocationsConversationsAnalysesListCall) PageToken(pageToken string) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsAnalysesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsAnalysesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsAnalysesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsAnalysesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsAnalysesListCall) Context(ctx context.Context) *ProjectsLocationsConversationsAnalysesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsAnalysesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsAnalysesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.analyses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAnalysesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsAnalysesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAnalysesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAnalysesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsAnalysesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAnalysesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConversationsFeedbackLabelsCreateCall struct {
	s                                               *Service
	parent                                          string
	googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Create: Create feedback label.
//
// - parent: The parent resource of the feedback label.
func (r *ProjectsLocationsConversationsFeedbackLabelsService) Create(parent string, googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel) *ProjectsLocationsConversationsFeedbackLabelsCreateCall {
	c := &ProjectsLocationsConversationsFeedbackLabelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1feedbacklabel = googlecloudcontactcenterinsightsv1feedbacklabel
	return c
}

// FeedbackLabelId sets the optional parameter "feedbackLabelId": The ID of the
// feedback label to create. If one is not specified it will be generated by
// the server.
func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) FeedbackLabelId(feedbackLabelId string) *ProjectsLocationsConversationsFeedbackLabelsCreateCall {
	c.urlParams_.Set("feedbackLabelId", feedbackLabelId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsFeedbackLabelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsFeedbackLabelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1feedbacklabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.feedbackLabels.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsFeedbackLabelsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsFeedbackLabelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete feedback label.
//
// - name: The name of the feedback label to delete.
func (r *ProjectsLocationsConversationsFeedbackLabelsService) Delete(name string) *ProjectsLocationsConversationsFeedbackLabelsDeleteCall {
	c := &ProjectsLocationsConversationsFeedbackLabelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsFeedbackLabelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsFeedbackLabelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsFeedbackLabelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsFeedbackLabelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsFeedbackLabelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsFeedbackLabelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.feedbackLabels.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsFeedbackLabelsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsFeedbackLabelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get feedback label.
//
// - name: The name of the feedback label to get.
func (r *ProjectsLocationsConversationsFeedbackLabelsService) Get(name string) *ProjectsLocationsConversationsFeedbackLabelsGetCall {
	c := &ProjectsLocationsConversationsFeedbackLabelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsFeedbackLabelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsFeedbackLabelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsFeedbackLabelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.feedbackLabels.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsFeedbackLabelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsConversationsFeedbackLabelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List feedback labels.
//
// - parent: The parent resource of the feedback labels.
func (r *ProjectsLocationsConversationsFeedbackLabelsService) List(parent string) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c := &ProjectsLocationsConversationsFeedbackLabelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Supports disjunctions (OR) and conjunctions (AND).
// Automatically sorts by conversation ID. To sort by all feedback labels in a
// project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` *
// `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time`
// * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI,
// TOPIC_MODELING
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Filter(filter string) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// feedback labels to return in the response. A valid page size ranges from 0
// to 100,000 inclusive. If the page size is zero or unspecified, a default
// page size of 100 will be chosen. Note that a call might return fewer results
// than the requested page size.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListFeedbackLabelsResponse`. This value indicates that this is a
// continuation of a prior `ListFeedbackLabels` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) PageToken(pageToken string) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Context(ctx context.Context) *ProjectsLocationsConversationsFeedbackLabelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.feedbackLabels.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsFeedbackLabelsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConversationsFeedbackLabelsPatchCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Update feedback label.
//
//   - name: Immutable. Resource name of the FeedbackLabel. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}/feedba
//     ckLabels/{feedback_label}.
func (r *ProjectsLocationsConversationsFeedbackLabelsService) Patch(name string, googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel) *ProjectsLocationsConversationsFeedbackLabelsPatchCall {
	c := &ProjectsLocationsConversationsFeedbackLabelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1feedbacklabel = googlecloudcontactcenterinsightsv1feedbacklabel
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsConversationsFeedbackLabelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsFeedbackLabelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) Context(ctx context.Context) *ProjectsLocationsConversationsFeedbackLabelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1feedbacklabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.feedbackLabels.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsFeedbackLabelsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsEncryptionSpecInitializeCall struct {
	s                                                                 *Service
	name                                                              string
	googlecloudcontactcenterinsightsv1initializeencryptionspecrequest *GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// Initialize: Initializes a location-level encryption key specification. An
// error will result if the location has resources already created before the
// initialization. After the encryption specification is initialized at a
// location, it is immutable and all newly created resources under the location
// will be encrypted with the existing specification.
//
//   - name: Immutable. The resource name of the encryption key specification
//     resource. Format: projects/{project}/locations/{location}/encryptionSpec.
func (r *ProjectsLocationsEncryptionSpecService) Initialize(name string, googlecloudcontactcenterinsightsv1initializeencryptionspecrequest *GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest) *ProjectsLocationsEncryptionSpecInitializeCall {
	c := &ProjectsLocationsEncryptionSpecInitializeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1initializeencryptionspecrequest = googlecloudcontactcenterinsightsv1initializeencryptionspecrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsEncryptionSpecInitializeCall) Fields(s ...googleapi.Field) *ProjectsLocationsEncryptionSpecInitializeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsEncryptionSpecInitializeCall) Context(ctx context.Context) *ProjectsLocationsEncryptionSpecInitializeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsEncryptionSpecInitializeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEncryptionSpecInitializeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1initializeencryptionspecrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:initialize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.encryptionSpec.initialize" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsEncryptionSpecInitializeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsInsightsdataExportCall struct {
	s                                                           *Service
	parent                                                      string
	googlecloudcontactcenterinsightsv1exportinsightsdatarequest *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Export: Export insights data to a destination defined in the request body.
//
// - parent: The parent resource to export data from.
func (r *ProjectsLocationsInsightsdataService) Export(parent string, googlecloudcontactcenterinsightsv1exportinsightsdatarequest *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) *ProjectsLocationsInsightsdataExportCall {
	c := &ProjectsLocationsInsightsdataExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1exportinsightsdatarequest = googlecloudcontactcenterinsightsv1exportinsightsdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsInsightsdataExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsInsightsdataExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsInsightsdataExportCall) Context(ctx context.Context) *ProjectsLocationsInsightsdataExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsInsightsdataExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsInsightsdataExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1exportinsightsdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/insightsdata:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.insightsdata.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsInsightsdataExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsCalculateIssueModelStatsCall struct {
	s            *Service
	issueModel   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateIssueModelStats: Gets an issue model's statistics.
//
// - issueModel: The resource name of the issue model to query against.
func (r *ProjectsLocationsIssueModelsService) CalculateIssueModelStats(issueModel string) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c := &ProjectsLocationsIssueModelsCalculateIssueModelStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.issueModel = issueModel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+issueModel}:calculateIssueModelStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"issueModel": c.issueModel,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.calculateIssueModelStats" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsCalculateIssueModelStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsCreateCall struct {
	s                                            *Service
	parent                                       string
	googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Create: Creates an issue model.
//
// - parent: The parent resource of the issue model.
func (r *ProjectsLocationsIssueModelsService) Create(parent string, googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel) *ProjectsLocationsIssueModelsCreateCall {
	c := &ProjectsLocationsIssueModelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1issuemodel = googlecloudcontactcenterinsightsv1issuemodel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsCreateCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issuemodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issueModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an issue model.
//
// - name: The name of the issue model to delete.
func (r *ProjectsLocationsIssueModelsService) Delete(name string) *ProjectsLocationsIssueModelsDeleteCall {
	c := &ProjectsLocationsIssueModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsDeployCall struct {
	s                                                         *Service
	name                                                      string
	googlecloudcontactcenterinsightsv1deployissuemodelrequest *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Deploy: Deploys an issue model. Returns an error if a model is already
// deployed. An issue model can only be used in analysis after it has been
// deployed.
//
// - name: The issue model to deploy.
func (r *ProjectsLocationsIssueModelsService) Deploy(name string, googlecloudcontactcenterinsightsv1deployissuemodelrequest *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) *ProjectsLocationsIssueModelsDeployCall {
	c := &ProjectsLocationsIssueModelsDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1deployissuemodelrequest = googlecloudcontactcenterinsightsv1deployissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsDeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsDeployCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1deployissuemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.deploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsDeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsExportCall struct {
	s                                                         *Service
	name                                                      string
	googlecloudcontactcenterinsightsv1exportissuemodelrequest *GoogleCloudContactcenterinsightsV1ExportIssueModelRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Export: Exports an issue model to the provided destination.
//
// - name: The issue model to export.
func (r *ProjectsLocationsIssueModelsService) Export(name string, googlecloudcontactcenterinsightsv1exportissuemodelrequest *GoogleCloudContactcenterinsightsV1ExportIssueModelRequest) *ProjectsLocationsIssueModelsExportCall {
	c := &ProjectsLocationsIssueModelsExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1exportissuemodelrequest = googlecloudcontactcenterinsightsv1exportissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsExportCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1exportissuemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an issue model.
//
// - name: The name of the issue model to get.
func (r *ProjectsLocationsIssueModelsService) Get(name string) *ProjectsLocationsIssueModelsGetCall {
	c := &ProjectsLocationsIssueModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsIssueModelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsGetCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1IssueModel.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1IssueModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1IssueModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsImportCall struct {
	s                                                         *Service
	parent                                                    string
	googlecloudcontactcenterinsightsv1importissuemodelrequest *GoogleCloudContactcenterinsightsV1ImportIssueModelRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Import: Imports an issue model from a Cloud Storage bucket.
//
// - parent: The parent resource of the issue model.
func (r *ProjectsLocationsIssueModelsService) Import(parent string, googlecloudcontactcenterinsightsv1importissuemodelrequest *GoogleCloudContactcenterinsightsV1ImportIssueModelRequest) *ProjectsLocationsIssueModelsImportCall {
	c := &ProjectsLocationsIssueModelsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1importissuemodelrequest = googlecloudcontactcenterinsightsv1importissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsImportCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1importissuemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issueModels:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists issue models.
//
// - parent: The parent resource of the issue model.
func (r *ProjectsLocationsIssueModelsService) List(parent string) *ProjectsLocationsIssueModelsListCall {
	c := &ProjectsLocationsIssueModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsIssueModelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsListCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issueModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListIssueModelsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListIssueModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListIssueModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsPatchCall struct {
	s                                            *Service
	name                                         string
	googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Patch: Updates an issue model.
//
//   - name: Immutable. The resource name of the issue model. Format:
//     projects/{project}/locations/{location}/issueModels/{issue_model}.
func (r *ProjectsLocationsIssueModelsService) Patch(name string, googlecloudcontactcenterinsightsv1issuemodel *GoogleCloudContactcenterinsightsV1IssueModel) *ProjectsLocationsIssueModelsPatchCall {
	c := &ProjectsLocationsIssueModelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1issuemodel = googlecloudcontactcenterinsightsv1issuemodel
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsIssueModelsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsIssueModelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsPatchCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issuemodel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1IssueModel.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1IssueModel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1IssueModel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsUndeployCall struct {
	s                                                           *Service
	name                                                        string
	googlecloudcontactcenterinsightsv1undeployissuemodelrequest *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Undeploy: Undeploys an issue model. An issue model can not be used in
// analysis after it has been undeployed.
//
// - name: The issue model to undeploy.
func (r *ProjectsLocationsIssueModelsService) Undeploy(name string, googlecloudcontactcenterinsightsv1undeployissuemodelrequest *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) *ProjectsLocationsIssueModelsUndeployCall {
	c := &ProjectsLocationsIssueModelsUndeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1undeployissuemodelrequest = googlecloudcontactcenterinsightsv1undeployissuemodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsUndeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsUndeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsUndeployCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsUndeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsUndeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsUndeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1undeployissuemodelrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undeploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.undeploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsUndeployCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsIssuesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an issue.
//
// - name: The name of the issue to delete.
func (r *ProjectsLocationsIssueModelsIssuesService) Delete(name string) *ProjectsLocationsIssueModelsIssuesDeleteCall {
	c := &ProjectsLocationsIssueModelsIssuesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsIssuesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsIssuesDeleteCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsIssueModelsIssuesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsIssuesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an issue.
//
// - name: The name of the issue to get.
func (r *ProjectsLocationsIssueModelsIssuesService) Get(name string) *ProjectsLocationsIssueModelsIssuesGetCall {
	c := &ProjectsLocationsIssueModelsIssuesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Issue.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsIssuesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Issue, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Issue{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsIssuesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists issues.
//
// - parent: The parent resource of the issue.
func (r *ProjectsLocationsIssueModelsIssuesService) List(parent string) *ProjectsLocationsIssueModelsIssuesListCall {
	c := &ProjectsLocationsIssueModelsIssuesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsIssueModelsIssuesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsIssueModelsIssuesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/issues")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListIssuesResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsIssuesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListIssuesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListIssuesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsIssueModelsIssuesPatchCall struct {
	s                                       *Service
	name                                    string
	googlecloudcontactcenterinsightsv1issue *GoogleCloudContactcenterinsightsV1Issue
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates an issue.
//
//   - name: Immutable. The resource name of the issue. Format:
//     projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{i
//     ssue}.
func (r *ProjectsLocationsIssueModelsIssuesService) Patch(name string, googlecloudcontactcenterinsightsv1issue *GoogleCloudContactcenterinsightsV1Issue) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c := &ProjectsLocationsIssueModelsIssuesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1issue = googlecloudcontactcenterinsightsv1issue
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Context(ctx context.Context) *ProjectsLocationsIssueModelsIssuesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsIssueModelsIssuesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1issue)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.issueModels.issues.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Issue.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsIssueModelsIssuesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Issue, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Issue{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPhraseMatchersCreateCall struct {
	s                                               *Service
	parent                                          string
	googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Create: Creates a phrase matcher.
//
//   - parent: The parent resource of the phrase matcher. Required. The location
//     to create a phrase matcher for. Format: `projects//locations/` or
//     `projects//locations/`.
func (r *ProjectsLocationsPhraseMatchersService) Create(parent string, googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher) *ProjectsLocationsPhraseMatchersCreateCall {
	c := &ProjectsLocationsPhraseMatchersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1phrasematcher = googlecloudcontactcenterinsightsv1phrasematcher
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1phrasematcher)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/phraseMatchers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPhraseMatchersCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsPhraseMatchersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a phrase matcher.
//
// - name: The name of the phrase matcher to delete.
func (r *ProjectsLocationsPhraseMatchersService) Delete(name string) *ProjectsLocationsPhraseMatchersDeleteCall {
	c := &ProjectsLocationsPhraseMatchersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsPhraseMatchersDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsPhraseMatchersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a phrase matcher.
//
// - name: The name of the phrase matcher to get.
func (r *ProjectsLocationsPhraseMatchersService) Get(name string) *ProjectsLocationsPhraseMatchersGetCall {
	c := &ProjectsLocationsPhraseMatchersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPhraseMatchersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPhraseMatchersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPhraseMatchersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPhraseMatchersGetCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPhraseMatchersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPhraseMatchersGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsPhraseMatchersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists phrase matchers.
//
// - parent: The parent resource of the phrase matcher.
func (r *ProjectsLocationsPhraseMatchersService) List(parent string) *ProjectsLocationsPhraseMatchersListCall {
	c := &ProjectsLocationsPhraseMatchersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying phrase matchers with specific
// properties.
func (c *ProjectsLocationsPhraseMatchersListCall) Filter(filter string) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// phrase matchers to return in the response. If this value is zero, the
// service will select a default size. A call might return fewer objects than
// requested. A non-empty `next_page_token` in the response indicates that more
// data is available.
func (c *ProjectsLocationsPhraseMatchersListCall) PageSize(pageSize int64) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListPhraseMatchersResponse`. This value indicates that this is a
// continuation of a prior `ListPhraseMatchers` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsPhraseMatchersListCall) PageToken(pageToken string) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPhraseMatchersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPhraseMatchersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPhraseMatchersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPhraseMatchersListCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPhraseMatchersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/phraseMatchers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsPhraseMatchersListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPhraseMatchersListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPhraseMatchersPatchCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Updates a phrase matcher.
//
//   - name: The resource name of the phrase matcher. Format:
//     projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}.
func (r *ProjectsLocationsPhraseMatchersService) Patch(name string, googlecloudcontactcenterinsightsv1phrasematcher *GoogleCloudContactcenterinsightsV1PhraseMatcher) *ProjectsLocationsPhraseMatchersPatchCall {
	c := &ProjectsLocationsPhraseMatchersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1phrasematcher = googlecloudcontactcenterinsightsv1phrasematcher
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsPhraseMatchersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPhraseMatchersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPhraseMatchersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Context(ctx context.Context) *ProjectsLocationsPhraseMatchersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPhraseMatchersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1phrasematcher)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.phraseMatchers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1PhraseMatcher.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPhraseMatchersPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1PhraseMatcher, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1PhraseMatcher{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsCreateCall struct {
	s                                             *Service
	parent                                        string
	googlecloudcontactcenterinsightsv1qascorecard *GoogleCloudContactcenterinsightsV1QaScorecard
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Create a QaScorecard.
//
// - parent: The parent resource of the QaScorecard.
func (r *ProjectsLocationsQaScorecardsService) Create(parent string, googlecloudcontactcenterinsightsv1qascorecard *GoogleCloudContactcenterinsightsV1QaScorecard) *ProjectsLocationsQaScorecardsCreateCall {
	c := &ProjectsLocationsQaScorecardsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1qascorecard = googlecloudcontactcenterinsightsv1qascorecard
	return c
}

// QaScorecardId sets the optional parameter "qaScorecardId": A unique ID for
// the new QaScorecard. This ID will become the final component of the
// QaScorecard's resource name. If no ID is specified, a server-generated ID
// will be used. This value should be 4-64 characters and must match the
// regular expression `^[a-z0-9-]{4,64}$`. Valid characters are `a-z-`.
func (c *ProjectsLocationsQaScorecardsCreateCall) QaScorecardId(qaScorecardId string) *ProjectsLocationsQaScorecardsCreateCall {
	c.urlParams_.Set("qaScorecardId", qaScorecardId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsCreateCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1qascorecard)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/qaScorecards")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecard.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecard, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecard{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a QaScorecard.
//
// - name: The name of the QaScorecard to delete.
func (r *ProjectsLocationsQaScorecardsService) Delete(name string) *ProjectsLocationsQaScorecardsDeleteCall {
	c := &ProjectsLocationsQaScorecardsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// QaScorecard's child resources will also be deleted. Otherwise, the request
// will only succeed if it has none.
func (c *ProjectsLocationsQaScorecardsDeleteCall) Force(force bool) *ProjectsLocationsQaScorecardsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsDeleteCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsQaScorecardsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a QaScorecard.
//
// - name: The name of the QaScorecard to get.
func (r *ProjectsLocationsQaScorecardsService) Get(name string) *ProjectsLocationsQaScorecardsGetCall {
	c := &ProjectsLocationsQaScorecardsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsGetCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecard.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecard, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecard{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists QaScorecards.
//
// - parent: The parent resource of the scorecards.
func (r *ProjectsLocationsQaScorecardsService) List(parent string) *ProjectsLocationsQaScorecardsListCall {
	c := &ProjectsLocationsQaScorecardsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// scorecards to return in the response. If the value is zero, the service will
// select a default size. A call might return fewer objects than requested. A
// non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsQaScorecardsListCall) PageSize(pageSize int64) *ProjectsLocationsQaScorecardsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListQaScorecardsResponse`. This value indicates that this is a
// continuation of a prior `ListQaScorecards` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsQaScorecardsListCall) PageToken(pageToken string) *ProjectsLocationsQaScorecardsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsListCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/qaScorecards")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsQaScorecardsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQaScorecardsPatchCall struct {
	s                                             *Service
	name                                          string
	googlecloudcontactcenterinsightsv1qascorecard *GoogleCloudContactcenterinsightsV1QaScorecard
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates a QaScorecard.
//
//   - name: Identifier. The scorecard name. Format:
//     projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}.
func (r *ProjectsLocationsQaScorecardsService) Patch(name string, googlecloudcontactcenterinsightsv1qascorecard *GoogleCloudContactcenterinsightsV1QaScorecard) *ProjectsLocationsQaScorecardsPatchCall {
	c := &ProjectsLocationsQaScorecardsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1qascorecard = googlecloudcontactcenterinsightsv1qascorecard
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. All possible fields can be updated by passing `*`, or
// a subset of the following updateable fields can be provided: * `description`
// * `display_name`
func (c *ProjectsLocationsQaScorecardsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsQaScorecardsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsPatchCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1qascorecard)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecard.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecard, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecard{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsCreateCall struct {
	s                                                     *Service
	parent                                                string
	googlecloudcontactcenterinsightsv1qascorecardrevision *GoogleCloudContactcenterinsightsV1QaScorecardRevision
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Create: Creates a QaScorecardRevision.
//
// - parent: The parent resource of the QaScorecardRevision.
func (r *ProjectsLocationsQaScorecardsRevisionsService) Create(parent string, googlecloudcontactcenterinsightsv1qascorecardrevision *GoogleCloudContactcenterinsightsV1QaScorecardRevision) *ProjectsLocationsQaScorecardsRevisionsCreateCall {
	c := &ProjectsLocationsQaScorecardsRevisionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1qascorecardrevision = googlecloudcontactcenterinsightsv1qascorecardrevision
	return c
}

// QaScorecardRevisionId sets the optional parameter "qaScorecardRevisionId": A
// unique ID for the new QaScorecardRevision. This ID will become the final
// component of the QaScorecardRevision's resource name. If no ID is specified,
// a server-generated ID will be used. This value should be 4-64 characters and
// must match the regular expression `^[a-z0-9-]{4,64}$`. Valid characters are
// `a-z-`.
func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) QaScorecardRevisionId(qaScorecardRevisionId string) *ProjectsLocationsQaScorecardsRevisionsCreateCall {
	c.urlParams_.Set("qaScorecardRevisionId", qaScorecardRevisionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1qascorecardrevision)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecardRevision.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecardRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecardRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a QaScorecardRevision.
//
// - name: The name of the QaScorecardRevision to delete.
func (r *ProjectsLocationsQaScorecardsRevisionsService) Delete(name string) *ProjectsLocationsQaScorecardsRevisionsDeleteCall {
	c := &ProjectsLocationsQaScorecardsRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// QaScorecardRevision's child resources will also be deleted. Otherwise, the
// request will only succeed if it has none.
func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) Force(force bool) *ProjectsLocationsQaScorecardsRevisionsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsQaScorecardsRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsDeployCall struct {
	s                                                                  *Service
	name                                                               string
	googlecloudcontactcenterinsightsv1deployqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest
	urlParams_                                                         gensupport.URLParams
	ctx_                                                               context.Context
	header_                                                            http.Header
}

// Deploy: Deploy a QaScorecardRevision.
//
// - name: The name of the QaScorecardRevision to deploy.
func (r *ProjectsLocationsQaScorecardsRevisionsService) Deploy(name string, googlecloudcontactcenterinsightsv1deployqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest) *ProjectsLocationsQaScorecardsRevisionsDeployCall {
	c := &ProjectsLocationsQaScorecardsRevisionsDeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1deployqascorecardrevisionrequest = googlecloudcontactcenterinsightsv1deployqascorecardrevisionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsDeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsDeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsDeployCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsDeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsDeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsDeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1deployqascorecardrevisionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:deploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.deploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecardRevision.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsDeployCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecardRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecardRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a QaScorecardRevision.
//
// - name: The name of the QaScorecardRevision to get.
func (r *ProjectsLocationsQaScorecardsRevisionsService) Get(name string) *ProjectsLocationsQaScorecardsRevisionsGetCall {
	c := &ProjectsLocationsQaScorecardsRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecardRevision.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecardRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecardRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all revisions under the parent QaScorecard.
//
//   - parent: The parent resource of the scorecard revisions. To list all
//     revisions of all scorecards, substitute the QaScorecard ID with a '-'
//     character.
func (r *ProjectsLocationsQaScorecardsRevisionsService) List(parent string) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c := &ProjectsLocationsQaScorecardsRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying scorecard revisions with specific
// properties.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Filter(filter string) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// scorecard revisions to return in the response. If the value is zero, the
// service will select a default size. A call might return fewer objects than
// requested. A non-empty `next_page_token` in the response indicates that more
// data is available.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) PageSize(pageSize int64) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListQaScorecardRevisionsResponse`. This value indicates that this is a
// continuation of a prior `ListQaScorecardRevisions` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) PageToken(pageToken string) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsQaScorecardsRevisionsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall struct {
	s                                                                *Service
	parent                                                           string
	googlecloudcontactcenterinsightsv1tuneqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// TuneQaScorecardRevision: Fine tune one or more QaModels.
//
// - parent: The parent resource for new fine tuning job instance.
func (r *ProjectsLocationsQaScorecardsRevisionsService) TuneQaScorecardRevision(parent string, googlecloudcontactcenterinsightsv1tuneqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest) *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall {
	c := &ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1tuneqascorecardrevisionrequest = googlecloudcontactcenterinsightsv1tuneqascorecardrevisionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1tuneqascorecardrevisionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:tuneQaScorecardRevision")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.tuneQaScorecardRevision" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsTuneQaScorecardRevisionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsUndeployCall struct {
	s                                                                    *Service
	name                                                                 string
	googlecloudcontactcenterinsightsv1undeployqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest
	urlParams_                                                           gensupport.URLParams
	ctx_                                                                 context.Context
	header_                                                              http.Header
}

// Undeploy: Undeploy a QaScorecardRevision.
//
// - name: The name of the QaScorecardRevision to undeploy.
func (r *ProjectsLocationsQaScorecardsRevisionsService) Undeploy(name string, googlecloudcontactcenterinsightsv1undeployqascorecardrevisionrequest *GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest) *ProjectsLocationsQaScorecardsRevisionsUndeployCall {
	c := &ProjectsLocationsQaScorecardsRevisionsUndeployCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1undeployqascorecardrevisionrequest = googlecloudcontactcenterinsightsv1undeployqascorecardrevisionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsUndeployCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsUndeployCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsUndeployCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsUndeployCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsUndeployCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsUndeployCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1undeployqascorecardrevisionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:undeploy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.undeploy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaScorecardRevision.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsUndeployCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaScorecardRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaScorecardRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall struct {
	s                                            *Service
	parent                                       string
	googlecloudcontactcenterinsightsv1qaquestion *GoogleCloudContactcenterinsightsV1QaQuestion
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Create: Create a QaQuestion.
//
// - parent: The parent resource of the QaQuestion.
func (r *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService) Create(parent string, googlecloudcontactcenterinsightsv1qaquestion *GoogleCloudContactcenterinsightsV1QaQuestion) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall {
	c := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1qaquestion = googlecloudcontactcenterinsightsv1qaquestion
	return c
}

// QaQuestionId sets the optional parameter "qaQuestionId": A unique ID for the
// new question. This ID will become the final component of the question's
// resource name. If no ID is specified, a server-generated ID will be used.
// This value should be 4-64 characters and must match the regular expression
// `^[a-z0-9-]{4,64}$`. Valid characters are `a-z-`.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) QaQuestionId(qaQuestionId string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall {
	c.urlParams_.Set("qaQuestionId", qaQuestionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1qaquestion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/qaQuestions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.qaQuestions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaQuestion.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaQuestion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaQuestion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a QaQuestion.
//
// - name: The name of the QaQuestion to delete.
func (r *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService) Delete(name string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall {
	c := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.qaQuestions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a QaQuestion.
//
// - name: The name of the QaQuestion to get.
func (r *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService) Get(name string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall {
	c := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.qaQuestions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaQuestion.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaQuestion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaQuestion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists QaQuestions.
//
// - parent: The parent resource of the questions.
func (r *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService) List(parent string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// questions to return in the response. If the value is zero, the service will
// select a default size. A call might return fewer objects than requested. A
// non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) PageSize(pageSize int64) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListQaQuestionsResponse`. This value indicates that this is a
// continuation of a prior `ListQaQuestions` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) PageToken(pageToken string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/qaQuestions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.qaQuestions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall struct {
	s                                            *Service
	name                                         string
	googlecloudcontactcenterinsightsv1qaquestion *GoogleCloudContactcenterinsightsV1QaQuestion
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Patch: Updates a QaQuestion.
//
//   - name: Identifier. The resource name of the question. Format:
//     projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisio
//     ns/{revision}/qaQuestions/{qa_question}.
func (r *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService) Patch(name string, googlecloudcontactcenterinsightsv1qaquestion *GoogleCloudContactcenterinsightsV1QaQuestion) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall {
	c := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1qaquestion = googlecloudcontactcenterinsightsv1qaquestion
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated. All possible fields can be updated by passing `*`, or
// a subset of the following updateable fields can be provided: *
// `abbreviation` * `answer_choices` * `answer_instructions` * `order` *
// `question_body` * `tags`
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) Context(ctx context.Context) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1qaquestion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.qaScorecards.revisions.qaQuestions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1QaQuestion.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQaScorecardsRevisionsQaQuestionsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1QaQuestion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1QaQuestion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsViewsCreateCall struct {
	s                                      *Service
	parent                                 string
	googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Creates a view.
//
//   - parent: The parent resource of the view. Required. The location to create
//     a view for. Format: `projects//locations/` or `projects//locations/`.
func (r *ProjectsLocationsViewsService) Create(parent string, googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View) *ProjectsLocationsViewsCreateCall {
	c := &ProjectsLocationsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1view = googlecloudcontactcenterinsightsv1view
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsViewsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsViewsCreateCall) Context(ctx context.Context) *ProjectsLocationsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1view)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view.
//
// - name: The name of the view to delete.
func (r *ProjectsLocationsViewsService) Delete(name string) *ProjectsLocationsViewsDeleteCall {
	c := &ProjectsLocationsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsViewsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsViewsDeleteCall) Context(ctx context.Context) *ProjectsLocationsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view.
//
// - name: The name of the view to get.
func (r *ProjectsLocationsViewsService) Get(name string) *ProjectsLocationsViewsGetCall {
	c := &ProjectsLocationsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsViewsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsViewsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsViewsGetCall) Context(ctx context.Context) *ProjectsLocationsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views.
//
// - parent: The parent resource of the views.
func (r *ProjectsLocationsViewsService) List(parent string) *ProjectsLocationsViewsListCall {
	c := &ProjectsLocationsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of views
// to return in the response. If this value is zero, the service will select a
// default size. A call may return fewer objects than requested. A non-empty
// `next_page_token` in the response indicates that more data is available.
func (c *ProjectsLocationsViewsListCall) PageSize(pageSize int64) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListViewsResponse`; indicates that this is a continuation of a prior
// `ListViews` call and the system should return the next page of data.
func (c *ProjectsLocationsViewsListCall) PageToken(pageToken string) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsViewsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsViewsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsViewsListCall) Context(ctx context.Context) *ProjectsLocationsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListViewsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsViewsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsViewsPatchCall struct {
	s                                      *Service
	name                                   string
	googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Updates a view.
//
//   - name: Immutable. The resource name of the view. Format:
//     projects/{project}/locations/{location}/views/{view}.
func (r *ProjectsLocationsViewsService) Patch(name string, googlecloudcontactcenterinsightsv1view *GoogleCloudContactcenterinsightsV1View) *ProjectsLocationsViewsPatchCall {
	c := &ProjectsLocationsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1view = googlecloudcontactcenterinsightsv1view
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsViewsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsViewsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsViewsPatchCall) Context(ctx context.Context) *ProjectsLocationsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudcontactcenterinsightsv1view)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.views.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1View.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsViewsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1View, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1View{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
