/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/networking/v1"
	networkingv1 "k8s.io/client-go/applyconfigurations/networking/v1"
	gentype "k8s.io/client-go/gentype"
	typednetworkingv1 "k8s.io/client-go/kubernetes/typed/networking/v1"
)

// fakeIngressClasses implements IngressClassInterface
type fakeIngressClasses struct {
	*gentype.FakeClientWithListAndApply[*v1.IngressClass, *v1.IngressClassList, *networkingv1.IngressClassApplyConfiguration]
	Fake *FakeNetworkingV1
}

func newFakeIngressClasses(fake *FakeNetworkingV1) typednetworkingv1.IngressClassInterface {
	return &fakeIngressClasses{
		gentype.NewFakeClientWithListAndApply[*v1.IngressClass, *v1.IngressClassList, *networkingv1.IngressClassApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("ingressclasses"),
			v1.SchemeGroupVersion.WithKind("IngressClass"),
			func() *v1.IngressClass { return &v1.IngressClass{} },
			func() *v1.IngressClassList { return &v1.IngressClassList{} },
			func(dst, src *v1.IngressClassList) { dst.ListMeta = src.ListMeta },
			func(list *v1.IngressClassList) []*v1.IngressClass { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.IngressClassList, items []*v1.IngressClass) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
