/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class AuthenticationDialog
extends JDialog {
    JList jListAuths = new JList();
    JLabel messageLabel = new JLabel();
    boolean cancelled = false;

    public AuthenticationDialog() {
        super((Frame)null, "Select Authentication Method(s)", true);
        this.init();
    }

    public AuthenticationDialog(Frame frame) {
        super(frame, "Select Authentication Method(s)", true);
        this.init();
    }

    public AuthenticationDialog(Dialog dialog) {
        super(dialog, "Select Authentication Method(s)", true);
        this.init();
    }

    void init() {
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setMethodList(List methods) {
        this.jListAuths.setListData(methods.toArray());
        if (methods.size() > 0) {
            this.jListAuths.setSelectedIndex(0);
        }
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(1);
        this.messageLabel.setForeground(Color.red);
        this.messageLabel.setHorizontalAlignment(0);
        this.jListAuths = new JList();
        this.jListAuths.setVisibleRowCount(5);
        JPanel listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        listPanel.add(new JScrollPane(this.jListAuths));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        centerPanel.add((Component)new JLabel("Please select an authentication method(s) to continue."), "North");
        centerPanel.add((Component)listPanel, "Center");
        JButton proceed = new JButton("Proceed");
        proceed.setMnemonic('p');
        proceed.setDefaultCapable(true);
        proceed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthenticationDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(proceed);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthenticationDialog.this.cancelled = true;
                AuthenticationDialog.this.setVisible(false);
            }
        });
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        southPanel.add(cancel);
        southPanel.add(proceed);
        IconWrapperPanel iconPanel = new IconWrapperPanel(new ResourceIcon("largelock.png"), centerPanel);
        iconPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)this.messageLabel, "North");
        mainPanel.add((Component)iconPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(mainPanel);
    }

    public static List showAuthenticationDialog(Component parent, List support) {
        return AuthenticationDialog.showAuthenticationDialog(parent, support, null);
    }

    public static List showAuthenticationDialog(Component parent, List support, String message) {
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
        AuthenticationDialog dialog = null;
        dialog = w instanceof Frame ? new AuthenticationDialog((Frame)w) : (w instanceof Dialog ? new AuthenticationDialog((Dialog)w) : new AuthenticationDialog());
        UIUtil.positionComponent(0, dialog);
        return dialog.showAuthenticationMethods(support, message);
    }

    public List showAuthenticationMethods(List supported, String message) {
        Object[] methods;
        this.setMethodList(supported);
        UIUtil.positionComponent(0, this);
        if (message != null) {
            this.messageLabel.setVisible(true);
            this.messageLabel.setText(message);
        } else {
            this.messageLabel.setVisible(false);
        }
        this.pack();
        this.toFront();
        this.setVisible(true);
        ArrayList<Object> list = new ArrayList<Object>();
        if (!this.cancelled && (methods = this.jListAuths.getSelectedValues()) != null) {
            int i = 0;
            while (i < methods.length) {
                list.add(methods[i]);
                ++i;
            }
        }
        return list;
    }

    void jButtonProceed_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

