/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.vfs;

public class VFSPermission {
    private boolean canRead;
    private boolean canWrite;
    private boolean canExecute;
    private String name;

    public VFSPermission(String name, String permissions) {
        this.name = name;
        this.setPermissions(permissions);
    }

    public VFSPermission(String name) {
        this.name = name;
        this.setPermissions("rwx");
    }

    public String getName() {
        return this.name;
    }

    public void setPermissions(String permissions) {
        this.canRead = false;
        this.canWrite = false;
        this.canExecute = false;
        int i = 0;
        while (i < permissions.length()) {
            switch (permissions.charAt(i)) {
                case 'r': {
                    this.canRead = true;
                    break;
                }
                case 'w': {
                    this.canWrite = true;
                    break;
                }
                case 'x': {
                    this.canExecute = true;
                }
            }
            ++i;
        }
    }

    public String getPermissions() {
        return String.valueOf(this.canRead ? "r" : "") + (this.canWrite ? "w" : "") + (this.canExecute ? "x" : "");
    }

    public boolean verifyPermissions(String permissions) {
        String tmp = this.getPermissions();
        int i = 0;
        while (i < permissions.length()) {
            String ch = permissions.substring(i, 1);
            if (tmp.indexOf(ch) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canExecute() {
        return this.canExecute;
    }
}

