/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog(ChannelOutputStream.class);
    private Channel channel;
    private boolean isClosed = false;
    private Integer type = null;

    public ChannelOutputStream(Channel channel, Integer type) {
        this.channel = channel;
        this.type = type;
    }

    public ChannelOutputStream(Channel channel) {
        this(channel, null);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() throws IOException {
        log.info("Closing ChannelOutputStream");
        this.isClosed = true;
        if (!this.channel.isClosed()) {
            this.channel.connection.sendChannelEOF(this.channel);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] data = null;
        if (off > 0 || len < b.length) {
            data = new byte[len];
            System.arraycopy(b, off, data, 0, len);
        } else {
            data = b;
        }
        this.sendChannelData(data);
    }

    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] data = new byte[]{(byte)b};
        this.sendChannelData(data);
    }

    private void sendChannelData(byte[] data) throws IOException {
        this.channel.sendChannelData(data);
    }
}

