/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public abstract class SubsystemMessage {
    private int type;

    public SubsystemMessage(int type) {
        this.type = type;
    }

    public abstract String getMessageName();

    public int getMessageType() {
        return this.type;
    }

    public abstract void constructByteArray(ByteArrayWriter var1) throws InvalidMessageException, IOException;

    public abstract void constructMessage(ByteArrayReader var1) throws InvalidMessageException, IOException;

    public void fromByteArray(byte[] data) throws InvalidMessageException {
        try {
            ByteArrayReader bar = new ByteArrayReader(data);
            if (bar.available() <= 0) {
                throw new InvalidMessageException("Not enough message data to complete the message");
            }
            this.type = bar.read();
            this.constructMessage(bar);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("The message data cannot be read!");
        }
    }

    public byte[] toByteArray() throws InvalidMessageException {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.write(this.type);
            this.constructByteArray(baw);
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("The message data cannot be written!");
        }
    }
}

