/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.util.OpenClosedState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubsystemMessageStore {
    private static Log log = LogFactory.getLog(SubsystemMessageStore.class);
    protected List messages = new ArrayList();
    protected Map registeredMessages = new HashMap();
    private OpenClosedState state = new OpenClosedState(1);

    public synchronized void addMessage(SubsystemMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Received " + msg.getMessageName() + " subsystem message");
        }
        this.messages.add(msg);
        this.notifyAll();
    }

    public synchronized void addMessage(byte[] msgdata) throws InvalidMessageException {
        try {
            Class impl = (Class)this.registeredMessages.get(new Integer(msgdata[0]));
            if (impl == null) {
                throw new InvalidMessageException("The message with id " + String.valueOf(msgdata[0]) + " is not implemented");
            }
            SubsystemMessage msg = (SubsystemMessage)impl.newInstance();
            msg.fromByteArray(msgdata);
            this.addMessage(msg);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new InvalidMessageException("Could not instantiate message class");
    }

    public synchronized SubsystemMessage nextMessage() throws MessageStoreEOFException {
        try {
            return this.nextMessage(0);
        }
        catch (MessageNotAvailableException mnae) {
            return null;
        }
    }

    public synchronized SubsystemMessage nextMessage(int timeout) throws MessageStoreEOFException, MessageNotAvailableException {
        timeout = timeout > 0 ? timeout : 0;
        while (this.messages.size() <= 0) {
            try {
                this.wait(timeout);
                if (timeout <= 0) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.state.getValue() != 1) {
            throw new MessageStoreEOFException();
        }
        if (this.messages.size() > 0) {
            return (SubsystemMessage)this.messages.remove(0);
        }
        throw new MessageNotAvailableException();
    }

    public void registerMessage(int messageId, Class implementor) {
        this.registeredMessages.put(new Integer(messageId), implementor);
    }

    public OpenClosedState getState() {
        return this.state;
    }

    public synchronized void close() {
        this.state.setValue(2);
        this.notifyAll();
    }
}

