/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDST {
    private AccuracyCheckDoubleDST() {
    }

    public static void checkAccuracyDST_1D(int n, int n2) {
        System.out.println("Checking accuracy of 1D DST...");
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = (int)Math.pow(2.0, n3);
            DoubleDST_1D doubleDST_1D = new DoubleDST_1D(n4);
            double d = 0.0;
            double[] dArray = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray);
            double[] dArray2 = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray2);
            doubleDST_1D.forward(dArray, true);
            doubleDST_1D.inverse(dArray, true);
            for (int j = 0; j < n4; ++j) {
                double d2 = Math.abs(dArray2[j] - dArray[j]);
                d = Math.max(d, d2);
            }
            if (d > 1.0E-10) {
                System.err.println("\tsize = 2^" + n3 + ";\terror = " + d);
            } else {
                System.out.println("\tsize = 2^" + n3 + ";\terror = " + d);
            }
            dArray = null;
            dArray2 = null;
            doubleDST_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_2D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleDST_2D doubleDST_2D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 2D DST (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDST_2D = new DoubleDST_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object2);
            object = new double[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object);
            doubleDST_2D.forward((double[])object2, true);
            doubleDST_2D.inverse((double[])object2, true);
            for (n3 = 0; n3 < n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDST_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DST (double[][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDST_2D = new DoubleDST_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[n4][n4];
            IOUtils.fillMatrix_2D(n4, n4, (double[][])object2);
            object = new double[n4][n4];
            IOUtils.fillMatrix_2D(n4, n4, (double[][])object);
            doubleDST_2D.forward((double[][])object2, true);
            doubleDST_2D.inverse((double[][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    d = Math.abs((double)(object[n3][i] - object2[n3][i]));
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDST_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_3D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleDST_3D doubleDST_3D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 3D DST (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDST_3D = new DoubleDST_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object2);
            object = new double[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object);
            doubleDST_3D.forward((double[])object2, true);
            doubleDST_3D.inverse((double[])object2, true);
            for (n3 = 0; n3 < n4 * n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDST_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DST (double[][][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDST_3D = new DoubleDST_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (double[][][])object2);
            object = new double[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (double[][][])object);
            doubleDST_3D.forward((double[][][])object2, true);
            doubleDST_3D.inverse((double[][][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        d = Math.abs((double)(object[n3][i][j] - object2[n3][i][j]));
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDST_3D = null;
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleDST.checkAccuracyDST_1D(0, 21);
        AccuracyCheckDoubleDST.checkAccuracyDST_2D(1, 11);
        AccuracyCheckDoubleDST.checkAccuracyDST_3D(1, 7);
        System.exit(0);
    }
}

