/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jmeld.JMeldException;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.util.CharsetDetector;
import org.jmeld.util.node.FileNode;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;

public class VersionControlBaseDocument
extends AbstractBufferDocument {
    private VersionControlIF versionControl;
    private StatusResult.Entry entry;
    private FileNode fileNode;
    private File file;
    private BaseFile baseFile;
    private boolean baseFileInitialized;
    private Charset charset;

    public VersionControlBaseDocument(VersionControlIF versionControl, StatusResult.Entry entry, FileNode fileNode, File file) {
        this.versionControl = versionControl;
        this.entry = entry;
        this.fileNode = fileNode;
        this.file = file;
        try {
            this.setName(file.getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setName(file.getName());
        }
        this.setShortName(file.getName());
    }

    public int getBufferSize() {
        if (this.useBaseFile()) {
            this.initBaseFile();
            return this.baseFile == null ? -1 : this.baseFile.getLength();
        }
        return this.fileNode.getDocument().getBufferSize();
    }

    public Reader getReader() throws JMeldException {
        if (this.useBaseFile()) {
            try {
                this.initBaseFile();
                BufferedInputStream bais = new BufferedInputStream(new ByteArrayInputStream(this.baseFile.getByteArray()));
                this.charset = CharsetDetector.getInstance().getCharset(bais);
                return new BufferedReader(new InputStreamReader((InputStream)bais, this.charset));
            }
            catch (Exception ex) {
                throw new JMeldException("Could not create FileReader for : " + this.file.getName(), ex);
            }
        }
        return this.fileNode.getDocument().getReader();
    }

    protected Writer getWriter() throws JMeldException {
        return null;
    }

    private boolean useBaseFile() {
        switch (this.entry.getStatus()) {
            case modified: 
            case removed: 
            case missing: {
                return true;
            }
        }
        return false;
    }

    private void initBaseFile() {
        if (!this.baseFileInitialized) {
            this.baseFile = this.versionControl.getBaseFile(this.file);
            this.baseFileInitialized = true;
        }
    }

    public boolean isReadonly() {
        return true;
    }
}

