/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.SQLCatalogsComboBox;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang.StringUtils;

public class CatalogsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CatalogsPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(CatalogsPanel.class);
    private ISession _session;
    private JComponent _parent;
    private SQLCatalogsComboBox _catalogsCmb;
    private PropertyChangeListener _connectionPropetryListener;

    public CatalogsPanel(ISession session, JComponent parent) {
        this._session = session;
        this._parent = parent;
        this._connectionPropetryListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CatalogsPanel.this.onConnectionPropertyChanged(evt);
            }
        };
        this.setVisible(false);
        this.initInBackground();
    }

    private void onConnectionPropertyChanged(PropertyChangeEvent evt) {
        try {
            ISQLConnection conn;
            String propName = evt.getPropertyName();
            if ((propName == null || propName.equals("catalog")) && this._catalogsCmb != null && !StringUtils.equals((String)(conn = this._session.getSQLConnection()).getCatalog(), (String)this._catalogsCmb.getSelectedCatalog())) {
                this._catalogsCmb.setSelectedCatalog(conn.getCatalog());
            }
        }
        catch (SQLException e) {
            s_log.error("Error processing Property ChangeEvent", e);
        }
    }

    private void initInBackground() {
        try {
            if (!this._session.getSQLConnection().getSQLMetaData().supportsCatalogs()) {
                return;
            }
            final String[] catalogs = this._session.getSQLConnection().getSQLMetaData().getCatalogs();
            if (null == catalogs || 0 == catalogs.length) {
                return;
            }
            final String selected = this._session.getSQLConnection().getCatalog();
            this._session.getSQLConnection().removePropertyChangeListener(this._connectionPropetryListener);
            this._session.getSQLConnection().addPropertyChangeListener(this._connectionPropetryListener);
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    CatalogsPanel.this.initGuiInForeground(catalogs, selected);
                }
            });
        }
        catch (SQLException e) {
            s_log.error(s_stringMgr.getString("SessionPanel.error.retrievecatalog"), e);
        }
    }

    private void initGuiInForeground(String[] catalogs, String selected) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        JLabel lblCatalogs = new JLabel(s_stringMgr.getString("SessionPanel.catalog"));
        this.add((Component)lblCatalogs, gbc);
        this._catalogsCmb = new SQLCatalogsComboBox();
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        this.add((Component)this._catalogsCmb, gbc);
        this._catalogsCmb.setCatalogs(catalogs, selected);
        Dimension prefSize = this.getPreferredSize();
        prefSize.width = lblCatalogs.getPreferredSize().width + this._catalogsCmb.getPreferredSize().width + 20;
        this.setPreferredSize(prefSize);
        this.setMaximumSize(prefSize);
        this.setVisible(true);
        this._parent.validate();
    }

    public void addActionListener(ActionListener catalogsComboListener) {
        if (null != this._catalogsCmb) {
            this._catalogsCmb.addActionListener(catalogsComboListener);
        }
    }

    public void removeActionListener(ActionListener catalogsComboListener) {
        if (null != this._catalogsCmb) {
            this._catalogsCmb.addActionListener(catalogsComboListener);
        }
    }

    public void refreshCatalogs() {
        this.removeAll();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                CatalogsPanel.this.initInBackground();
            }
        });
    }

    public String getSelectedCatalog() {
        if (null == this._catalogsCmb) {
            return null;
        }
        return (String)this._catalogsCmb.getSelectedItem();
    }
}

