// Copyright 2023 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: vex.proto

package vex_go_proto

import (
	common_go_proto "github.com/grafeas/grafeas/proto/v1beta1/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Provides the state of this Vulnerability assessment.
type VulnerabilityAssessmentNote_Assessment_State int32

const (
	// No state is specified.
	VulnerabilityAssessmentNote_Assessment_STATE_UNSPECIFIED VulnerabilityAssessmentNote_Assessment_State = 0
	// This product is known to be affected by this vulnerability.
	VulnerabilityAssessmentNote_Assessment_AFFECTED VulnerabilityAssessmentNote_Assessment_State = 1
	// This product is known to be not affected by this vulnerability.
	VulnerabilityAssessmentNote_Assessment_NOT_AFFECTED VulnerabilityAssessmentNote_Assessment_State = 2
	// This product contains a fix for this vulnerability.
	VulnerabilityAssessmentNote_Assessment_FIXED VulnerabilityAssessmentNote_Assessment_State = 3
	// It is not known yet whether these versions are or are not affected
	// by the vulnerability. However, it is still under investigation.
	VulnerabilityAssessmentNote_Assessment_UNDER_INVESTIGATION VulnerabilityAssessmentNote_Assessment_State = 4
)

// Enum value maps for VulnerabilityAssessmentNote_Assessment_State.
var (
	VulnerabilityAssessmentNote_Assessment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "AFFECTED",
		2: "NOT_AFFECTED",
		3: "FIXED",
		4: "UNDER_INVESTIGATION",
	}
	VulnerabilityAssessmentNote_Assessment_State_value = map[string]int32{
		"STATE_UNSPECIFIED":   0,
		"AFFECTED":            1,
		"NOT_AFFECTED":        2,
		"FIXED":               3,
		"UNDER_INVESTIGATION": 4,
	}
)

func (x VulnerabilityAssessmentNote_Assessment_State) Enum() *VulnerabilityAssessmentNote_Assessment_State {
	p := new(VulnerabilityAssessmentNote_Assessment_State)
	*p = x
	return p
}

func (x VulnerabilityAssessmentNote_Assessment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VulnerabilityAssessmentNote_Assessment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_vex_proto_enumTypes[0].Descriptor()
}

func (VulnerabilityAssessmentNote_Assessment_State) Type() protoreflect.EnumType {
	return &file_vex_proto_enumTypes[0]
}

func (x VulnerabilityAssessmentNote_Assessment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment_State.Descriptor instead.
func (VulnerabilityAssessmentNote_Assessment_State) EnumDescriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Provides the type of justification.
type VulnerabilityAssessmentNote_Assessment_Justification_JustificationType int32

const (
	// JUSTIFICATION_TYPE_UNSPECIFIED.
	VulnerabilityAssessmentNote_Assessment_Justification_JUSTIFICATION_TYPE_UNSPECIFIED VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 0
	// The vulnerable component is not present in the product.
	VulnerabilityAssessmentNote_Assessment_Justification_COMPONENT_NOT_PRESENT VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 1
	// The vulnerable code is not present. Typically this case
	// occurs when source code is configured or built in a way that excludes
	// the vulnerable code.
	VulnerabilityAssessmentNote_Assessment_Justification_VULNERABLE_CODE_NOT_PRESENT VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 2
	// The vulnerable code can not be executed.
	// Typically this case occurs when the product includes the vulnerable
	// code but does not call or use the vulnerable code.
	VulnerabilityAssessmentNote_Assessment_Justification_VULNERABLE_CODE_NOT_IN_EXECUTE_PATH VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 3
	// The vulnerable code cannot be controlled by an attacker to exploit
	// the vulnerability.
	VulnerabilityAssessmentNote_Assessment_Justification_VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 4
	// The product includes built-in protections or features that prevent
	// exploitation of the vulnerability. These built-in protections cannot
	// be subverted by the attacker and cannot be configured or disabled by
	// the user. These mitigations completely prevent exploitation based on
	// known attack vectors.
	VulnerabilityAssessmentNote_Assessment_Justification_INLINE_MITIGATIONS_ALREADY_EXIST VulnerabilityAssessmentNote_Assessment_Justification_JustificationType = 5
)

// Enum value maps for VulnerabilityAssessmentNote_Assessment_Justification_JustificationType.
var (
	VulnerabilityAssessmentNote_Assessment_Justification_JustificationType_name = map[int32]string{
		0: "JUSTIFICATION_TYPE_UNSPECIFIED",
		1: "COMPONENT_NOT_PRESENT",
		2: "VULNERABLE_CODE_NOT_PRESENT",
		3: "VULNERABLE_CODE_NOT_IN_EXECUTE_PATH",
		4: "VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY",
		5: "INLINE_MITIGATIONS_ALREADY_EXIST",
	}
	VulnerabilityAssessmentNote_Assessment_Justification_JustificationType_value = map[string]int32{
		"JUSTIFICATION_TYPE_UNSPECIFIED":                    0,
		"COMPONENT_NOT_PRESENT":                             1,
		"VULNERABLE_CODE_NOT_PRESENT":                       2,
		"VULNERABLE_CODE_NOT_IN_EXECUTE_PATH":               3,
		"VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY": 4,
		"INLINE_MITIGATIONS_ALREADY_EXIST":                  5,
	}
)

func (x VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) Enum() *VulnerabilityAssessmentNote_Assessment_Justification_JustificationType {
	p := new(VulnerabilityAssessmentNote_Assessment_Justification_JustificationType)
	*p = x
	return p
}

func (x VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) Descriptor() protoreflect.EnumDescriptor {
	return file_vex_proto_enumTypes[1].Descriptor()
}

func (VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) Type() protoreflect.EnumType {
	return &file_vex_proto_enumTypes[1]
}

func (x VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment_Justification_JustificationType.Descriptor instead.
func (VulnerabilityAssessmentNote_Assessment_Justification_JustificationType) EnumDescriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

// The type of remediation that can be applied.
type VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType int32

const (
	// No remediation type specified.
	VulnerabilityAssessmentNote_Assessment_Remediation_REMEDIATION_TYPE_UNSPECIFIED VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 0
	// A MITIGATION is available.
	VulnerabilityAssessmentNote_Assessment_Remediation_MITIGATION VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 1
	// No fix is planned.
	VulnerabilityAssessmentNote_Assessment_Remediation_NO_FIX_PLANNED VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 2
	// Not available.
	VulnerabilityAssessmentNote_Assessment_Remediation_NONE_AVAILABLE VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 3
	// A vendor fix is available.
	VulnerabilityAssessmentNote_Assessment_Remediation_VENDOR_FIX VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 4
	// A workaround is available.
	VulnerabilityAssessmentNote_Assessment_Remediation_WORKAROUND VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType = 5
)

// Enum value maps for VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType.
var (
	VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType_name = map[int32]string{
		0: "REMEDIATION_TYPE_UNSPECIFIED",
		1: "MITIGATION",
		2: "NO_FIX_PLANNED",
		3: "NONE_AVAILABLE",
		4: "VENDOR_FIX",
		5: "WORKAROUND",
	}
	VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType_value = map[string]int32{
		"REMEDIATION_TYPE_UNSPECIFIED": 0,
		"MITIGATION":                   1,
		"NO_FIX_PLANNED":               2,
		"NONE_AVAILABLE":               3,
		"VENDOR_FIX":                   4,
		"WORKAROUND":                   5,
	}
)

func (x VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) Enum() *VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType {
	p := new(VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType)
	*p = x
	return p
}

func (x VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) Descriptor() protoreflect.EnumDescriptor {
	return file_vex_proto_enumTypes[2].Descriptor()
}

func (VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) Type() protoreflect.EnumType {
	return &file_vex_proto_enumTypes[2]
}

func (x VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType.Descriptor instead.
func (VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType) EnumDescriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2, 1, 0}
}

// A single VulnerabilityAssessmentNote represents
// one particular product's vulnerability assessment for one CVE.
type VulnerabilityAssessmentNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title of the note. E.g. `Vex-Debian-11.4`
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// A one sentence description of this Vex.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this Vex.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Identifies the language used by this document,
	// corresponding to IETF BCP 47 / RFC 5646.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Publisher details of this Note.
	Publisher *VulnerabilityAssessmentNote_Publisher `protobuf:"bytes,5,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// The product affected by this vex.
	Product *VulnerabilityAssessmentNote_Product `protobuf:"bytes,6,opt,name=product,proto3" json:"product,omitempty"`
	// Represents a vulnerability assessment for the product.
	Assessment *VulnerabilityAssessmentNote_Assessment `protobuf:"bytes,7,opt,name=assessment,proto3" json:"assessment,omitempty"`
}

func (x *VulnerabilityAssessmentNote) Reset() {
	*x = VulnerabilityAssessmentNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0}
}

func (x *VulnerabilityAssessmentNote) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *VulnerabilityAssessmentNote) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *VulnerabilityAssessmentNote) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *VulnerabilityAssessmentNote) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *VulnerabilityAssessmentNote) GetPublisher() *VulnerabilityAssessmentNote_Publisher {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *VulnerabilityAssessmentNote) GetProduct() *VulnerabilityAssessmentNote_Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *VulnerabilityAssessmentNote) GetAssessment() *VulnerabilityAssessmentNote_Assessment {
	if x != nil {
		return x.Assessment
	}
	return nil
}

// Publisher contains information about the publisher of
// this Note.
// (-- api-linter: core::0123::resource-annotation=disabled
//
//	aip.dev/not-precedent: Publisher is not a separate resource. --)
type VulnerabilityAssessmentNote_Publisher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the publisher.
	// Examples: 'Google', 'Google Cloud Platform'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Provides information about the authority of the issuing party to
	// release the document, in particular, the party's constituency and
	// responsibilities or other obligations.
	IssuingAuthority string `protobuf:"bytes,2,opt,name=issuing_authority,json=issuingAuthority,proto3" json:"issuing_authority,omitempty"`
	// The context or namespace.
	// Contains a URL which is under control of the issuing party and can
	// be used as a globally unique identifier for that issuing party.
	// Example: https://csaf.io
	PublisherNamespace string `protobuf:"bytes,3,opt,name=publisher_namespace,json=publisherNamespace,proto3" json:"publisher_namespace,omitempty"`
}

func (x *VulnerabilityAssessmentNote_Publisher) Reset() {
	*x = VulnerabilityAssessmentNote_Publisher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote_Publisher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote_Publisher) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote_Publisher) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Publisher.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote_Publisher) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 0}
}

func (x *VulnerabilityAssessmentNote_Publisher) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Publisher) GetIssuingAuthority() string {
	if x != nil {
		return x.IssuingAuthority
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Publisher) GetPublisherNamespace() string {
	if x != nil {
		return x.PublisherNamespace
	}
	return ""
}

// Product contains information about a product and how to uniquely identify
// it.
// (-- api-linter: core::0123::resource-annotation=disabled
//
//	aip.dev/not-precedent: Product is not a separate resource. --)
type VulnerabilityAssessmentNote_Product struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the product.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Token that identifies a product so that it can be referred to from other
	// parts in the document. There is no predefined format as long as it
	// uniquely identifies a group in the context of the current document.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Types that are assignable to Identifier:
	//
	//	*VulnerabilityAssessmentNote_Product_GenericUri
	Identifier isVulnerabilityAssessmentNote_Product_Identifier `protobuf_oneof:"identifier"`
}

func (x *VulnerabilityAssessmentNote_Product) Reset() {
	*x = VulnerabilityAssessmentNote_Product{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote_Product) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote_Product) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote_Product) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Product.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote_Product) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 1}
}

func (x *VulnerabilityAssessmentNote_Product) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Product) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *VulnerabilityAssessmentNote_Product) GetIdentifier() isVulnerabilityAssessmentNote_Product_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *VulnerabilityAssessmentNote_Product) GetGenericUri() string {
	if x, ok := x.GetIdentifier().(*VulnerabilityAssessmentNote_Product_GenericUri); ok {
		return x.GenericUri
	}
	return ""
}

type isVulnerabilityAssessmentNote_Product_Identifier interface {
	isVulnerabilityAssessmentNote_Product_Identifier()
}

type VulnerabilityAssessmentNote_Product_GenericUri struct {
	// Contains a URI which is vendor-specific.
	// Example: The artifact repository URL of an image.
	GenericUri string `protobuf:"bytes,3,opt,name=generic_uri,json=genericUri,proto3,oneof"`
}

func (*VulnerabilityAssessmentNote_Product_GenericUri) isVulnerabilityAssessmentNote_Product_Identifier() {
}

// Assessment provides all information that is related to a single
// vulnerability for this product.
type VulnerabilityAssessmentNote_Assessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Holds the MITRE standard Common Vulnerabilities and Exposures (CVE)
	// tracking number for the vulnerability.
	// Deprecated: Use vulnerability_id instead to denote CVEs.
	//
	// Deprecated: Do not use.
	Cve string `protobuf:"bytes,1,opt,name=cve,proto3" json:"cve,omitempty"`
	// The vulnerability identifier for this Assessment. Will hold one of
	// common identifiers e.g. CVE, GHSA etc.
	VulnerabilityId string `protobuf:"bytes,10,opt,name=vulnerability_id,json=vulnerabilityId,proto3" json:"vulnerability_id,omitempty"`
	// A one sentence description of this Vex.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this Vex.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Holds a list of references associated with this vulnerability item and
	// assessment. These uris have additional information about the
	// vulnerability and the assessment itself. E.g. Link to a document which
	// details how this assessment concluded the state of this vulnerability.
	RelatedUris []*common_go_proto.RelatedUrl `protobuf:"bytes,4,rep,name=related_uris,json=relatedUris,proto3" json:"related_uris,omitempty"`
	// Provides the state of this Vulnerability assessment.
	State VulnerabilityAssessmentNote_Assessment_State `protobuf:"varint,5,opt,name=state,proto3,enum=grafeas.v1beta1.vex.VulnerabilityAssessmentNote_Assessment_State" json:"state,omitempty"`
	// Contains information about the impact of this vulnerability,
	// this will change with time.
	Impacts []string `protobuf:"bytes,8,rep,name=impacts,proto3" json:"impacts,omitempty"`
	// Justification provides the justification when the state of the
	// assessment if NOT_AFFECTED.
	Justification *VulnerabilityAssessmentNote_Assessment_Justification `protobuf:"bytes,9,opt,name=justification,proto3" json:"justification,omitempty"`
	// Specifies details on how to handle (and presumably, fix) a vulnerability.
	Remediations []*VulnerabilityAssessmentNote_Assessment_Remediation `protobuf:"bytes,7,rep,name=remediations,proto3" json:"remediations,omitempty"`
}

func (x *VulnerabilityAssessmentNote_Assessment) Reset() {
	*x = VulnerabilityAssessmentNote_Assessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote_Assessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote_Assessment) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote_Assessment) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote_Assessment) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2}
}

// Deprecated: Do not use.
func (x *VulnerabilityAssessmentNote_Assessment) GetCve() string {
	if x != nil {
		return x.Cve
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Assessment) GetVulnerabilityId() string {
	if x != nil {
		return x.VulnerabilityId
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Assessment) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Assessment) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Assessment) GetRelatedUris() []*common_go_proto.RelatedUrl {
	if x != nil {
		return x.RelatedUris
	}
	return nil
}

func (x *VulnerabilityAssessmentNote_Assessment) GetState() VulnerabilityAssessmentNote_Assessment_State {
	if x != nil {
		return x.State
	}
	return VulnerabilityAssessmentNote_Assessment_STATE_UNSPECIFIED
}

func (x *VulnerabilityAssessmentNote_Assessment) GetImpacts() []string {
	if x != nil {
		return x.Impacts
	}
	return nil
}

func (x *VulnerabilityAssessmentNote_Assessment) GetJustification() *VulnerabilityAssessmentNote_Assessment_Justification {
	if x != nil {
		return x.Justification
	}
	return nil
}

func (x *VulnerabilityAssessmentNote_Assessment) GetRemediations() []*VulnerabilityAssessmentNote_Assessment_Remediation {
	if x != nil {
		return x.Remediations
	}
	return nil
}

// Justification provides the justification when the state of the
// assessment if NOT_AFFECTED.
type VulnerabilityAssessmentNote_Assessment_Justification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The justification type for this vulnerability.
	JustificationType VulnerabilityAssessmentNote_Assessment_Justification_JustificationType `protobuf:"varint,1,opt,name=justification_type,json=justificationType,proto3,enum=grafeas.v1beta1.vex.VulnerabilityAssessmentNote_Assessment_Justification_JustificationType" json:"justification_type,omitempty"`
	// Additional details on why this justification was chosen.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *VulnerabilityAssessmentNote_Assessment_Justification) Reset() {
	*x = VulnerabilityAssessmentNote_Assessment_Justification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote_Assessment_Justification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote_Assessment_Justification) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote_Assessment_Justification) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment_Justification.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote_Assessment_Justification) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *VulnerabilityAssessmentNote_Assessment_Justification) GetJustificationType() VulnerabilityAssessmentNote_Assessment_Justification_JustificationType {
	if x != nil {
		return x.JustificationType
	}
	return VulnerabilityAssessmentNote_Assessment_Justification_JUSTIFICATION_TYPE_UNSPECIFIED
}

func (x *VulnerabilityAssessmentNote_Assessment_Justification) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// Specifies details on how to handle (and presumably, fix) a vulnerability.
type VulnerabilityAssessmentNote_Assessment_Remediation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of remediation that can be applied.
	RemediationType VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType `protobuf:"varint,1,opt,name=remediation_type,json=remediationType,proto3,enum=grafeas.v1beta1.vex.VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType" json:"remediation_type,omitempty"`
	// Contains a comprehensive human-readable discussion of the remediation.
	Details string `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
	// Contains the URL where to obtain the remediation.
	RemediationUri *common_go_proto.RelatedUrl `protobuf:"bytes,5,opt,name=remediation_uri,json=remediationUri,proto3" json:"remediation_uri,omitempty"`
}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) Reset() {
	*x = VulnerabilityAssessmentNote_Assessment_Remediation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_vex_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityAssessmentNote_Assessment_Remediation) ProtoMessage() {}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) ProtoReflect() protoreflect.Message {
	mi := &file_vex_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityAssessmentNote_Assessment_Remediation.ProtoReflect.Descriptor instead.
func (*VulnerabilityAssessmentNote_Assessment_Remediation) Descriptor() ([]byte, []int) {
	return file_vex_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) GetRemediationType() VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType {
	if x != nil {
		return x.RemediationType
	}
	return VulnerabilityAssessmentNote_Assessment_Remediation_REMEDIATION_TYPE_UNSPECIFIED
}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

func (x *VulnerabilityAssessmentNote_Assessment_Remediation) GetRemediationUri() *common_go_proto.RelatedUrl {
	if x != nil {
		return x.RemediationUri
	}
	return nil
}

var File_vex_proto protoreflect.FileDescriptor

var file_vex_proto_rawDesc = []byte{
	0x0a, 0x09, 0x76, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78,
	0x1a, 0x1a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xef, 0x10, 0x0a,
	0x1b, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x58, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x52, 0x09,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78,
	0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x5b, 0x0a,
	0x0a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e,
	0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x7d, 0x0a, 0x09, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x69,
	0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x69, 0x73, 0x73, 0x75, 0x69, 0x6e, 0x67, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x2f, 0x0a, 0x13, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x1a, 0x5e, 0x0a, 0x07, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0b, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x55, 0x72, 0x69, 0x42, 0x0c, 0x0a, 0x0a, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x1a, 0xd2, 0x0b, 0x0a, 0x0a, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x03, 0x63, 0x76, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x03, 0x63, 0x76, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f,
	0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x55, 0x72, 0x6c, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x69,
	0x73, 0x12, 0x57, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x69, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65,
	0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x0c, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65,
	0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xb2, 0x03, 0x0a, 0x0d, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8a, 0x01, 0x0a, 0x12, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x5b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e,
	0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4a,
	0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4a, 0x75, 0x73,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11,
	0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xf9, 0x01, 0x0a, 0x11,
	0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4a, 0x55, 0x53, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e, 0x45,
	0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x01,
	0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x10,
	0x02, 0x12, 0x27, 0x0a, 0x23, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x45, 0x58, 0x45, 0x43,
	0x55, 0x54, 0x45, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x10, 0x03, 0x12, 0x35, 0x0a, 0x31, 0x56, 0x55,
	0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x43, 0x41,
	0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x42, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x4c,
	0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x41, 0x44, 0x56, 0x45, 0x52, 0x53, 0x41, 0x52, 0x59, 0x10,
	0x04, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x4d, 0x49, 0x54, 0x49,
	0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f,
	0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x05, 0x1a, 0x80, 0x03, 0x0a, 0x0b, 0x52, 0x65, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x82, 0x01, 0x0a, 0x10, 0x72, 0x65, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x57, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x72, 0x65, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x0e, 0x72, 0x65,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x22, 0x8b, 0x01, 0x0a,
	0x0f, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x49, 0x54, 0x49, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x46, 0x49, 0x58, 0x5f, 0x50, 0x4c, 0x41,
	0x4e, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x4e, 0x45, 0x5f, 0x41,
	0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x45,
	0x4e, 0x44, 0x4f, 0x52, 0x5f, 0x46, 0x49, 0x58, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x57, 0x4f,
	0x52, 0x4b, 0x41, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x05, 0x22, 0x62, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x46,
	0x46, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f,
	0x41, 0x46, 0x46, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49,
	0x58, 0x45, 0x44, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x49,
	0x4e, 0x56, 0x45, 0x53, 0x54, 0x49, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x42, 0x57,
	0x0a, 0x16, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x65, 0x78, 0x50, 0x01, 0x5a, 0x35, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x78, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_vex_proto_rawDescOnce sync.Once
	file_vex_proto_rawDescData = file_vex_proto_rawDesc
)

func file_vex_proto_rawDescGZIP() []byte {
	file_vex_proto_rawDescOnce.Do(func() {
		file_vex_proto_rawDescData = protoimpl.X.CompressGZIP(file_vex_proto_rawDescData)
	})
	return file_vex_proto_rawDescData
}

var file_vex_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_vex_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_vex_proto_goTypes = []interface{}{
	(VulnerabilityAssessmentNote_Assessment_State)(0),                           // 0: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.State
	(VulnerabilityAssessmentNote_Assessment_Justification_JustificationType)(0), // 1: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Justification.JustificationType
	(VulnerabilityAssessmentNote_Assessment_Remediation_RemediationType)(0),     // 2: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation.RemediationType
	(*VulnerabilityAssessmentNote)(nil),                                         // 3: grafeas.v1beta1.vex.VulnerabilityAssessmentNote
	(*VulnerabilityAssessmentNote_Publisher)(nil),                               // 4: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Publisher
	(*VulnerabilityAssessmentNote_Product)(nil),                                 // 5: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Product
	(*VulnerabilityAssessmentNote_Assessment)(nil),                              // 6: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment
	(*VulnerabilityAssessmentNote_Assessment_Justification)(nil),                // 7: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Justification
	(*VulnerabilityAssessmentNote_Assessment_Remediation)(nil),                  // 8: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation
	(*common_go_proto.RelatedUrl)(nil),                                          // 9: grafeas.v1beta1.RelatedUrl
}
var file_vex_proto_depIdxs = []int32{
	4,  // 0: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.publisher:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Publisher
	5,  // 1: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.product:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Product
	6,  // 2: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.assessment:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment
	9,  // 3: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.related_uris:type_name -> grafeas.v1beta1.RelatedUrl
	0,  // 4: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.state:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.State
	7,  // 5: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.justification:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Justification
	8,  // 6: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.remediations:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation
	1,  // 7: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Justification.justification_type:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Justification.JustificationType
	2,  // 8: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation.remediation_type:type_name -> grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation.RemediationType
	9,  // 9: grafeas.v1beta1.vex.VulnerabilityAssessmentNote.Assessment.Remediation.remediation_uri:type_name -> grafeas.v1beta1.RelatedUrl
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_vex_proto_init() }
func file_vex_proto_init() {
	if File_vex_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_vex_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_vex_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote_Publisher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_vex_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote_Product); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_vex_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote_Assessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_vex_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote_Assessment_Justification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_vex_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityAssessmentNote_Assessment_Remediation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_vex_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*VulnerabilityAssessmentNote_Product_GenericUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_vex_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_vex_proto_goTypes,
		DependencyIndexes: file_vex_proto_depIdxs,
		EnumInfos:         file_vex_proto_enumTypes,
		MessageInfos:      file_vex_proto_msgTypes,
	}.Build()
	File_vex_proto = out.File
	file_vex_proto_rawDesc = nil
	file_vex_proto_goTypes = nil
	file_vex_proto_depIdxs = nil
}
