/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthDesktopPaneUI
extends BasicDesktopPaneUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private TaskBar taskBar;
    private DesktopManager oldDesktopManager;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopPaneUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktop.addPropertyChangeListener(this);
        if (this.taskBar != null) {
            this.desktop.addComponentListener(this.taskBar);
            this.desktop.addContainerListener(this.taskBar);
        }
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.desktop);
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.taskBar = new TaskBar();
            for (Component component : this.desktop.getComponents()) {
                JInternalFrame.JDesktopIcon jDesktopIcon;
                if (component instanceof JInternalFrame.JDesktopIcon) {
                    jDesktopIcon = (JInternalFrame.JDesktopIcon)component;
                } else {
                    if (!(component instanceof JInternalFrame)) continue;
                    jDesktopIcon = ((JInternalFrame)component).getDesktopIcon();
                }
                if (jDesktopIcon.getParent() == this.desktop) {
                    this.desktop.remove(jDesktopIcon);
                }
                if (jDesktopIcon.getParent() == this.taskBar) continue;
                this.taskBar.add(jDesktopIcon);
                jDesktopIcon.getInternalFrame().addComponentListener(this.taskBar);
            }
            this.taskBar.setBackground(this.desktop.getBackground());
            this.desktop.add((Component)this.taskBar, (Object)(JLayeredPane.PALETTE_LAYER + 1));
            if (this.desktop.isShowing()) {
                this.taskBar.adjustSize();
            }
        }
    }

    private void updateStyle(JDesktopPane jDesktopPane) {
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext(jDesktopPane, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    @Override
    protected void uninstallListeners() {
        if (this.taskBar != null) {
            this.desktop.removeComponentListener(this.taskBar);
            this.desktop.removeContainerListener(this.taskBar);
        }
        this.desktop.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktop, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        if (this.taskBar != null) {
            for (Component component : this.taskBar.getComponents()) {
                JInternalFrame.JDesktopIcon jDesktopIcon = (JInternalFrame.JDesktopIcon)component;
                this.taskBar.remove(jDesktopIcon);
                jDesktopIcon.setPreferredSize(null);
                JInternalFrame jInternalFrame = jDesktopIcon.getInternalFrame();
                if (jInternalFrame.isIcon()) {
                    this.desktop.add(jDesktopIcon);
                }
                jInternalFrame.removeComponentListener(this.taskBar);
            }
            this.desktop.remove(this.taskBar);
            this.taskBar = null;
        }
    }

    @Override
    protected void installDesktopManager() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.desktopManager = this.oldDesktopManager = this.desktop.getDesktopManager();
            if (!(this.desktopManager instanceof SynthDesktopManager)) {
                this.desktopManager = new SynthDesktopManager();
                this.desktop.setDesktopManager(this.desktopManager);
            }
        } else {
            super.installDesktopManager();
        }
    }

    @Override
    protected void uninstallDesktopManager() {
        if (this.oldDesktopManager != null && !(this.oldDesktopManager instanceof UIResource)) {
            this.desktopManager = this.desktop.getDesktopManager();
            if (this.desktopManager == null || this.desktopManager instanceof UIResource) {
                this.desktop.setDesktopManager(this.oldDesktopManager);
            }
        }
        this.oldDesktopManager = null;
        super.uninstallDesktopManager();
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintDesktopPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintDesktopPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JDesktopPane)propertyChangeEvent.getSource());
        }
        if (propertyChangeEvent.getPropertyName() == "ancestor" && this.taskBar != null) {
            this.taskBar.adjustSize();
        }
    }

    class SynthDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        SynthDesktopManager() {
        }

        @Override
        public void maximizeFrame(JInternalFrame jInternalFrame) {
            if (jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
                Container container = jInternalFrame.getParent();
                this.setBoundsForFrame(jInternalFrame, 0, 0, container.getWidth(), container.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight());
            }
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame jInternalFrame) {
            Container container = jInternalFrame.getParent();
            JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
            boolean bl = jInternalFrame.isSelected();
            if (container == null) {
                return;
            }
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            if (!jInternalFrame.isMaximum()) {
                jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
            }
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (bl) {
                for (Component component : container.getComponents()) {
                    if (!(component instanceof JInternalFrame)) continue;
                    try {
                        ((JInternalFrame)component).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ((JInternalFrame)component).moveToFront();
                    return;
                }
            }
        }

        @Override
        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Container container = jDesktopIcon.getParent();
            if (container != null && (container = container.getParent()) != null) {
                container.add(jInternalFrame);
                if (jInternalFrame.isMaximum()) {
                    int n = container.getWidth();
                    int n2 = container.getHeight() - SynthDesktopPaneUI.this.taskBar.getHeight();
                    if (jInternalFrame.getWidth() != n || jInternalFrame.getHeight() != n2) {
                        this.setBoundsForFrame(jInternalFrame, 0, 0, n, n2);
                    }
                }
                if (jInternalFrame.isSelected()) {
                    jInternalFrame.moveToFront();
                } else {
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        protected void removeIconFor(JInternalFrame jInternalFrame) {
            super.removeIconFor(jInternalFrame);
            SynthDesktopPaneUI.this.taskBar.validate();
        }

        @Override
        public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            super.setBoundsForFrame(jComponent, n, n2, n3, n4);
            if (SynthDesktopPaneUI.this.taskBar != null && n2 >= SynthDesktopPaneUI.this.taskBar.getY()) {
                jComponent.setLocation(jComponent.getX(), SynthDesktopPaneUI.this.taskBar.getY() - jComponent.getInsets().top);
            }
        }
    }

    static class TaskBar
    extends JPanel
    implements ComponentListener,
    ContainerListener {
        TaskBar() {
            this.setOpaque(true);
            this.setLayout(new FlowLayout(0, 0, 0){

                @Override
                public void layoutContainer(Container container) {
                    Component[] componentArray = container.getComponents();
                    int n = componentArray.length;
                    if (n > 0) {
                        int n2 = 0;
                        for (Component component : componentArray) {
                            component.setPreferredSize(null);
                            Dimension dimension = component.getPreferredSize();
                            if (dimension.width <= n2) continue;
                            n2 = dimension.width;
                        }
                        Insets insets = container.getInsets();
                        int n3 = container.getWidth() - insets.left - insets.right;
                        int n4 = Math.min(n2, Math.max(10, n3 / n));
                        for (Component component : componentArray) {
                            Dimension dimension = component.getPreferredSize();
                            component.setPreferredSize(new Dimension(n4, dimension.height));
                        }
                    }
                    super.layoutContainer(container);
                }
            });
            this.setBorder(new BevelBorder(0){

                @Override
                protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    graphics.translate(n, n2);
                    graphics.setColor(this.getHighlightOuterColor(component));
                    graphics.drawLine(0, 0, 0, n4 - 2);
                    graphics.drawLine(1, 0, n3 - 2, 0);
                    graphics.setColor(this.getShadowOuterColor(component));
                    graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                    graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
                    graphics.translate(-n, -n2);
                    graphics.setColor(color);
                }
            });
        }

        void adjustSize() {
            JDesktopPane jDesktopPane = (JDesktopPane)this.getParent();
            if (jDesktopPane != null) {
                int n = this.getPreferredSize().height;
                Insets insets = this.getInsets();
                if (n == insets.top + insets.bottom) {
                    n = this.getHeight() <= n ? (n += 21) : this.getHeight();
                }
                this.setBounds(0, jDesktopPane.getHeight() - n, jDesktopPane.getWidth(), n);
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JDesktopPane) {
                this.adjustSize();
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JInternalFrame) {
                this.adjustSize();
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getSource() instanceof JInternalFrame) {
                ((JInternalFrame)componentEvent.getSource()).getDesktopIcon().setVisible(false);
                this.revalidate();
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JDesktopPane jDesktopPane = (JDesktopPane)containerEvent.getSource();
                JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
                JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
                for (Component component : this.getComponents()) {
                    if (component != jDesktopIcon) continue;
                    return;
                }
                this.add(jDesktopIcon);
                jInternalFrame.addComponentListener(this);
                if (this.getComponentCount() == 1) {
                    this.adjustSize();
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            JInternalFrame jInternalFrame;
            if (containerEvent.getChild() instanceof JInternalFrame && !(jInternalFrame = (JInternalFrame)containerEvent.getChild()).isIcon()) {
                this.remove(jInternalFrame.getDesktopIcon());
                jInternalFrame.removeComponentListener(this);
                this.revalidate();
                this.repaint();
            }
        }
    }
}

