/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.javafx.applet.HostServicesImpl;
import com.sun.javafx.application.HostServicesDelegate;
import java.io.File;
import java.net.URI;
import javafx.application.Application;
import netscape.javascript.JSObject;

public class HostServicesFactory {
    public static HostServicesDelegate getInstance(Application app) {
        HostServicesDelegate instance = HostServicesImpl.getInstance(app);
        if (instance == null) {
            instance = StandaloneHostService.getInstance(app);
        }
        return instance;
    }

    private HostServicesFactory() {
        throw new InternalError();
    }

    private static class StandaloneHostService
    extends HostServicesDelegate {
        private static HostServicesDelegate instance = null;
        private Class appClass = null;
        static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HostServicesDelegate getInstance(Application app) {
            Class<StandaloneHostService> clazz = StandaloneHostService.class;
            synchronized (StandaloneHostService.class) {
                if (instance == null) {
                    instance = new StandaloneHostService(app);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private StandaloneHostService(Application app) {
            this.appClass = app.getClass();
        }

        public String getCodeBase() {
            String codebase;
            String classUrlString;
            String theClassFile = this.appClass.getName();
            int idx = theClassFile.lastIndexOf(".");
            if (idx >= 0) {
                theClassFile = theClassFile.substring(idx + 1);
            }
            if (!(classUrlString = this.appClass.getResource(theClassFile = theClassFile + ".class").toString()).startsWith("jar:file:") || classUrlString.indexOf("!") == -1) {
                return "";
            }
            String urlString = classUrlString.substring(4, classUrlString.lastIndexOf("!"));
            File jarFile = null;
            try {
                jarFile = new File(new URI(urlString).getPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (jarFile != null && (codebase = jarFile.getParent()) != null) {
                return this.toURIString(codebase);
            }
            return "";
        }

        private String toURIString(String filePath) {
            try {
                return new File(filePath).toURI().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public String getDocumentBase() {
            return this.toURIString(System.getProperty("user.dir"));
        }

        public void showDocument(String uri) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, uri);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + uri);
                } else {
                    String browser = null;
                    for (String b : browsers) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{browser = b, uri});
                    }
                    if (browser == null) {
                        throw new Exception("No web browser found");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public JSObject getWebContext() {
            return null;
        }
    }
}

