/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.transformation.SortableList;
import com.sun.javafx.collections.transformation.TransformationList;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.collections.ListChangeListener;

public final class SortedList<E>
extends TransformationList<E, E>
implements SortableList<E> {
    private SortableList.SortMode mode;
    private ElementComparator<E> comparator;
    private Element<E>[] sorted;
    private int size;
    private boolean comparisonFailed;
    private SortHelper helper;
    private Element<E> tempElement = new Element<Object>(null, -1);

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    private void updatePermutationIndexes(ListChangeListener.Change<? extends E> change) {
        for (int i = 0; i < this.size; ++i) {
            ((Element)this.sorted[i]).index = change.getPermutation(((Element)this.sorted[i]).index);
        }
    }

    private void ensureSize(int n) {
        if (this.sorted.length < n) {
            Element[] elementArray = new Element[n * 3 / 2 + 1];
            System.arraycopy(this.sorted, 0, elementArray, 0, this.size);
            this.sorted = elementArray;
        }
    }

    private int findPosition(E e) {
        if (this.sorted.length == 0) {
            return 0;
        }
        ((Element)this.tempElement).e = e;
        int n = Arrays.binarySearch(this.sorted, 0, this.size, this.tempElement, this.comparator);
        return n;
    }

    private int compare(E e, E e2) {
        return ((ElementComparator)this.comparator).comparator == null ? ((Comparable)e).compareTo(e2) : ((ElementComparator)this.comparator).comparator.compare(e, e2);
    }

    private int findPosition(int n, E e) {
        if (this.mode == SortableList.SortMode.BATCH) {
            for (int i = 0; i < this.size; ++i) {
                if (((Element)this.sorted[i]).index != n) continue;
                return i;
            }
            return -1;
        }
        int n2 = this.findPosition(e);
        if (((Element)this.sorted[n2]).index == n) {
            return n2;
        }
        int n3 = n2;
        while (((Element)this.sorted[--n3]).index != n && this.compare(((Element)this.sorted[n3]).e, e) == 0) {
        }
        if (((Element)this.sorted[n3]).index == n) {
            return n3;
        }
        n3 = n2;
        while (((Element)this.sorted[++n3]).index != n && this.compare(((Element)this.sorted[n3]).e, e) == 0) {
        }
        if (((Element)this.sorted[n3]).index == n) {
            return n3;
        }
        return -1;
    }

    private void insertUnsorted(int n, int n2) {
        this.ensureSize(this.size + n2 - n);
        this.updateIndices(n, n2 - n);
        for (int i = n; i < n2; ++i) {
            this.sorted[this.size + i - n] = new Element(this.source.get(i), i);
        }
        this.size += n2 - n;
        this.fireChange(new NonIterableChange.SimpleAddChange(this.size - n2 + n, this.size, this));
    }

    private void insertOneSorted(E e, int n) {
        int n2 = this.findPosition(e);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        this.ensureSize(this.size + 1);
        this.updateIndices(n, 1);
        System.arraycopy(this.sorted, n2, this.sorted, n2 + 1, this.size - n2);
        this.sorted[n2] = new Element<E>(e, n);
        ++this.size;
        this.fireChange(new NonIterableChange.SimpleAddChange(n2, n2 + 1, this));
    }

    private void removeOne(int n, E e) {
        int n2 = this.findPosition(n, e);
        System.arraycopy(this.sorted, n2 + 1, this.sorted, n2, this.size - n2 - 1);
        --this.size;
        this.updateIndices(n + 1, -1);
        this.fireChange(new NonIterableChange.SimpleRemovedChange<E>(n2, n2, e, this));
    }

    private void updateUnsorted(ListChangeListener.Change<? extends E> change) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<E> list = change.getRemoved();
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (n = 0; n < change.getRemovedSize(); ++n) {
            E e = list.get(n);
            int n4 = this.findPosition(change.getFrom() + n, e);
            if (n4 < n2) {
                n2 = n4;
            }
            if (n4 + 1 > n3) {
                n3 = n4 + 1;
            }
            ((Element)this.sorted[n4]).removeFlag = true;
        }
        if (n3 == -1) {
            n3 = 0;
            n2 = 0;
        }
        for (n = n2; n < n3; ++n) {
            arrayList.add(((Element)this.sorted[n]).e);
        }
        for (n = n2; n < n3; ++n) {
            if (!((Element)this.sorted[n]).removeFlag) continue;
            System.arraycopy(this.sorted, n + 1, this.sorted, n, this.size - n - 1);
            --this.size;
            --n3;
            --n;
        }
        this.updateIndices(change.getFrom() + change.getRemovedSize(), change.getAddedSize() - change.getRemovedSize());
        if (change.wasAdded()) {
            this.ensureSize(this.size + change.getAddedSize());
            System.arraycopy(this.sorted, n3, this.sorted, n3 + change.getAddedSize(), this.size - n3);
            this.size += change.getAddedSize();
            for (n = change.getFrom(); n < change.getTo(); ++n) {
                this.sorted[n3++] = new Element(change.getList().get(n), n);
            }
        }
        this.fireChange(new NonIterableChange.GenericAddRemoveChange(n2, n3, Collections.unmodifiableList(arrayList), this));
    }

    private void updateSorted(ListChangeListener.Change<? extends E> change) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<E> list = change.getRemoved();
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (n = 0; n < change.getRemovedSize(); ++n) {
            E e = list.get(n);
            int n4 = this.findPosition(change.getFrom() + n, e);
            if (n4 < n2) {
                n2 = n4;
            }
            if (n4 + 1 > n3) {
                n3 = n4 + 1;
            }
            ((Element)this.sorted[n4]).removeFlag = true;
        }
        if (n3 == -1) {
            n3 = 0;
            n2 = 0;
        }
        for (n = change.getFrom(); n < change.getTo(); ++n) {
            int n5 = this.findPosition(change.getList().get(n));
            if (n5 < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            if (n5 < n2) {
                n2 = n5;
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        for (n = n2; n < n3; ++n) {
            arrayList.add(((Element)this.sorted[n]).e);
        }
        for (n = n2; n < n3; ++n) {
            if (!((Element)this.sorted[n]).removeFlag) continue;
            System.arraycopy(this.sorted, n + 1, this.sorted, n, this.size - n - 1);
            --this.size;
            --n3;
            --n;
        }
        this.updateIndices(change.getFrom() + change.getRemovedSize(), change.getAddedSize() - change.getRemovedSize());
        if (change.wasAdded()) {
            this.ensureSize(this.size + change.getAddedSize());
            for (n = change.getFrom(); n < change.getTo(); ++n) {
                int n6 = this.findPosition(change.getList().get(n));
                if (n6 < 0) {
                    n6 ^= 0xFFFFFFFF;
                }
                System.arraycopy(this.sorted, n6, this.sorted, n6 + 1, this.size - n6);
                this.sorted[n6] = new Element(change.getList().get(n), n);
                ++this.size;
                ++n3;
            }
        }
        this.fireChange(new NonIterableChange.GenericAddRemoveChange(n2, n3, Collections.unmodifiableList(arrayList), this));
    }

    private void updateIndices(int n, int n2) {
        for (int i = 0; i < this.size; ++i) {
            if (((Element)this.sorted[i]).index < n) continue;
            ((Element)this.sorted[i]).index += n2;
        }
    }

    public SortedList(List<? extends E> list, Comparator<? super E> comparator, SortableList.SortMode sortMode) {
        super(list);
        if (sortMode == SortableList.SortMode.LIVE && !this.observable) {
            throw new IllegalArgumentException("Cannot create live mode SortedList with list that is not an ObservableList");
        }
        this.comparator = new ElementComparator<E>(comparator);
        this.mode = sortMode;
        this.sorted = new Element[list.size() * 3 / 2 + 1];
        this.size = list.size();
        for (int i = 0; i < this.size; ++i) {
            this.sorted[i] = new Element<E>(list.get(i), i);
        }
        if (sortMode == SortableList.SortMode.LIVE) {
            try {
                this.doArraysSort();
            }
            catch (ClassCastException classCastException) {
                this.comparisonFailed = true;
            }
        }
    }

    public SortedList(List<E> list, Comparator<? super E> comparator) {
        this(list, comparator, SortableList.SortMode.LIVE);
    }

    public SortedList(List<E> list) {
        this(list, null, SortableList.SortMode.LIVE);
    }

    @Override
    protected void onSourceChanged(ListChangeListener.Change<? extends E> change) {
        if (this.comparisonFailed) {
            if (this.mode == SortableList.SortMode.LIVE) {
                try {
                    this.resort();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return;
        }
        if (change.wasPermutated()) {
            this.updatePermutationIndexes(change);
            return;
        }
        if (this.mode == SortableList.SortMode.BATCH) {
            if (change.wasAdded() && !change.wasRemoved()) {
                this.insertUnsorted(change.getFrom(), change.getTo());
            } else {
                this.updateUnsorted(change);
            }
        } else {
            try {
                if (change.wasAdded() && !change.wasRemoved() && change.getAddedSize() == 1) {
                    this.insertOneSorted(change.getList().get(change.getFrom()), change.getFrom());
                } else if (change.wasRemoved() && change.getRemovedSize() == 1) {
                    this.removeOne(change.getFrom(), change.getRemoved().get(0));
                } else {
                    this.updateSorted(change);
                }
            }
            catch (ClassCastException classCastException) {
                this.comparisonFailed = true;
                throw classCastException;
            }
        }
    }

    @Override
    public E get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        return (E)((Element)this.sorted[n]).e;
    }

    @Override
    public int size() {
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        return this.size;
    }

    @Override
    public boolean addAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(E ... EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        for (int i = 0; i < this.size; ++i) {
            if ((object != null || this.get(i) != null) && (object == null || !object.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if ((object != null || this.get(i) != null) && (object == null || !object.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        Object[] objectArray = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (this.comparisonFailed) {
            throw new ClassCastException("Cannot use natural comparison as underlying list contains element(s) that are not Comparable");
        }
        Object[] objectArray = TArray.length < this.size ? (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size) : TArray;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public void sort() {
        if (this.comparisonFailed) {
            this.resort();
        } else if (this.mode == SortableList.SortMode.BATCH) {
            try {
                this.doSortWithPermutationChange();
            }
            catch (ClassCastException classCastException) {
                this.comparisonFailed = true;
                throw classCastException;
            }
        }
    }

    private void doArraysSort() {
        Arrays.sort(this.sorted, 0, this.size, this.comparator);
    }

    private void doSortWithPermutationChange() {
        int[] nArray = this.getSortHelper().sort(this.sorted, 0, this.size, this.comparator);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size, nArray, this));
    }

    @Override
    public void setMode(SortableList.SortMode sortMode) {
        if (this.mode != sortMode) {
            if (sortMode == SortableList.SortMode.LIVE && !this.observable) {
                throw new IllegalArgumentException("Cannot switch to LIVE mode. A source list is not an ObservableList");
            }
            this.mode = sortMode;
            if (sortMode == SortableList.SortMode.LIVE) {
                this.sort();
            }
        }
    }

    private void resort() {
        this.ensureSize(this.source.size());
        this.source.toArray(this.sorted);
        this.size = this.source.size();
        this.doArraysSort();
        this.comparisonFailed = false;
    }

    @Override
    public SortableList.SortMode getMode() {
        return this.mode;
    }

    @Override
    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = new ElementComparator<E>(comparator);
        if (this.mode == SortableList.SortMode.LIVE) {
            try {
                if (this.comparisonFailed) {
                    this.resort();
                } else {
                    this.doSortWithPermutationChange();
                }
            }
            catch (ClassCastException classCastException) {
                this.comparisonFailed = true;
            }
        }
    }

    @Override
    public Comparator<? super E> getComparator() {
        return ((ElementComparator)this.comparator).comparator;
    }

    @Override
    public int getSourceIndex(int n) {
        return ((Element)this.sorted[n]).index;
    }

    private static class ElementComparator<E>
    implements Comparator<Element<E>> {
        private Comparator<? super E> comparator;

        public ElementComparator(Comparator<? super E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Element<E> element, Element<E> element2) {
            if (this.comparator == null) {
                if (((Element)element).e == null && ((Element)element2).e == null) {
                    return 0;
                }
                if (((Element)element).e == null) {
                    return -1;
                }
                if (((Element)element2).e == null) {
                    return 1;
                }
                if (((Element)element).e instanceof Comparable) {
                    return ((Comparable)((Element)element).e).compareTo(((Element)element2).e);
                }
                return Collator.getInstance().compare(((Element)element).e.toString(), ((Element)element2).e.toString());
            }
            return this.comparator.compare(((Element)element).e, ((Element)element2).e);
        }
    }

    private static class Element<E> {
        private E e;
        private int index;
        private boolean removeFlag;

        public Element(E e, int n) {
            this.e = e;
            this.index = n;
        }
    }
}

