/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassEventUtils;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;

public class GlassViewEventHandler
extends View.EventHandler {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private ViewScene scene;
    private int initialWidth;
    private int initialHeight;
    private final GlassSceneDnDEventHandler dndHandler;
    private GestureRecognizers gestures = new GestureRecognizers();
    private final QuantumToolkit toolkit = (QuantumToolkit)QuantumToolkit.getToolkit();
    private final PaintCollector collector = PaintCollector.getInstance();
    private final KeyEventNotification keyNotification = new KeyEventNotification();
    private boolean dragPerformed = false;
    private int mouseButtonPressedMask = 0;
    private final MouseEventNotification mouseNotification = new MouseEventNotification();
    private ClipboardAssistance dropSourceAssistant;
    private final ViewEventNotification viewNotification = new ViewEventNotification();

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.initialWidth = 0;
        this.initialHeight = 0;
        this.dndHandler = new GlassSceneDnDEventHandler(viewScene, null, verbose);
        if (PlatformUtil.isWindows()) {
            this.gestures.add(new SwipeGestureRecognizer(viewScene));
        }
    }

    private static boolean allowableFullScreenKeys(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n, int n2, char[] cArray, int n3) {
        if (!this.scene.getWindowStage().isTrustedFullScreen()) {
            return GlassViewEventHandler.allowableFullScreenKeys(n2);
        }
        return true;
    }

    private boolean toolkit() {
        GlassViewEventHandler glassViewEventHandler = this;
        return glassViewEventHandler.toolkit.getFxUserThread() != null;
    }

    @Override
    public void handleKeyEvent(View view, long l, int n, int n2, char[] cArray, int n3) {
        this.keyNotification.view = view;
        this.keyNotification.time = l;
        this.keyNotification.type = n;
        this.keyNotification.key = n2;
        this.keyNotification.chars = cArray;
        this.keyNotification.modifiers = n3;
        AccessController.doPrivileged(this.keyNotification, this.scene.getAccessControlContext());
    }

    @Override
    public void handleMouseEvent(View view, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
        this.mouseNotification.view = view;
        this.mouseNotification.time = l;
        this.mouseNotification.type = n;
        this.mouseNotification.button = n2;
        this.mouseNotification.x = n3;
        this.mouseNotification.y = n4;
        this.mouseNotification.xAbs = n5;
        this.mouseNotification.yAbs = n6;
        this.mouseNotification.clickCount = n7;
        this.mouseNotification.modifiers = n8;
        this.mouseNotification.isPopupTrigger = bl;
        this.mouseNotification.isSynthesized = bl2;
        AccessController.doPrivileged(this.mouseNotification, this.scene.getAccessControlContext());
    }

    @Override
    public void handleMenuEvent(View view, final int n, final int n2, final int n3, final int n4, final boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    if (windowStage != null) {
                        windowStage.setInEventHandler(true);
                    }
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.menuEvent(n, n2, n3, n4, bl);
                    }
                }
                finally {
                    if (windowStage != null) {
                        windowStage.setInEventHandler(false);
                    }
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleScrollEvent(View view, long l, final int n, final int n2, final int n3, final int n4, final double d, final double d2, final int n5, final int n6, final int n7, final int n8, final int n9, final double d3, final double d4) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                Object var1_1 = null;
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    if (windowStage != null) {
                        windowStage.setInEventHandler(true);
                    }
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, d, d2, 0.0, 0.0, d3, d4, 0, n7, n6, n9, n8, n, n2, n3, n4, (n5 & 1) != 0, (n5 & 4) != 0, (n5 & 8) != 0, (n5 & 0x10) != 0, false, false);
                    }
                }
                finally {
                    if (windowStage != null) {
                        windowStage.setInEventHandler(false);
                    }
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleInputMethodEvent(long l, final String string, final int[] nArray, final int[] nArray2, final byte[] byArray, final int n, final int n2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null && GlassViewEventHandler.this.toolkit()) {
                    GlassPrismInputMethodEvent glassPrismInputMethodEvent = new GlassPrismInputMethodEvent(GlassViewEventHandler.this.scene, string, nArray, nArray2, byArray, n, n2);
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.inputMethodEvent(glassPrismInputMethodEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public double[] getInputMethodCandidatePos(int n) {
        Point2D point2D = this.scene.inputMethodRequests.getTextLocation(n);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return dArray;
    }

    @Override
    public int handleDragEnter(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragEnter(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        this.dndHandler.handleDragLeave(clipboardAssistance);
    }

    @Override
    public int handleDragDrop(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragDrop(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public int handleDragOver(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragOver(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragStart(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        this.dropSourceAssistant = clipboardAssistance;
        this.dndHandler.handleDragStart(n, n2, n3, n4, n5, clipboardAssistance);
    }

    @Override
    public void handleDragEnd(View view, int n) {
        this.dndHandler.handleDragEnd(n, this.dropSourceAssistant);
    }

    @Override
    public void handleViewEvent(View view, long l, int n) {
        this.viewNotification.view = view;
        this.viewNotification.time = l;
        this.viewNotification.type = n;
        AccessController.doPrivileged(this.viewNotification, this.scene.getAccessControlContext());
    }

    @Override
    public void handleScrollGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final int n7, final double d, final double d2, final double d3, final double d4) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                Object var1_1 = null;
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<ScrollEvent> eventType = ScrollEvent.SCROLL;
                        switch (n) {
                            case 1: {
                                eventType = ScrollEvent.SCROLL_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = ScrollEvent.SCROLL;
                                break;
                            }
                            case 3: {
                                eventType = ScrollEvent.SCROLL_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.scrollEvent(eventType, d, d2, d3, d4, 1.0, 1.0, n3, 0, 0, 0, 0, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleZoomGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final double d, double d2, final double d3, double d4) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<ZoomEvent> eventType = ZoomEvent.ZOOM;
                        switch (n) {
                            case 1: {
                                eventType = ZoomEvent.ZOOM_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = ZoomEvent.ZOOM;
                                break;
                            }
                            case 3: {
                                eventType = ZoomEvent.ZOOM_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.zoomEvent(eventType, d, d3, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleRotateGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final double d, final double d2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                Object var1_1 = null;
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<RotateEvent> eventType = RotateEvent.ROTATE;
                        switch (n) {
                            case 1: {
                                eventType = RotateEvent.ROTATION_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = RotateEvent.ROTATE;
                                break;
                            }
                            case 3: {
                                eventType = RotateEvent.ROTATION_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.rotateEvent(eventType, d, d2, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleSwipeGestureEvent(View view, long l, int n, final int n2, final boolean bl, boolean bl2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                Object var1_1 = null;
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<SwipeEvent> eventType = null;
                        switch (n4) {
                            case 1: {
                                eventType = SwipeEvent.SWIPE_UP;
                                break;
                            }
                            case 2: {
                                eventType = SwipeEvent.SWIPE_DOWN;
                                break;
                            }
                            case 3: {
                                eventType = SwipeEvent.SWIPE_LEFT;
                                break;
                            }
                            case 4: {
                                eventType = SwipeEvent.SWIPE_RIGHT;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown swipe event direction: " + n4);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.swipeEvent(eventType, n3, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, n8 == Integer.MAX_VALUE ? Double.NaN : (double)n8, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleBeginTouchEvent(View view, final long l, final int n, final boolean bl, final int n2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventBegin(l, n2, bl, (n & 1) != 0, (n & 4) != 0, (n & 8) != 0, (n & 0x10) != 0);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                GlassViewEventHandler.this.gestures.notifyBeginTouchEvent(l, n, bl, n2);
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleNextTouchEvent(View view, final long l, final int n, final long l2, final int n2, final int n3, final int n4, final int n5) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        TouchPoint.State state = null;
                        switch (n) {
                            case 811: {
                                state = TouchPoint.State.PRESSED;
                                break;
                            }
                            case 812: {
                                state = TouchPoint.State.MOVED;
                                break;
                            }
                            case 814: {
                                state = TouchPoint.State.STATIONARY;
                                break;
                            }
                            case 813: {
                                state = TouchPoint.State.RELEASED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown touch state: " + (Object)((Object)state));
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventNext(state, l2, n2, n3, n4, n5);
                    }
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                GlassViewEventHandler.this.gestures.notifyNextTouchEvent(l, n, l2, n2, n3, n4, n5);
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    @Override
    public void handleEndTouchEvent(View view, final long l) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!GlassViewEventHandler.this.toolkit()) {
                    return null;
                }
                WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
                try {
                    windowStage.setInEventHandler(true);
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventEnd();
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (verbose) {
                        runtimeException.printStackTrace();
                    }
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    if (verbose) {
                        throwable.printStackTrace();
                    }
                    throw new RuntimeException(throwable);
                }
                finally {
                    windowStage.setInEventHandler(false);
                }
                GlassViewEventHandler.this.gestures.notifyEndTouchEvent(l);
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    private class ViewEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;

        private ViewEventNotification() {
        }

        @Override
        public Void run() {
            if (verbose) {
                System.err.println("handleViewEvent(" + System.nanoTime() + "): " + GlassEventUtils.getViewEventString(this.type) + PaintCollector.sceneSize(GlassViewEventHandler.this.scene) + " closed: " + this.view.isClosed());
            }
            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null || !GlassViewEventHandler.this.toolkit()) {
                return null;
            }
            switch (this.type) {
                case 431: {
                    Window window = this.view.getWindow();
                    if (window != null && window.getMinimumWidth() == this.view.getWidth() && !window.isVisible()) break;
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    if (!PlatformUtil.isMac()) break;
                    GlassViewEventHandler.this.collector.liveRepaintRenderJob(GlassViewEventHandler.this.scene);
                    break;
                }
                case 432: {
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedSize(this.view.getWidth(), this.view.getHeight());
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    break;
                }
                case 433: {
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedLocation(this.view.getX(), this.view.getY());
                    break;
                }
                case 441: 
                case 442: {
                    if (GlassViewEventHandler.this.scene.getWindowStage() == null) break;
                    GlassViewEventHandler.this.scene.getWindowStage().fullscreenChanged(this.type == 441);
                    break;
                }
                case 411: 
                case 412: 
                case 421: 
                case 422: {
                    break;
                }
                default: {
                    throw new RuntimeException("handleViewEvent: unhandled type: " + this.type);
                }
            }
            return null;
        }
    }

    private class MouseEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int button;
        int x;
        int y;
        int xAbs;
        int yAbs;
        int clickCount;
        int modifiers;
        boolean isPopupTrigger;
        boolean isSynthesized;

        private MouseEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            int n;
            if (!GlassViewEventHandler.this.toolkit()) {
                return null;
            }
            boolean bl = GlassViewEventHandler.this.dragPerformed;
            GlassPrismMouseEvent glassPrismMouseEvent = null;
            switch (this.button) {
                case 212: {
                    n = 32;
                    break;
                }
                case 214: {
                    n = 128;
                    break;
                }
                case 213: {
                    n = 64;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            switch (this.type) {
                case 224: {
                    if (this.button == 211) break;
                    return null;
                }
                case 222: {
                    if ((GlassViewEventHandler.this.mouseButtonPressedMask & n) == 0) {
                        return null;
                    }
                    GlassViewEventHandler.this.mouseButtonPressedMask &= ~n;
                    break;
                }
                case 223: {
                    GlassViewEventHandler.this.dragPerformed = true;
                    break;
                }
                case 221: {
                    GlassViewEventHandler.this.dragPerformed = false;
                    GlassViewEventHandler.this.mouseButtonPressedMask |= n;
                    break;
                }
                case 225: 
                case 226: {
                    break;
                }
                default: {
                    if (!verbose) break;
                    System.out.println("handleMouseEvent: unhandled type: " + this.type);
                }
            }
            WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                if (windowStage != null) {
                    windowStage.setInEventHandler(true);
                }
                if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                    glassPrismMouseEvent = new GlassPrismMouseEvent(GlassViewEventHandler.this.scene, this.type, this.button, this.x, this.y, this.xAbs, this.yAbs, this.clickCount, this.modifiers, this.isPopupTrigger, this.isSynthesized, 0.0);
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.mouseEvent(glassPrismMouseEvent);
                }
                if (this.type == 222 && !bl && ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null && GlassViewEventHandler.this.toolkit()) {
                    glassPrismMouseEvent = new GlassPrismMouseEvent(GlassViewEventHandler.this.scene, 227, this.button, this.x, this.y, this.xAbs, this.yAbs, this.clickCount, this.modifiers, this.isPopupTrigger, this.isSynthesized, 0.0);
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.mouseEvent(glassPrismMouseEvent);
                }
            }
            finally {
                if (windowStage != null) {
                    windowStage.setInEventHandler(false);
                }
            }
            return null;
        }
    }

    private class KeyEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int key;
        char[] chars;
        int modifiers;

        private KeyEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void run() {
            if (!GlassViewEventHandler.this.toolkit()) {
                return null;
            }
            GlassPrismKeyEvent glassPrismKeyEvent = null;
            WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                if (windowStage != null) {
                    windowStage.setInEventHandler(true);
                }
                switch (this.type) {
                    case 111: {
                        if (this.key == 27 && this.view.isInFullscreen() && windowStage != null) {
                            windowStage.exitFullScreen();
                        }
                    }
                    case 112: 
                    case 113: {
                        if (this.view.isInFullscreen() && !GlassViewEventHandler.this.checkFullScreenKeyEvent(this.type, this.key, this.chars, this.modifiers)) {
                            return null;
                        } else {
                            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null) return null;
                            glassPrismKeyEvent = new GlassPrismKeyEvent(GlassViewEventHandler.this.scene, this.type, this.key, this.chars, this.modifiers);
                            ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.keyEvent(glassPrismKeyEvent);
                            return null;
                        }
                    }
                    default: {
                        if (!verbose) return null;
                        System.out.println("handleKeyEvent: unhandled type: " + this.type);
                        return null;
                    }
                }
            }
            finally {
                if (windowStage != null) {
                    windowStage.setInEventHandler(false);
                }
            }
        }
    }
}

