/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.animation.shared.PulseReceiver;
import javafx.animation.Animation;

public class AnimationPulseReceiver
implements PulseReceiver {
    private static final double NANO_2_TICKS = 6.0E-6;
    private final Animation animation;
    private final AbstractMasterTimer timer;
    private long startTime;
    private long pauseTime;
    private boolean paused = false;

    public AnimationPulseReceiver(Animation animation, AbstractMasterTimer abstractMasterTimer) {
        this.animation = animation;
        this.timer = abstractMasterTimer;
    }

    protected void addPulseReceiver() {
        this.timer.addPulseReceiver(this);
    }

    protected void removePulseReceiver() {
        this.timer.removePulseReceiver(this);
    }

    private long now() {
        return Math.round((double)this.timer.nanos() * 6.0E-6);
    }

    public void start(long l) {
        this.paused = false;
        this.startTime = this.now() + l;
        this.addPulseReceiver();
    }

    public void stop() {
        if (!this.paused) {
            this.removePulseReceiver();
        }
    }

    public void pause() {
        if (!this.paused) {
            this.pauseTime = this.now();
            this.paused = true;
            this.removePulseReceiver();
        }
    }

    public void resume() {
        if (this.paused) {
            long l = this.now() - this.pauseTime;
            this.startTime += l;
            this.paused = false;
            this.addPulseReceiver();
        }
    }

    @Override
    public void timePulse(long l) {
        long l2 = l - this.startTime;
        if (l2 < 0L) {
            return;
        }
        this.animation.impl_timePulse(l2);
    }
}

