/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs10.CertRequest;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class NetscapeCertRequest
implements CertRequest {
    private ASN1 a;

    public boolean verify() throws SignatureException {
        ASN1 aSN1 = null;
        byte[] byArray = null;
        Signature signature = null;
        try {
            aSN1 = new ASN1(this.a.getComponentAt(0));
            AlgorithmID algorithmID = new AlgorithmID(this.a.getComponentAt(1));
            signature = algorithmID.getSignatureInstance();
            ASN1Object aSN1Object = this.a.getComponentAt(2);
            byArray = (byte[])aSN1Object.getValue();
            signature.initVerify(this.getPublicKey());
            signature.update(aSN1.toByteArray());
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    public PublicKey getPublicKey() throws InvalidKeyException {
        try {
            return PublicKeyInfo.getPublicKey(this.a.getComponentAt(0).getComponentAt(0));
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Unable to create PublicKey: " + codingException.toString());
        }
    }

    public NetscapeCertRequest(byte[] byArray) throws CodingException {
        if (byArray == null) {
            throw new CodingException("Cannot create NetscapeCertRequest from a null byte array!");
        }
        this.a = new ASN1(byArray);
    }

    public NetscapeCertRequest(InputStream inputStream) throws CodingException, IOException {
        if (inputStream == null) {
            throw new IOException("Cannot create NetscapeCertRequest from a null inputstream!");
        }
        this.a = new ASN1(inputStream);
    }
}

