/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp.transport.tcpip;

import iaik.asn1.CodingException;
import iaik.tsp.TimeStampReq;
import iaik.tsp.TimeStampResp;
import iaik.tsp.transport.tcpip.TspTcpIpFormatException;
import iaik.tsp.transport.tcpip.TspTcpIpResponse;
import iaik.utils.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TspTcpIpProtocol {
    public TspTcpIpResponse sendRequest(TimeStampReq timeStampReq, OutputStream outputStream, InputStream inputStream) throws CodingException, TspTcpIpFormatException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = timeStampReq.getEncoded();
        dataOutputStream.writeInt(byArray.length + 1);
        dataOutputStream.writeByte(0);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        int n = dataInputStream.readInt();
        byte by = dataInputStream.readByte();
        byte[] byArray2 = null;
        TspTcpIpResponse tspTcpIpResponse = null;
        switch (by) {
            case 5: {
                byArray2 = new byte[n - 1];
                dataInputStream.readFully(byArray2);
                tspTcpIpResponse = new TspTcpIpResponse(new TimeStampResp(byArray2));
                break;
            }
            case 6: {
                byArray2 = new byte[n - 1];
                dataInputStream.readFully(byArray2);
                tspTcpIpResponse = new TspTcpIpResponse(Util.toASCIIString((byte[])byArray2));
            }
            default: {
                throw new TspTcpIpFormatException("Not supported response format");
            }
        }
        try {
            dataInputStream.close();
            dataOutputStream.close();
        }
        catch (IOException iOException) {}
        return tspTcpIpResponse;
    }
}

